/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.HashMap;
import java.util.Map;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.XPathVariable;
import org.dawb.passerelle.editors.VariableLabelProvider;
import org.dawb.passerelle.editors.XPathEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class XpathLabelProvider
extends VariableLabelProvider {
    protected final Map<IVariable.VARIABLE_TYPE, String> messageMap;
    private Font uneditableFont;
    private XPathEditor editor;

    public XpathLabelProvider(XPathEditor xPathEditor, int n, Font font) {
        super(n);
        this.editor = xPathEditor;
        this.messageMap = new HashMap<IVariable.VARIABLE_TYPE, String>(4);
        this.messageMap.put(IVariable.VARIABLE_TYPE.PATH, "A path, '");
        this.messageMap.put(IVariable.VARIABLE_TYPE.SCALAR, "A scalar value, '");
        this.messageMap.put(IVariable.VARIABLE_TYPE.ARRAY, "An array, '");
        this.messageMap.put(IVariable.VARIABLE_TYPE.IMAGE, "An image, '");
        this.messageMap.put(IVariable.VARIABLE_TYPE.XML, "An uneditable xml attribute tag, '");
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.XML, "An xml attribute, element or elements extracted using XPath. Note you can put other variables in the name, for instance 'x_${file_name}'");
        FontData fontData = font.getFontData()[0];
        this.uneditableFont = new Font(font.getDevice(), fontData.getName(), fontData.getHeight(), 2);
    }

    @Override
    public Color getForeground(Object object) {
        if (!(object instanceof IVariable)) {
            return null;
        }
        IVariable iVariable = (IVariable)object;
        if (this.column == 0) {
            return iVariable.getErrorMessage() == null ? Display.getCurrent().getSystemColor(9) : Display.getCurrent().getSystemColor(3);
        }
        if (this.column == 1) {
            if (iVariable instanceof XPathVariable) {
                if (this.editor.getActor() != null) {
                    try {
                        if (!this.editor.getActor().isUpstreamVariable(iVariable.getVariableName())) {
                            return Display.getCurrent().getSystemColor(2);
                        }
                        return Display.getCurrent().getSystemColor(15);
                    }
                    catch (Exception exception) {
                        return Display.getCurrent().getSystemColor(2);
                    }
                }
                return Display.getCurrent().getSystemColor(2);
            }
            return Display.getCurrent().getSystemColor(15);
        }
        return null;
    }

    public Font getFont(Object object) {
        if (!(object instanceof IVariable)) {
            return null;
        }
        IVariable iVariable = (IVariable)object;
        if (iVariable instanceof XPathVariable) {
            return this.editor.getActor().isUpstreamVariable(iVariable.getVariableName()) ? this.uneditableFont : null;
        }
        return this.uneditableFont;
    }

    @Override
    public String getText(Object object) {
        if (!(object instanceof IVariable)) {
            return "";
        }
        IVariable iVariable = (IVariable)object;
        switch (this.column) {
            case 0: {
                return iVariable.getVariableName();
            }
            case 1: {
                if (iVariable instanceof XPathVariable) {
                    XPathVariable xPathVariable = (XPathVariable)iVariable;
                    return xPathVariable.getxPath();
                }
                return String.valueOf(this.messageMap.get(iVariable.getVariableType())) + iVariable.getExampleValue() + "'";
            }
            case 2: {
                if (!(iVariable instanceof XPathVariable)) break;
                XPathVariable xPathVariable = (XPathVariable)iVariable;
                return xPathVariable.getRename();
            }
        }
        return "";
    }

    @Override
    public String getToolTipText(Object object) {
        IVariable iVariable = (IVariable)object;
        String string = (String)this.toolTipMap.get(iVariable.getVariableType());
        if (this.column == 2) {
            string = "The top level tag extracted can be renamed.\nUsed when the object extracted is renamed before being substituted into the next node.";
        }
        if (iVariable.getErrorMessage() != null) {
            return String.valueOf(string) + "\n" + iVariable.getErrorMessage();
        }
        return string;
    }
}

