/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.ui.widgets.DoubleClickModifier;
import org.dawb.common.util.io.PropUtils;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.VariableUtils;
import org.dawb.passerelle.common.message.XPathVariable;
import org.dawb.passerelle.editors.EdnaActorActions;
import org.dawb.passerelle.editors.XPathComparitor;
import org.dawb.passerelle.editors.XPathParticipant;
import org.dawb.passerelle.editors.XpathLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.Workspace;

public class XPathEditor
extends EditorPart {
    private static Logger logger = LoggerFactory.getLogger(XPathEditor.class);
    private TableViewer viewer;
    private final String momlPath;
    private final String actorName;
    private XPathParticipant actor;
    private List<IVariable> upstream;
    private List<IVariable> variables;
    private boolean isDirty = false;
    private CLabel messageLabel;
    private ToolBarManager toolMan;
    private MenuManager menuMan;

    public XPathEditor(String string, String string2) {
        this.actorName = string;
        this.momlPath = string2;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridUtils.removeMargins((Composite)composite2);
        Composite composite3 = new Composite(composite2, 131072);
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridUtils.removeMargins((Composite)composite3);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.messageLabel = new CLabel(composite3, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 230;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setForeground(Display.getCurrent().getSystemColor(16));
        this.messageLabel.setToolTipText("Create variables from the output xml using XPaths.");
        Image image = Activator.getImageDescriptor("icons/editable.png").createImage();
        this.messageLabel.setImage(image);
        this.messageLabel.setText("Edit/create output variables");
        this.toolMan = new ToolBarManager(0x804000);
        ToolBar toolBar = this.toolMan.createControl(composite3);
        toolBar.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        EdnaActorActions.createOutputActions((IContributionManager)this.toolMan);
        this.viewer = new TableViewer(composite2, 68356);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.createColumns(this.viewer);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(new String[]{"Name", "XPath", "Rename Tag"});
        this.viewer.setCellEditors(this.createCellEditors(this.viewer));
        this.viewer.setCellModifier(this.createModifier(this.viewer));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                XPathEditor.this.updateActions();
            }
        });
        this.toolMan.update(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createRightClickMenu();
        this.updateActions();
    }

    private void createRightClickMenu() {
        this.menuMan = new MenuManager();
        this.viewer.getControl().setMenu(this.menuMan.createContextMenu(this.viewer.getControl()));
        EdnaActorActions.createOutputActions((IContributionManager)this.menuMan);
    }

    private void updateActions() {
        EdnaActorActions.deleteXPath.setEnabled(this.getSelected() != null);
    }

    private CellEditor[] createCellEditors(TableViewer tableViewer) {
        CellEditor[] cellEditorArray = new CellEditor[3];
        TextCellEditor textCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        ((Text)textCellEditor.getControl()).setTextLimit(255);
        cellEditorArray[0] = textCellEditor;
        cellEditorArray[1] = textCellEditor;
        cellEditorArray[2] = textCellEditor;
        return cellEditorArray;
    }

    private ICellModifier createModifier(TableViewer tableViewer) {
        return new DoubleClickModifier((ColumnViewer)tableViewer){

            public boolean canModify(Object object, String string) {
                if (!this.enabled) {
                    return false;
                }
                IVariable iVariable = (IVariable)object;
                if (!(iVariable instanceof XPathVariable)) {
                    return false;
                }
                try {
                    if (XPathEditor.this.upstream.contains(iVariable)) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot read output variables for " + XPathEditor.this.actor.getName(), (Throwable)exception);
                }
                return true;
            }

            public Object getValue(Object object, String string) {
                IVariable iVariable = (IVariable)object;
                if (!(iVariable instanceof XPathVariable)) {
                    return null;
                }
                String string2 = null;
                if ("Name".equals(string)) {
                    string2 = ((XPathVariable)object).getVariableName();
                } else if ("XPath".equals(string)) {
                    string2 = ((XPathVariable)object).getxPath();
                } else if ("Rename Tag".equals(string)) {
                    string2 = ((XPathVariable)object).getRename();
                }
                return string2 != null ? string2 : "";
            }

            public void modify(Object object, String string, Object object2) {
                try {
                    IVariable iVariable = XPathEditor.this.getSelected();
                    if (!(iVariable instanceof XPathVariable)) {
                        return;
                    }
                    try {
                        String string2;
                        XPathVariable xPathVariable = (XPathVariable)iVariable;
                        if ("Name".equals(string)) {
                            xPathVariable.setVariableName((String)object2);
                        } else if ("XPath".equals(string)) {
                            string2 = (String)object2;
                            xPathVariable.setxPath(string2);
                        } else if ("Rename Tag".equals(string)) {
                            string2 = (String)object2;
                            xPathVariable.setRename(string2);
                        }
                        string2 = XPathEditor.this.actor.getExampleValue(xPathVariable.getxPath(), xPathVariable.getRename());
                        xPathVariable.setExampleValue((Object)string2);
                        XPathEditor.this.isDirty = true;
                        XPathEditor.this.viewer.refresh();
                        XPathEditor.this.firePropertyChange(257);
                        XPathEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)xPathVariable));
                    }
                    catch (Exception exception) {
                        logger.error("Cannot set " + string, (Throwable)exception);
                    }
                }
                finally {
                    this.setEnabled(false);
                }
            }
        };
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
        this.createActorContentProvider();
    }

    private void createActorContentProvider() {
        MoMLParser.purgeAllModelRecords();
        MoMLParser moMLParser = new MoMLParser(new Workspace());
        try {
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.momlPath);
            iResource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            CompositeActor compositeActor = (CompositeActor)moMLParser.parse(null, new File(iResource.getLocation().toString()).toURL());
            compositeActor.workspace().setName(iResource.getProject().getName());
            ComponentEntity componentEntity = ModelUtils.findEntityByName((CompositeActor)compositeActor, (String)this.actorName);
            if (componentEntity != null && componentEntity.getName().equals(this.actorName)) {
                this.actor = (XPathParticipant)componentEntity;
                this.variables = this.createVariables(this.actor.getXPathVariables());
                this.upstream = this.createVariables(this.actor.getUpstreamVariables());
                Iterator<IVariable> iterator = this.upstream.iterator();
                while (iterator.hasNext()) {
                    if (!this.variables.contains(iterator.next())) continue;
                    iterator.remove();
                }
                this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object object, Object object2) {
                    }

                    public Object[] getElements(Object object) {
                        if (XPathEditor.this.actor == null) {
                            return new Object[]{""};
                        }
                        ArrayList arrayList = new ArrayList(7);
                        if (XPathEditor.this.variables != null) {
                            arrayList.addAll(XPathEditor.this.variables);
                        }
                        if (XPathEditor.this.upstream != null) {
                            arrayList.addAll(XPathEditor.this.upstream);
                        }
                        if (arrayList.size() > 0) {
                            return arrayList.toArray(new IVariable[arrayList.size()]);
                        }
                        return new Object[]{""};
                    }
                });
                this.viewer.setInput(new Object());
            }
        }
        catch (Exception exception) {
            logger.error("Cannot parse " + this.momlPath, (Throwable)exception);
        }
    }

    private List<IVariable> createVariables(List<IVariable> list) {
        TreeSet<IVariable> treeSet = new TreeSet<IVariable>(new XPathComparitor(this.actor));
        treeSet.addAll(list);
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        arrayList.addAll(treeSet);
        return arrayList;
    }

    private void createColumns(TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Name");
        tableViewerColumn.getColumn().setWidth(300);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new XpathLabelProvider(this, 0, tableViewer.getTable().getFont()));
        tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 1);
        tableViewerColumn.getColumn().setText("XPath");
        tableViewerColumn.getColumn().setWidth(600);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new XpathLabelProvider(this, 1, tableViewer.getTable().getFont()));
        tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 2);
        tableViewerColumn.getColumn().setText("Rename Tag");
        tableViewerColumn.getColumn().setWidth(300);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new XpathLabelProvider(this, 2, tableViewer.getTable().getFont()));
    }

    public void dispose() {
        super.dispose();
        this.viewer.getTable().dispose();
    }

    public XPathParticipant getActor() {
        return this.actor;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (!this.isDirty()) {
            return;
        }
        iProgressMonitor.beginTask("Save " + this.getEditorInput().getName(), 10);
        try {
            for (IVariable properties2 : this.variables) {
                if (properties2.getErrorMessage() == null) continue;
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Invalid XPath", (String)("The variable '" + properties2.getVariableName() + "' is invalid.\n\n" + properties2.getErrorMessage()));
                return;
            }
            Properties properties = new Properties();
            for (IVariable iVariable : this.variables) {
                if (iVariable == null) continue;
                String string = iVariable.getVariableName();
                String string2 = iVariable instanceof XPathVariable ? ((XPathVariable)iVariable).getSaveString() : "";
                properties.setProperty(string, string2);
            }
            try {
                PropUtils.storeProperties((Properties)properties, (File)EclipseUtils.getFile((IEditorInput)this.getEditorInput()));
                this.isDirty = false;
                this.firePropertyChange(257);
                EclipseUtils.getIFile((IEditorInput)this.getEditorInput()).refreshLocal(1, iProgressMonitor);
            }
            catch (Exception exception) {
                logger.error("Cannot save " + EclipseUtils.getFile((IEditorInput)this.getEditorInput()), (Throwable)exception);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void addVariable() {
        String string = VariableUtils.getUniqueVariableName((String)"new_xpath", this.variables);
        XPathVariable xPathVariable = new XPathVariable(string, "/");
        IVariable iVariable = this.getSelected();
        int n = iVariable != null ? this.variables.indexOf(iVariable) : this.variables.size() - 1;
        this.variables.add(n + 1, (IVariable)xPathVariable);
        this.viewer.refresh();
        this.viewer.editElement((Object)xPathVariable, 0);
        this.isDirty = true;
        this.firePropertyChange(257);
        this.updateActions();
    }

    public void deleteVariable() {
        IVariable iVariable = this.getSelected();
        if (iVariable == null) {
            return;
        }
        this.variables.remove(iVariable);
        this.viewer.refresh();
        this.isDirty = true;
        this.firePropertyChange(257);
        this.updateActions();
    }

    public void revert() {
        if (this.variables != null) {
            this.variables.clear();
        }
        this.variables = null;
        if (this.upstream != null) {
            this.upstream.clear();
        }
        this.upstream = null;
        this.createActorContentProvider();
        this.viewer.refresh();
    }

    public IVariable getSelected() {
        return (IVariable)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
    }
}

