/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.editors.EdnaActorActions;
import org.dawb.passerelle.editors.ISubstitutionEditor;
import org.dawb.passerelle.editors.SubstitutionParticipant;
import org.dawb.passerelle.editors.VariableCharacterMatcher;
import org.dawb.passerelle.editors.VariableLabelProvider;
import org.dawb.passerelle.editors.VariablePainter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.Workspace;

public class XMLSubstitutionEditor
extends StructuredTextEditor
implements ISubstitutionEditor {
    public static final String ID = "org.dawb.passerelle.editors.substitutionEditor";
    private static Logger logger = LoggerFactory.getLogger(XMLSubstitutionEditor.class);
    private String momlPath;
    private String actorName;
    private TableViewer viewer;
    private SubstitutionParticipant actor;
    private CLabel messageLabel;
    private TextSelection currentSelectedText;
    private Image editableImage;
    private Image uneditableImage;
    private String replaceText;

    public XMLSubstitutionEditor(String string, String string2) {
        this.actorName = string;
        this.momlPath = string2;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridUtils.removeMargins((Composite)composite2);
        Composite composite3 = new Composite(composite2, 131072);
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridUtils.removeMargins((Composite)composite3);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.messageLabel = new CLabel(composite3, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 230;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setForeground(Display.getCurrent().getSystemColor(16));
        this.messageLabel.setToolTipText("Insert variables to the template xml on the right,\nthis will be replaced and sent to EDNA when the workflow is run.");
        ToolBarManager toolBarManager = new ToolBarManager(0x804000);
        ToolBar toolBar = toolBarManager.createControl(composite3);
        toolBar.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        EdnaActorActions.createInputActions((IContributionManager)toolBarManager);
        SashForm sashForm = new SashForm(composite2, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer((Composite)sashForm, 68356);
        this.createColumns(this.viewer);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        Composite composite4 = new Composite((Composite)sashForm, 0);
        composite4.setLayout((Layout)new FillLayout());
        super.createPartControl(composite4);
        sashForm.setWeights(new int[]{20, 80});
        VariableCharacterMatcher variableCharacterMatcher = new VariableCharacterMatcher((SourceViewer)this.getSourceViewer());
        VariablePainter variablePainter = new VariablePainter(this.getSourceViewer(), variableCharacterMatcher);
        ((SourceViewer)this.getSourceViewer()).addPainter((IPainter)variablePainter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)variableCharacterMatcher);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                XMLSubstitutionEditor.this.doInsert();
            }
        });
        ((SourceViewer)this.getSourceViewer()).addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof TextSelection) {
                    XMLSubstitutionEditor.this.currentSelectedText = (TextSelection)iSelection;
                    XMLSubstitutionEditor.this.updateMessageLabel();
                    return;
                }
                XMLSubstitutionEditor.this.currentSelectedText = null;
                XMLSubstitutionEditor.this.updateMessageLabel();
            }
        });
        toolBarManager.update(true);
        this.setWritable(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createUndoRedoActions();
        this.createRightClickMenu();
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
        EdnaActorActions.createInputActions((IContributionManager)menuManager);
    }

    protected void setWritable(boolean bl) {
        if (this.editableImage == null) {
            this.editableImage = Activator.getImageDescriptor("icons/editable.png").createImage();
        }
        if (this.uneditableImage == null) {
            this.uneditableImage = Activator.getImageDescriptor("icons/uneditable.png").createImage();
        }
        this.getTextViewer().setEditable(bl);
        this.viewer.getTable().setEnabled(bl);
        this.updateMessageLabel(bl);
    }

    private void updateMessageLabel() {
        this.updateMessageLabel(this.viewer.getTable().isEnabled());
    }

    private void updateMessageLabel(boolean bl) {
        if (bl) {
            if (this.currentSelectedText != null) {
                this.messageLabel.setImage(this.editableImage);
                this.messageLabel.setText("Double click to insert.");
            } else {
                this.messageLabel.setImage(this.editableImage);
                this.messageLabel.setText("Select some text.");
            }
        } else {
            this.messageLabel.setImage(this.uneditableImage);
            this.messageLabel.setText("Uneditable.");
        }
        this.messageLabel.getParent().layout(new Control[]{this.messageLabel});
    }

    private void doInsert() {
        try {
            StructuredSelection structuredSelection = (StructuredSelection)this.viewer.getSelection();
            if (structuredSelection == null) {
                return;
            }
            IVariable iVariable = (IVariable)structuredSelection.getFirstElement();
            IDocument iDocument = this.getTextViewer().getDocument();
            String string = "${" + iVariable.getVariableName() + "}";
            if (this.currentSelectedText != null) {
                int n = this.currentSelectedText.getOffset() + this.currentSelectedText.getLength();
                int n2 = this.currentSelectedText.getLength();
                int n3 = iDocument.getLength();
                if (n > n3) {
                    n2 = n3 - this.currentSelectedText.getOffset();
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                iDocument.replace(this.currentSelectedText.getOffset(), n2, string);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error("Cannot replace selection " + this.getTextViewer().getSelectedRange(), (Throwable)badLocationException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (!this.viewer.getTable().isEnabled()) {
            EdnaActorActions.showVars.setChecked(true);
            this.setPreview(false);
        }
        super.doSave(iProgressMonitor);
    }

    public void setFocus() {
        super.setFocus();
        MoMLParser.purgeAllModelRecords();
        if (this.actor == null && this.momlPath != null) {
            MoMLParser moMLParser = new MoMLParser(new Workspace());
            try {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.momlPath);
                CompositeActor compositeActor = (CompositeActor)moMLParser.parse(null, new File(iResource.getLocation().toString()).toURL());
                compositeActor.workspace().setName(iResource.getProject().getName());
                ComponentEntity componentEntity = ModelUtils.findEntityByName((CompositeActor)compositeActor, (String)this.actorName);
                if (componentEntity != null && componentEntity.getName().equals(this.actorName)) {
                    this.actor = (SubstitutionParticipant)componentEntity;
                }
            }
            catch (Exception exception) {
                logger.error("Cannot parse " + this.momlPath, (Throwable)exception);
            }
        }
        if (this.actor != null) {
            this.viewer.setContentProvider(this.createActorContentProvider());
            this.viewer.setInput(new Object());
        }
    }

    private IContentProvider createActorContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                if (XMLSubstitutionEditor.this.actor == null) {
                    return new Object[]{"-"};
                }
                List<IVariable> list = XMLSubstitutionEditor.this.actor.getInputVariables();
                if (list != null && !list.isEmpty()) {
                    return list.toArray();
                }
                return new Object[]{"-"};
            }
        };
    }

    private void createColumns(TableViewer tableViewer) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Name");
        tableViewerColumn.getColumn().setWidth(80);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new VariableLabelProvider(0));
    }

    public void dispose() {
        super.dispose();
        this.viewer.getTable().dispose();
        if (this.editableImage != null) {
            this.editableImage.dispose();
        }
        if (this.uneditableImage != null) {
            this.uneditableImage.dispose();
        }
    }

    @Override
    public void revert() {
        if (this.actor != null) {
            this.setWritable(true);
            this.getTextViewer().getDocument().set(this.actor.getDefaultSubstitution());
        }
    }

    public void setText(String string, boolean bl) {
        this.setWritable(bl);
        this.getTextViewer().getDocument().set(string);
        this.getTextViewer().refresh();
        this.update();
    }

    public String getText() {
        return this.getTextViewer().getDocument().get();
    }

    public String getReplaceText() {
        return this.replaceText;
    }

    public void setReplaceText(String string) {
        this.replaceText = string;
    }

    public SubstitutionParticipant getActor() {
        return this.actor;
    }

    @Override
    public void setPreview(boolean bl) {
        if (!bl) {
            String string = this.getReplaceText();
            if (string == null) {
                return;
            }
            this.setText(string, true);
            this.setReplaceText(null);
        } else {
            EclipseUtils.getActivePage().saveEditor((IEditorPart)this, false);
            Map<String, String> map = this.actor.getExampleValues();
            String string = this.getText();
            this.setReplaceText(string);
            String string2 = SubstituteUtils.substitute((String)string, map);
            this.setText(string2, false);
        }
    }
}

