/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.editors.VariableCharacterMatcher;
import org.dawb.passerelle.editors.VariablePosition;
import org.dawb.passerelle.editors.VariableRegion;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VariablePainter
implements IPainter,
PaintListener {
    private static Logger logger = LoggerFactory.getLogger(VariablePainter.class);
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private Color backColor;
    private Color selColor;
    private Color blackColor;
    private IPaintPositionManager fPaintPositionManager;
    private VariableCharacterMatcher fMatcher;
    private List<VariablePosition> fPairPositions;

    public VariablePainter(ISourceViewer iSourceViewer, VariableCharacterMatcher variableCharacterMatcher) {
        this.fSourceViewer = iSourceViewer;
        this.fMatcher = variableCharacterMatcher;
        this.fTextWidget = iSourceViewer.getTextWidget();
        this.fPairPositions = new ArrayList<VariablePosition>(7);
        this.selColor = Display.getCurrent().getSystemColor(9);
        this.blackColor = Display.getCurrent().getSystemColor(2);
        this.backColor = new Color((Device)Display.getCurrent(), 230, 230, 228);
    }

    public void dispose() {
        if (this.fMatcher != null) {
            this.fMatcher.clear();
            this.fMatcher = null;
        }
        this.selColor = null;
        this.blackColor = null;
        this.backColor.dispose();
        this.backColor = null;
        this.fTextWidget = null;
    }

    public void deactivate(boolean bl) {
        this.fTextWidget.removePaintListener((PaintListener)this);
        if (this.fPaintPositionManager != null) {
            for (Position position : this.fPairPositions) {
                this.fPaintPositionManager.unmanagePosition(position);
                position.delete();
            }
        }
        if (bl) {
            this.handleDrawRequest(null);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(paintEvent.gc);
        }
    }

    private void handleDrawRequest(GC gC) {
        for (VariablePosition variablePosition : this.fPairPositions) {
            int n;
            int n2;
            IDocument iDocument;
            IRegion iRegion;
            ITextViewerExtension5 iTextViewerExtension5;
            if (variablePosition.isDeleted) continue;
            int n3 = variablePosition.getOffset();
            int n4 = variablePosition.getLength();
            if (n4 < 1) {
                return;
            }
            if (this.fSourceViewer instanceof ITextViewerExtension5) {
                iTextViewerExtension5 = (ITextViewerExtension5)this.fSourceViewer;
                iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(n3, n4));
                if (iRegion == null) {
                    return;
                }
                try {
                    iDocument = this.fSourceViewer.getDocument();
                    n2 = iDocument.getLineOfOffset(n3);
                    n = iDocument.getLineOfOffset(n3 + n4);
                    if (iTextViewerExtension5.modelLine2WidgetLine(n2) == -1 || iTextViewerExtension5.modelLine2WidgetLine(n) == -1) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                n3 = iRegion.getOffset();
                n4 = iRegion.getLength();
            } else if (this.fSourceViewer instanceof SourceViewer) {
                iTextViewerExtension5 = (SourceViewer)this.fSourceViewer;
                iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(n3, n4));
                if (iRegion == null) {
                    return;
                }
                try {
                    iDocument = this.fSourceViewer.getDocument();
                    n2 = iDocument.getLineOfOffset(n3);
                    n = iDocument.getLineOfOffset(n3 + n4);
                    if (iTextViewerExtension5.modelLine2WidgetLine(n2) == -1 || iTextViewerExtension5.modelLine2WidgetLine(n) == -1) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                n3 = iRegion.getOffset();
                n4 = iRegion.getLength();
            } else {
                iTextViewerExtension5 = this.fSourceViewer.getVisibleRegion();
                if (iTextViewerExtension5.getOffset() > n3 || iTextViewerExtension5.getOffset() + iTextViewerExtension5.getLength() < n3 + n4) {
                    return;
                }
                n3 -= iTextViewerExtension5.getOffset();
                n4 = iTextViewerExtension5.getLength();
            }
            this.draw(gC, n3, n4, variablePosition.isSelected() ? this.selColor : this.blackColor);
        }
    }

    private void draw(GC gC, int n, int n2, Color color) {
        if (gC != null) {
            Rectangle rectangle;
            if (n2 > 0) {
                rectangle = this.fTextWidget.getTextBounds(n, n + n2 - 1);
            } else {
                Point point = this.fTextWidget.getLocationAtOffset(n);
                rectangle = new Rectangle(point.x, point.y, 1, this.fTextWidget.getLineHeight(n));
            }
            gC.setBackground(this.backColor);
            gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            gC.setForeground(color);
            gC.drawText(this.fTextWidget.getText(n, n + n2 - 1), rectangle.x, rectangle.y);
        } else {
            this.fTextWidget.redrawRange(n, n2, true);
        }
    }

    public void paint(int n) {
        IDocument iDocument = this.fSourceViewer.getDocument();
        if (iDocument == null) {
            this.deactivate(false);
            return;
        }
        Point point = this.fSourceViewer.getSelectedRange();
        if (point.y > 0) {
            this.deactivate(true);
            return;
        }
        IRegion[] iRegionArray = null;
        try {
            iRegionArray = this.fMatcher.match(iDocument);
            if (iRegionArray == null) {
                this.deactivate(true);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error("Cannot match variables", (Throwable)badLocationException);
            this.deactivate(true);
            return;
        }
        this.fTextWidget.addPaintListener((PaintListener)this);
        if (16 == n) {
            this.handleDrawRequest(null);
        } else if (iRegionArray.length > -1) {
            if (iRegionArray.length < this.fPairPositions.size()) {
                while (iRegionArray.length < this.fPairPositions.size()) {
                    VariablePosition variablePosition = this.fPairPositions.remove(this.fPairPositions.size() - 1);
                    this.fPaintPositionManager.unmanagePosition((Position)variablePosition);
                    variablePosition.isDeleted = true;
                }
            } else if (iRegionArray.length > this.fPairPositions.size()) {
                int n2 = this.fPairPositions.size();
                while (n2 < iRegionArray.length) {
                    this.fPairPositions.add(new VariablePosition(0, 0));
                    this.fPaintPositionManager.managePosition((Position)this.fPairPositions.get(n2));
                    ++n2;
                }
            }
            int n3 = 0;
            while (n3 < iRegionArray.length) {
                IRegion iRegion = iRegionArray[n3];
                VariablePosition variablePosition = this.fPairPositions.get(n3);
                if (iRegion instanceof VariableRegion) {
                    variablePosition.setVariableType(((VariableRegion)iRegion).getVariableType());
                }
                if (iRegion.getOffset() != variablePosition.getOffset() || iRegion.getLength() != variablePosition.getLength()) {
                    variablePosition.isDeleted = false;
                    variablePosition.offset = iRegion.getOffset();
                    variablePosition.length = iRegion.getLength();
                } else {
                    variablePosition.isDeleted = false;
                    variablePosition.offset = iRegion.getOffset();
                    variablePosition.length = iRegion.getLength();
                }
                ++n3;
            }
            this.handleDrawRequest(null);
        }
    }

    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
        this.fPaintPositionManager = iPaintPositionManager;
    }
}

