/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.HashMap;
import java.util.Map;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.common.message.IVariable;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class VariableLabelProvider
extends ColumnLabelProvider {
    protected final int column;
    protected final Map<IVariable.VARIABLE_TYPE, Image> imageMap;
    protected final Map<IVariable.VARIABLE_TYPE, String> toolTipMap;

    public VariableLabelProvider(int n) {
        this.column = n;
        this.imageMap = new HashMap<IVariable.VARIABLE_TYPE, Image>(4);
        this.toolTipMap = new HashMap<IVariable.VARIABLE_TYPE, String>(4);
        this.imageMap.put(IVariable.VARIABLE_TYPE.PATH, Activator.getImageDescriptor("icons/variable_file.gif").createImage());
        this.imageMap.put(IVariable.VARIABLE_TYPE.SCALAR, Activator.getImageDescriptor("icons/variable_scalar.gif").createImage());
        this.imageMap.put(IVariable.VARIABLE_TYPE.ARRAY, Activator.getImageDescriptor("icons/variable_array.gif").createImage());
        this.imageMap.put(IVariable.VARIABLE_TYPE.IMAGE, Activator.getImageDescriptor("icons/variable_image.gif").createImage());
        this.imageMap.put(IVariable.VARIABLE_TYPE.XML, Activator.getImageDescriptor("icons/variable_xml.png").createImage());
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.PATH, "A path to a file read from the previous node.");
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.SCALAR, "A scalar value such as a text string or a number.");
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.ARRAY, "A data array with unspecified dimensions.");
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.IMAGE, "An image, a two dimensional array.");
        this.toolTipMap.put(IVariable.VARIABLE_TYPE.XML, "An xml attribute, element or elements extracted using XPath.");
    }

    public Color getForeground(Object object) {
        if (!(object instanceof IVariable)) {
            return null;
        }
        if (this.column == 0) {
            return Display.getCurrent().getSystemColor(9);
        }
        return null;
    }

    public Image getImage(Object object) {
        if (!(object instanceof IVariable)) {
            return null;
        }
        IVariable iVariable = (IVariable)object;
        if (this.column == 0) {
            return this.imageMap.get(iVariable.getVariableType());
        }
        return null;
    }

    public String getText(Object object) {
        if (!(object instanceof IVariable)) {
            return "";
        }
        IVariable iVariable = (IVariable)object;
        switch (this.column) {
            case 0: {
                return iVariable.getVariableName();
            }
        }
        return "";
    }

    public String getToolTipText(Object object) {
        if (!(object instanceof IVariable)) {
            return null;
        }
        IVariable iVariable = (IVariable)object;
        return this.toolTipMap.get(iVariable.getVariableType());
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
    }
}

