/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.ArrayList;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.editors.VariableRegion;
import org.dawb.passerelle.editors.VariableType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableCharacterMatcher
implements ISelectionChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(VariableCharacterMatcher.class);
    private IVariable selectedVariable;
    private SourceViewer textViewer;

    public VariableCharacterMatcher(SourceViewer sourceViewer) {
        this.textViewer = sourceViewer;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (!(structuredSelection.getFirstElement() instanceof IVariable)) {
            return;
        }
        IVariable iVariable = (IVariable)structuredSelection.getFirstElement();
        TableViewer tableViewer = (TableViewer)selectionChangedEvent.getSource();
        this.selectedVariable = !tableViewer.getTable().isEnabled() ? null : iVariable;
        int n = this.textViewer.getTextWidget().getCaretOffset();
        this.textViewer.setRedraw(false);
        this.textViewer.refresh();
        this.textViewer.getTextWidget().setSelection(n, n);
        this.textViewer.setRedraw(true);
    }

    public void dispose() {
        this.selectedVariable = null;
        this.textViewer = null;
    }

    public void clear() {
    }

    public IRegion[] match(IDocument iDocument) throws BadLocationException {
        VariableRegion variableRegion;
        int n;
        if (iDocument == null || iDocument.getLength() < 1) {
            return null;
        }
        ArrayList<VariableRegion> arrayList = new ArrayList<VariableRegion>(7);
        String string = iDocument.get();
        int n2 = 0;
        try {
            while (string != null) {
                int n3 = string.indexOf("${");
                if (n3 >= 0 && (n = string.substring(n3).indexOf("}") + 1) > 0) {
                    variableRegion = new VariableRegion(n2 + n3, n, VariableType.NORMAL);
                    arrayList.add(variableRegion);
                    n2 = n2 + n3 + n;
                    string = string.substring(n3 + n);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            logger.error("Did not process all variables in file");
        }
        if (this.selectedVariable != null) {
            String string2 = "${" + this.selectedVariable.getVariableName() + "}";
            string = iDocument.get();
            n2 = 0;
            while (string != null) {
                n = string.indexOf(string2);
                if (n < 0) break;
                variableRegion = new VariableRegion(n2 + n, string2.length(), VariableType.SELECTED);
                arrayList.add(variableRegion);
                n2 = n2 + n + string2.length();
                string = string.substring(n + string2.length());
            }
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new IRegion[arrayList.size()]);
        }
        return null;
    }
}

