/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.dawb.common.ui.viewers.AppliableTableViewer;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.text.NumberUtils;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.actors.ui.config.FieldBean;
import org.dawb.passerelle.actors.ui.config.FieldContainer;
import org.dawb.workbench.jmx.RemoveWorkbenchPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.cell.FieldComponentCellEditor;
import uk.ac.gda.richbeans.components.file.FileBox;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.wrappers.ComboWrapper;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;
import uk.ac.gda.richbeans.components.wrappers.TextWrapper;

public class UserModifyComposite
extends Composite
implements RemoveWorkbenchPart {
    private static Logger logger = LoggerFactory.getLogger(UserModifyComposite.class);
    private String partName;
    private Closeable closeable;
    private AppliableTableViewer tableViewer;
    private Queue<Map<String, String>> queue;
    private Map<String, String> values;
    private Map<String, String> originalValues;
    private FieldContainer configuration;
    private Label customLabel;
    private boolean messageOnly = false;
    protected final Action confirm = new Action("Confirm values, close view and continue workflow.", Activator.getImageDescriptor("icons/application_form_confirm.png")){

        public void run() {
            UserModifyComposite.this.doConfirm();
            UserModifyComposite.this.closeable.close();
        }
    };
    protected final Action stop = new Action("Stop workflow downstream of this node.", Activator.getImageDescriptor("icons/stop_workflow.gif")){

        public void run() {
            UserModifyComposite.this.doStop();
            UserModifyComposite.this.closeable.close();
        }
    };
    protected final Action add = new Action("Add a new scalar value", Activator.getImageDescriptor("icons/application_form_add.png")){

        public void run() {
            UserModifyComposite.this.addScalar();
        }
    };
    protected final Action delete = new Action("Delete selected scalar value", Activator.getImageDescriptor("icons/application_form_delete.png")){

        public void run() {
            Map.Entry entry;
            ISelection iSelection = UserModifyComposite.this.tableViewer.getSelection();
            if (iSelection != null && iSelection instanceof StructuredSelection && (entry = (Map.Entry)((StructuredSelection)iSelection).getFirstElement()) != null) {
                UserModifyComposite.this.values.remove(entry.getKey());
                UserModifyComposite.this.tableViewer.refresh();
            }
        }
    };

    public UserModifyComposite(Composite composite, Closeable closeable, int n) {
        super(composite, n);
        this.closeable = closeable;
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.customLabel = new Label((Composite)this, 64);
        this.customLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Activator.getDefault();
        Image image = Activator.getImageDescriptor("icons/information.gif").createImage();
        this.customLabel.setImage(image);
        GridUtils.setVisible((Control)this.customLabel, (boolean)false);
        this.tableViewer = new AppliableTableViewer((Composite)this, 68356);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns((TableViewer)this.tableViewer);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(new String[]{"Scalar Name", "Value"});
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                if (UserModifyComposite.this.values == null || UserModifyComposite.this.values.isEmpty()) {
                    return new Object[0];
                }
                Set set = UserModifyComposite.this.values.entrySet();
                return set.toArray(new Map.Entry[set.size()]);
            }
        });
        this.tableViewer.setInput(new Object());
        this.tableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 22;
            }
        });
    }

    public ColumnViewer getViewer() {
        return this.tableViewer;
    }

    private void createColumns(final TableViewer tableViewer) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Scalar Name");
        tableViewerColumn.getColumn().setWidth(200);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object object) {
                FieldBean fieldBean;
                String string = (String)((Map.Entry)object).getKey();
                if (UserModifyComposite.this.configuration != null && UserModifyComposite.this.configuration.getBean(string) != null && (fieldBean = UserModifyComposite.this.configuration.getBean(string)).getUiLabel() != null && !"".equals(fieldBean.getUiLabel())) {
                    return null;
                }
                return Display.getCurrent().getSystemColor(9);
            }

            public String getText(Object object) {
                FieldBean fieldBean;
                String string = (String)((Map.Entry)object).getKey();
                if (UserModifyComposite.this.configuration != null && UserModifyComposite.this.configuration.getBean(string) != null && (fieldBean = UserModifyComposite.this.configuration.getBean(string)).getUiLabel() != null && !"".equals(fieldBean.getUiLabel())) {
                    return fieldBean.getUiLabel();
                }
                return string;
            }

            public String getToolTipText(Object object) {
                return "Variable name '" + (String)((Map.Entry)object).getKey() + "'";
            }
        });
        tableViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){

            protected void setValue(Object object, Object object2) {
                String string = (String)UserModifyComposite.this.values.remove(((Map.Entry)object).getKey());
                if (object2 == null || "".equals(object2)) {
                    return;
                }
                UserModifyComposite.this.values.put((String)object2, string);
                tableViewer.refresh();
            }

            protected Object getValue(Object object) {
                return ((Map.Entry)object).getKey();
            }

            protected CellEditor getCellEditor(Object object) {
                TextCellEditor textCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
                textCellEditor.getControl().setForeground(Display.getCurrent().getSystemColor(9));
                return textCellEditor;
            }

            protected boolean canEdit(Object object) {
                String string = (String)((Map.Entry)object).getKey();
                return UserModifyComposite.this.configuration == null || !UserModifyComposite.this.configuration.containsBean(string);
            }
        });
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(tableViewer, 16384, 1);
        tableViewerColumn2.getColumn().setText("Value");
        tableViewerColumn2.getColumn().setWidth(600);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                String string = (String)((Map.Entry)object).getKey();
                String string2 = (String)UserModifyComposite.this.values.get(string);
                if (UserModifyComposite.this.configuration != null && UserModifyComposite.this.configuration.containsBean(string)) {
                    FieldBean fieldBean = UserModifyComposite.this.configuration.getBean(string);
                    if (fieldBean.getUnit() != null && fieldBean.getUiClass().endsWith(".StandardBox")) {
                        string2 = String.valueOf(string2) + " " + fieldBean.getUnit();
                    }
                    if (fieldBean.isPassword() && fieldBean.getUiClass().endsWith(".TextWrapper")) {
                        string2 = UserModifyComposite.this.getStars(string2.length());
                    }
                }
                return string2;
            }
        });
        tableViewerColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){

            protected void setValue(Object object, Object object2) {
                if (object2 != null && !"".equals(object2)) {
                    ((Map.Entry)object).setValue(object2.toString());
                } else {
                    ((Map.Entry)object).setValue(null);
                }
                tableViewer.refresh();
            }

            protected Object getValue(Object object) {
                String string = (String)((Map.Entry)object).getValue();
                return NumberUtils.getNumberIfParses((String)string);
            }

            protected CellEditor getCellEditor(Object object) {
                String string = (String)((Map.Entry)object).getKey();
                if (UserModifyComposite.this.configuration != null && UserModifyComposite.this.configuration.containsBean(string)) {
                    return UserModifyComposite.this.createFieldWidgetEditor(UserModifyComposite.this.configuration.getBean(string));
                }
                return new TextCellEditor((Composite)tableViewer.getTable());
            }

            protected boolean canEdit(Object object) {
                return true;
            }
        });
    }

    protected String getStars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("*");
            ++n2;
        }
        return stringBuilder.toString();
    }

    private CellEditor createFieldWidgetEditor(FieldBean fieldBean) {
        String string = fieldBean.getUiClass();
        try {
            FieldComponentCellEditor fieldComponentCellEditor;
            IFieldWidget iFieldWidget;
            int n = 0;
            if (fieldBean.getUiClass().equals(ComboWrapper.class.getName())) {
                n = 8;
            } else if (fieldBean.getUiClass().equals(FileBox.class.getName())) {
                n = 8;
            }
            if (fieldBean.isPassword()) {
                n |= 0x400000;
            }
            if ((iFieldWidget = (fieldComponentCellEditor = new FieldComponentCellEditor((Composite)this.tableViewer.getTable(), string, n)).getFieldWidget()) instanceof TextWrapper) {
                TextWrapper textWrapper = (TextWrapper)iFieldWidget;
                if (fieldBean.getTextLimit() > 0) {
                    textWrapper.setTextLimit(fieldBean.getTextLimit().intValue());
                }
            } else if (iFieldWidget instanceof ComboWrapper) {
                ComboWrapper comboWrapper = (ComboWrapper)iFieldWidget;
                List<String> list = fieldBean.getTextChoicesAsStrings();
                if (list != null && !list.isEmpty()) {
                    comboWrapper.setItems(list.toArray(new String[list.size()]));
                }
            } else if (iFieldWidget instanceof NumberBox) {
                NumberBox numberBox = (NumberBox)iFieldWidget;
                numberBox.setDecimalPlaces(6);
                if (fieldBean.getLowerBound() != null) {
                    numberBox.setMinimum(fieldBean.getLowerBound().doubleValue());
                }
                if (fieldBean.getUpperBound() != null) {
                    numberBox.setMaximum(fieldBean.getUpperBound().doubleValue());
                }
                if (fieldBean.getUnit() != null) {
                    numberBox.setUnit(fieldBean.getUnit());
                }
            } else if (iFieldWidget instanceof SpinnerWrapper) {
                SpinnerWrapper spinnerWrapper = (SpinnerWrapper)iFieldWidget;
                if (fieldBean.getLowerBound() != null) {
                    spinnerWrapper.setMinimum(fieldBean.getLowerBound().intValue());
                }
                if (fieldBean.getUpperBound() != null) {
                    spinnerWrapper.setMaximum(fieldBean.getUpperBound().intValue());
                }
            } else if (iFieldWidget instanceof FileBox) {
                FileBox fileBox = (FileBox)iFieldWidget;
                fileBox.setChoiceType(FileBox.ChoiceType.FULL_PATH);
                fileBox.setFolder(fieldBean.isFolder());
                fileBox.setFileTitle(fieldBean.isFolder() ? "Choose Directory" : "Choose File");
                if (fieldBean.getExtensions() != null) {
                    fileBox.setFilterExtensions(fieldBean.getExtensions().split(","));
                }
            }
            return fieldComponentCellEditor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Cannot get cell editor for " + fieldBean, (Throwable)classNotFoundException);
            return new TextCellEditor((Composite)this.tableViewer.getTable());
        }
    }

    protected void addScalar() {
        String string = "x";
        int n = 1;
        while (this.values.containsKey(string)) {
            if (!this.values.containsKey(String.valueOf(string) + n)) {
                string = String.valueOf(string) + n;
                break;
            }
            ++n;
        }
        this.values.put(string, "<new scalar value>");
        this.tableViewer.refresh();
        Set<Map.Entry<String, String>> set = this.values.entrySet();
        Map.Entry entry = null;
        for (Map.Entry entry2 : set) {
            if (!((String)entry2.getKey()).equals(string)) continue;
            entry = entry2;
            break;
        }
        this.tableViewer.editElement(entry, 1);
    }

    protected void initializePopup(IActionBars iActionBars) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.confirm);
        menuManager.add((IAction)this.stop);
        menuManager.add((IContributionItem)new Separator(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".sep1"));
        menuManager.add((IAction)this.add);
        menuManager.add((IAction)this.delete);
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }

    public void setConfiguration(String string) throws Exception {
        if (string == null) {
            this.configuration = null;
            return;
        }
        this.configuration = (FieldContainer)BeanUI.getBean((String)string, (ClassLoader)FieldContainer.class.getClassLoader());
    }

    public boolean setFocus() {
        if (!this.tableViewer.getTable().isDisposed()) {
            return this.tableViewer.getTable().setFocus();
        }
        return false;
    }

    public void dispose() {
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().dispose();
        }
        if (this.queue != null) {
            this.queue.clear();
            if (this.queue != null && this.originalValues != null && this.queue.isEmpty()) {
                this.queue.add(new HashMap(0));
            }
        }
        this.queue = null;
        this.values = null;
        this.originalValues = null;
    }

    public void setQueue(Queue<Map<String, String>> queue) {
        this.queue = queue;
        queue.clear();
    }

    public void setValues(Map<String, String> map) {
        TreeMap<Object, Object> treeMap = map != null ? new TreeMap<String, String>(map) : new TreeMap();
        if (this.configuration != null) {
            treeMap.keySet().retainAll(this.configuration.getNames());
        }
        this.originalValues = treeMap;
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        treeMap2.putAll(this.originalValues);
        if (this.configuration != null) {
            for (String string : this.configuration.getNames()) {
                if (treeMap2.containsKey(string)) continue;
                FieldBean fieldBean = this.configuration.getBean(string);
                treeMap2.put(string, fieldBean.getDefaultValue() != null ? fieldBean.getDefaultValue().toString() : "");
            }
        }
        this.values = new LinkedHashMap<String, String>(treeMap2.size());
        this.values.putAll(treeMap2);
        this.tableViewer.refresh();
        if (this.configuration != null && this.configuration.getCustomLabel() != null) {
            String string;
            string = SubstituteUtils.substitute((String)this.configuration.getCustomLabel(), map);
            this.customLabel.setText(string);
            GridUtils.setVisible((Control)this.customLabel, (boolean)true);
            this.customLabel.getParent().layout(new Control[]{this.customLabel});
            if (this.values != null && this.values.isEmpty()) {
                GridUtils.setVisible((Control)this.tableViewer.getTable(), (boolean)false);
                this.tableViewer.getTable().getParent().layout(new Control[]{this.tableViewer.getTable()});
                this.messageOnly = true;
            }
        }
    }

    public boolean isMessageOnly() {
        return this.messageOnly;
    }

    public String getPartName() {
        return this.partName;
    }

    protected void doConfirm() {
        this.tableViewer.applyEditorValue();
        this.tableViewer.cancelEditing();
        if (this.queue == null || this.values == null) {
            MessageDialog.open((int)2, (Shell)Display.getCurrent().getActiveShell(), (String)"Cannot confirm", (String)"The workflow is not waiting for you to confirm these values.\n\nThere is currently nothing to confirm.", (int)0);
            return;
        }
        if (this.queue.isEmpty()) {
            this.queue.add(this.values);
        }
    }

    protected void doStop() {
        if (this.queue.isEmpty()) {
            this.queue.add(new HashMap(0));
        }
    }

    public void setPartName(String string) {
        this.partName = string;
    }

    public static interface Closeable {
        public boolean close();
    }
}

