/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import java.util.Properties;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.editors.ISubstitutionEditor;
import org.dawb.passerelle.editors.XMLSubstitutionEditor;
import org.dawb.passerelle.editors.XPathEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdnaActorMultiPageEditor
extends MultiPageEditorPart {
    private static final Logger logger = LoggerFactory.getLogger(EdnaActorMultiPageEditor.class);
    public static final String ID = "org.dawb.passerelle.editors.ednaEditor";
    private ISubstitutionEditor inputEditor;
    private XPathEditor outputEditor;
    private StructuredTextEditor xsdEditor;
    private StructuredTextEditor commonEditor;
    private Properties linkerProps;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        try {
            this.linkerProps = new Properties();
            this.linkerProps.load(EclipseUtils.getIFile((IEditorInput)this.getEditorInput()).getContents());
            this.setPartName(this.linkerProps.getProperty("org.dawb.edna.name"));
        }
        catch (Exception exception) {
            logger.error("Cannot read linker properties " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)exception);
        }
    }

    protected void createPages() {
        try {
            IFile iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.linkerProps.getProperty("org.dawb.edna.input"));
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            this.inputEditor = new XMLSubstitutionEditor(this.linkerProps.getProperty("org.dawb.edna.name"), this.linkerProps.getProperty("org.dawb.edna.moml"));
            this.addPage(0, this.inputEditor, (IEditorInput)fileEditorInput);
            this.setPageText(0, "Input");
            this.setPageImage(0, Activator.getImageDescriptor("icons/edna_input.gif").createImage());
            IFile iFile2 = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.linkerProps.getProperty("org.dawb.edna.output"));
            FileEditorInput fileEditorInput2 = new FileEditorInput(iFile2);
            this.outputEditor = new XPathEditor(this.linkerProps.getProperty("org.dawb.edna.name"), this.linkerProps.getProperty("org.dawb.edna.moml"));
            this.addPage(1, (IEditorPart)this.outputEditor, (IEditorInput)fileEditorInput2);
            this.setPageText(1, "Output");
            this.setPageImage(1, Activator.getImageDescriptor("icons/edna_output.gif").createImage());
        }
        catch (Exception exception) {
            logger.error("Cannot initiate " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)exception);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = EclipseUtils.getIFile((IEditorInput)this.getEditor(n2).getEditorInput());
            if (!iFile.isReadOnly()) {
                this.getEditor(n2).doSave(iProgressMonitor);
            }
            ++n2;
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getEditor(n2).isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ISubstitutionEditor getEdnaActorInputEditor() {
        return this.inputEditor;
    }

    public XPathEditor getEdnaActorOutputEditor() {
        return this.outputEditor;
    }
}

