/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.editors;

import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.passerelle.actors.Activator;
import org.dawb.passerelle.editors.EdnaActorMultiPageEditor;
import org.dawb.passerelle.editors.ISubstitutionEditor;
import org.dawb.passerelle.editors.XPathEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdnaActorActions {
    private static final Logger logger = LoggerFactory.getLogger(EdnaActorActions.class);
    public static final Action showVars = new Action("Show variables", 2){

        public void run() {
            ISubstitutionEditor iSubstitutionEditor = EdnaActorActions.getEdnaInputEditor();
            iSubstitutionEditor.setPreview(false);
            showVars.setChecked(true);
        }
    };
    public static final Action showSubstitution;
    public static final Action revertInput;
    public static final Action addXPath;
    public static final Action deleteXPath;
    public static final Action revertOutput;

    static {
        showVars.setImageDescriptor(Activator.getImageDescriptor("icons/xml_variables.png"));
        showVars.setChecked(true);
        showSubstitution = new Action("Preview substitution", 2){

            public void run() {
                try {
                    ISubstitutionEditor iSubstitutionEditor = EdnaActorActions.getEdnaInputEditor();
                    iSubstitutionEditor.setPreview(true);
                    showSubstitution.setChecked(true);
                }
                catch (Exception exception) {
                    logger.error("Cannot parse document to show values", (Throwable)exception);
                }
            }
        };
        showSubstitution.setImageDescriptor(Activator.getImageDescriptor("icons/xml_substitute.gif"));
        showSubstitution.setToolTipText("Shows estimation of file after a replace. Note if you save in this mode, it will revert back to variable mode to avoid saving the preview.");
        revertInput = new Action("Revert", 1){

            public void run() {
                ISubstitutionEditor iSubstitutionEditor = EdnaActorActions.getEdnaInputEditor();
                showVars.setChecked(true);
                iSubstitutionEditor.revert();
            }
        };
        revertInput.setImageDescriptor(Activator.getImageDescriptor("icons/xml_revert.png"));
        revertInput.setToolTipText("Revert editor to default input");
        addXPath = new Action("Add xpath", 1){

            public void run() {
                try {
                    XPathEditor xPathEditor = EdnaActorActions.getEdnaOutputEditor();
                    xPathEditor.addVariable();
                }
                catch (Exception exception) {
                    logger.error("Cannot parse document to show values", (Throwable)exception);
                }
            }
        };
        addXPath.setToolTipText("Add variable defined by running an XPath query on the output.");
        addXPath.setImageDescriptor(Activator.getImageDescriptor("icons/xpath_add.png"));
        deleteXPath = new Action("Delete xpath", 1){

            public void run() {
                try {
                    XPathEditor xPathEditor = EdnaActorActions.getEdnaOutputEditor();
                    xPathEditor.deleteVariable();
                }
                catch (Exception exception) {
                    logger.error("Cannot parse document to show values", (Throwable)exception);
                }
            }
        };
        deleteXPath.setToolTipText("Delete variable defined by running an XPath query on the output.");
        deleteXPath.setImageDescriptor(Activator.getImageDescriptor("icons/xpath_delete.png"));
        revertOutput = new Action("Revert", 1){

            public void run() {
                XPathEditor xPathEditor = EdnaActorActions.getEdnaOutputEditor();
                xPathEditor.revert();
            }
        };
        revertOutput.setImageDescriptor(Activator.getImageDescriptor("icons/xml_revert.png"));
        revertOutput.setToolTipText("Revert editor to last saved value");
    }

    public static void createOutputActions(IContributionManager iContributionManager) {
        iContributionManager.add((IAction)addXPath);
        iContributionManager.add((IAction)deleteXPath);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(EdnaActorActions.class.getName()) + ".output.sep3"));
        iContributionManager.add((IAction)revertOutput);
    }

    public static void createInputActions(IContributionManager iContributionManager) {
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        showVars.setChecked(true);
        checkableActionGroup.add((IAction)showVars);
        iContributionManager.add((IAction)showVars);
        checkableActionGroup.add((IAction)showSubstitution);
        iContributionManager.add((IAction)showSubstitution);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(EdnaActorActions.class.getName()) + ".input.sep1"));
        iContributionManager.add((IAction)revertInput);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(EdnaActorActions.class.getName()) + ".input.sep2"));
    }

    private static final ISubstitutionEditor getEdnaInputEditor() {
        IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        if (iEditorPart instanceof EdnaActorMultiPageEditor) {
            EdnaActorMultiPageEditor ednaActorMultiPageEditor = (EdnaActorMultiPageEditor)EclipseUtils.getActivePage().getActiveEditor();
            return ednaActorMultiPageEditor.getEdnaActorInputEditor();
        }
        if (iEditorPart instanceof ISubstitutionEditor) {
            return (ISubstitutionEditor)iEditorPart;
        }
        return null;
    }

    private static final XPathEditor getEdnaOutputEditor() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null || !(iEditorPart instanceof EdnaActorMultiPageEditor)) {
            return null;
        }
        EdnaActorMultiPageEditor ednaActorMultiPageEditor = (EdnaActorMultiPageEditor)iEditorPart;
        return ednaActorMultiPageEditor.getEdnaActorOutputEditor();
    }
}

