/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.dnd;

import com.isencia.passerelle.workbench.model.editor.ui.dnd.IDropClassFactory;
import com.isencia.passerelle.workbench.model.ui.command.CreateComponentCommand;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dawb.common.util.io.FileUtils;
import org.dawb.gda.extensions.loaders.H5Loader;
import org.dawb.passerelle.actors.data.DataImportSource;
import org.dawb.passerelle.actors.data.FolderImportSource;
import org.dawb.passerelle.actors.data.SpecImportSource;
import org.dawb.passerelle.actors.scripts.PythonScript;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class DawbDropFactory
implements IDropClassFactory {
    private static Logger logger = LoggerFactory.getLogger(DawbDropFactory.class);
    private final Map<String, Class<? extends NamedObj>> classes = new HashMap<String, Class<? extends NamedObj>>(7);

    static {
        try {
            H5Loader.setLoaderInFactory();
        }
        catch (Exception exception) {
            logger.error("Cannot replace loader in factory.", (Throwable)exception);
        }
    }

    public DawbDropFactory() {
        Collection collection = LoaderFactory.getSupportedExtensions();
        for (String string : collection) {
            this.classes.put(string, DataImportSource.class);
        }
        this.classes.put("py", PythonScript.class);
        this.classes.put("jy", PythonScript.class);
        this.classes.put("spec", SpecImportSource.class);
    }

    public Class<? extends NamedObj> getClassForPath(IResource iResource, String string) {
        if (string == null) {
            return null;
        }
        if (iResource != null && iResource instanceof IContainer) {
            return FolderImportSource.class;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return FolderImportSource.class;
        }
        String string2 = FileUtils.getFileExtension((File)file);
        Class<Object> clazz = this.classes.get(string2);
        if (clazz == null) {
            clazz = DataImportSource.class;
        }
        return clazz;
    }

    public void setConfigurableParameters(CreateComponentCommand createComponentCommand, String string) {
        if (H5Loader.isH5((String)string)) {
            IMetaData iMetaData;
            try {
                iMetaData = LoaderFactory.getMetaData((String)string, null);
            }
            catch (Exception exception) {
                logger.error("Cannot get meta data for " + string, (Throwable)exception);
                return;
            }
            if (iMetaData != null && iMetaData.getDataNames() != null && iMetaData.getDataNames().size() == 1) {
                createComponentCommand.addConfigurableParameterValue((Object)"Data Sets", iMetaData.getDataNames().iterator().next());
            }
        }
    }
}

