/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dawb.passerelle.actors.ui.config.FieldBean;

public class FieldContainer
implements Serializable {
    private static final long serialVersionUID = 2809239217814025633L;
    private List<FieldBean> fields = new ArrayList<FieldBean>();
    private String customLabel;

    public void clear() {
        if (this.fields != null) {
            this.fields.clear();
        }
    }

    public List<FieldBean> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldBean> list) {
        this.fields = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.customLabel == null ? 0 : this.customLabel.hashCode());
        n = 31 * n + (this.fields == null ? 0 : this.fields.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldContainer fieldContainer = (FieldContainer)object;
        if (this.customLabel == null ? fieldContainer.customLabel != null : !this.customLabel.equals(fieldContainer.customLabel)) {
            return false;
        }
        return !(this.fields == null ? fieldContainer.fields != null : !this.fields.equals(fieldContainer.fields));
    }

    public void addField(FieldBean fieldBean) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldBean>(7);
        }
        this.fields.add(fieldBean);
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEmpty() {
        return this.fields == null || this.size() < 1;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "No fields set, please click and create user fields...";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (FieldBean fieldBean : this.fields) {
            stringBuilder.append("'");
            stringBuilder.append(fieldBean.getVariableName());
            stringBuilder.append("'");
            if (fieldBean.getClassString() != null) {
                stringBuilder.append("(");
                stringBuilder.append(fieldBean.getClassString());
                stringBuilder.append(")");
            }
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    public Collection<String> getNames() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.fields.size());
        for (FieldBean fieldBean : this.fields) {
            arrayList.add(fieldBean.getVariableName());
        }
        return arrayList;
    }

    public FieldBean getBean(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        if (this.isEmpty()) {
            return null;
        }
        for (FieldBean fieldBean : this.fields) {
            if (!fieldBean.getVariableName().equals(string)) continue;
            return fieldBean;
        }
        return null;
    }

    public boolean containsBean(String string) {
        return this.getNames().contains(string);
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public void setCustomLabel(String string) {
        this.customLabel = string;
    }
}

