/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dawb.passerelle.actors.ui.config.StringValueBean;
import org.dawb.passerelle.actors.ui.config.TextValueComposite;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.BoundsProvider;
import uk.ac.gda.richbeans.components.file.FileBox;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.StandardBox;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.components.wrappers.BooleanWrapper;
import uk.ac.gda.richbeans.components.wrappers.ComboWrapper;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;
import uk.ac.gda.richbeans.components.wrappers.TextWrapper;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class FieldComposite
extends Composite {
    private List<Control> propControls;
    private CLabel textLimitLabel;
    private CLabel upperBoundLabel;
    private CLabel lowerBoundLabel;
    private CLabel unitLabel;
    private CLabel folderLabel;
    private CLabel extensionsLabel;
    private CLabel choicesLabel;
    private Group properties;
    private TextWrapper variableName;
    private ComboWrapper uiClass;
    private TextWrapper uiLabel;
    private TextWrapper defaultValue;
    private TextWrapper unit;
    private SpinnerWrapper textLimit;
    private NumberBox upperBound;
    private NumberBox lowerBound;
    private BooleanWrapper folder;
    private BooleanWrapper password;
    private TextWrapper extensions;
    private VerticalListEditor textChoices;

    public FieldComposite(Composite composite, int n) {
        super(composite, n);
        this.create();
    }

    private void create() {
        this.setLayout((Layout)new GridLayout(1, false));
        GridUtils.removeMargins((Composite)this);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        CLabel cLabel = new CLabel(composite, 0);
        cLabel.setText("Scalar Variable");
        this.variableName = new TextWrapper(composite, 0);
        this.variableName.setTextType(TextWrapper.TEXT_TYPE.EXPRESSION);
        this.variableName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableName.setToolTipText("The variable name to use in the scalar value entered by the user.");
        CLabel cLabel2 = new CLabel(composite, 0);
        cLabel2.setText("Label");
        this.uiLabel = new TextWrapper(composite, 0);
        this.uiLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.uiLabel.setToolTipText("If left blank, the variable name will be used for the label.");
        cLabel = new CLabel(composite, 0);
        cLabel.setText("Input Type");
        this.uiClass = new ComboWrapper(composite, 8);
        this.uiClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(3);
        linkedHashMap.put("Text", TextWrapper.class.getName());
        linkedHashMap.put("Real", StandardBox.class.getName());
        linkedHashMap.put("Integer", SpinnerWrapper.class.getName());
        linkedHashMap.put("File", FileBox.class.getName());
        linkedHashMap.put("Text Choice", ComboWrapper.class.getName());
        this.uiClass.setItems(linkedHashMap);
        this.uiClass.setToolTipText("Please set data input type for the user.");
        this.uiClass.addValueListener((ValueListener)new ValueAdapter(){

            public void valueChangePerformed(ValueEvent valueEvent) {
                if (FieldComposite.this.uiClass.getValue() == null) {
                    return;
                }
                FieldComposite.this.updateVisibleProperties(FieldComposite.this.uiClass.getValue());
            }
        });
        CLabel cLabel3 = new CLabel(composite, 0);
        cLabel3.setText("Default Value");
        this.defaultValue = new TextWrapper(composite, 0);
        this.defaultValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.properties = new Group((Composite)this, 0);
        this.properties.setLayout((Layout)new GridLayout(2, false));
        this.properties.setLayoutData((Object)new GridData(4, 4, true, true));
        this.properties.setText("Text Input Properties");
        this.propControls = new ArrayList<Control>(7);
        this.folderLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.folderLabel);
        this.folderLabel.setText("Choose Folders");
        this.folder = new BooleanWrapper((Composite)this.properties, 0);
        this.folder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.propControls.add((Control)this.folder);
        this.folder.addValueListener((ValueListener)new ValueAdapter(){

            public void valueChangePerformed(ValueEvent valueEvent) {
                FieldComposite.this.updateFileVis();
            }
        });
        this.textLimitLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.textLimitLabel);
        this.textLimitLabel.setText("Text Limit");
        this.textLimit = new SpinnerWrapper((Composite)this.properties, 0);
        this.propControls.add((Control)this.textLimit);
        this.textLimit.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLimit.setMinimum(0);
        this.textLimit.setMaximum(512);
        this.textLimit.setIncrement(1);
        this.textLimit.setValue((Object)0);
        this.textLimit.setToolTipText("A value of 0 means no text limit.");
        this.password = new BooleanWrapper((Composite)this.properties, 32);
        this.password.setText("   Password");
        this.password.setToolTipText("Turn on to make the text a password text box.");
        this.password.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.password.setValue((Object)Boolean.FALSE);
        this.propControls.add((Control)this.password);
        this.unitLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.unitLabel);
        this.unitLabel.setText("Unit");
        this.unit = new TextWrapper((Composite)this.properties, 0);
        this.propControls.add((Control)this.unit);
        this.unit.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lowerBoundLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.lowerBoundLabel);
        this.lowerBoundLabel.setText("Lower Limit");
        this.lowerBound = new StandardBox((Composite)this.properties, 0);
        this.propControls.add((Control)this.lowerBound);
        this.lowerBound.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lowerBound.setMinimum(-10000.0);
        this.lowerBound.setMaximum(10000.0);
        this.lowerBound.setValue((Object)0);
        this.lowerBound.setDecimalPlaces(6);
        this.upperBoundLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.upperBoundLabel);
        this.upperBoundLabel.setText("Upper Limit");
        this.upperBound = new StandardBox((Composite)this.properties, 0);
        this.propControls.add((Control)this.upperBound);
        this.upperBound.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.upperBound.setMinimum((BoundsProvider)this.lowerBound);
        this.upperBound.setMaximum(10000.0);
        this.upperBound.setValue((Object)1000);
        this.upperBound.setDecimalPlaces(6);
        this.extensionsLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.extensionsLabel);
        this.extensionsLabel.setText("Extensions");
        this.extensions = new TextWrapper((Composite)this.properties, 0);
        this.propControls.add((Control)this.extensions);
        this.extensions.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.extensions.setToolTipText("Comma separated file extension list");
        this.choicesLabel = new CLabel((Composite)this.properties, 0);
        this.propControls.add((Control)this.choicesLabel);
        this.choicesLabel.setText("Choices");
        this.textChoices = new VerticalListEditor((Composite)this.properties, 0);
        this.textChoices.setRequireSelectionPack(false);
        this.textChoices.setListenerName("Text Choices Listener");
        this.propControls.add((Control)this.textChoices);
        this.textChoices.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textChoices.setMinItems(0);
        this.textChoices.setMaxItems(25);
        this.textChoices.setDefaultName("Text Choice");
        this.textChoices.setEditorClass(StringValueBean.class);
        this.textChoices.setEditorUI((Object)new TextValueComposite((Composite)this.textChoices, 0));
        this.textChoices.setNameField("textValue");
        GridUtils.setVisibleAndLayout((Control)this.textChoices, (boolean)false);
        this.updateVisibleProperties();
    }

    protected void updateVisibleProperties() {
        this.updateVisibleProperties(this.uiClass.getValue());
    }

    private void updateFileVis() {
        boolean bl = this.folder.getValue() == false;
        this.extensionsLabel.setEnabled(bl);
        this.extensions.setEnabled(bl);
    }

    private void updateVisibleProperties(Object object) {
        if (this.properties == null) {
            return;
        }
        for (Control control : this.propControls) {
            GridUtils.setVisible((Control)control, (boolean)false);
        }
        if (object == null) {
            object = TextWrapper.class.getName();
        }
        if (object.equals(TextWrapper.class.getName())) {
            this.properties.setText("Text Input Properties");
            GridUtils.setVisible((Control)this.textLimitLabel, (boolean)true);
            GridUtils.setVisible((Control)this.textLimit, (boolean)true);
            GridUtils.setVisible((Control)this.password, (boolean)true);
        } else if (object.equals(ComboWrapper.class.getName())) {
            this.properties.setText("Choice Input Properties");
            GridUtils.setVisible((Control)this.choicesLabel, (boolean)true);
            GridUtils.setVisible((Control)this.textChoices, (boolean)true);
        } else if (object.equals(StandardBox.class.getName())) {
            this.properties.setText("Real Input Properties");
            this.lowerBound.setIntegerBox(false);
            this.upperBound.setIntegerBox(false);
            GridUtils.setVisible((Control)this.lowerBoundLabel, (boolean)true);
            GridUtils.setVisible((Control)this.lowerBound, (boolean)true);
            GridUtils.setVisible((Control)this.upperBoundLabel, (boolean)true);
            GridUtils.setVisible((Control)this.upperBound, (boolean)true);
            GridUtils.setVisible((Control)this.unitLabel, (boolean)true);
            GridUtils.setVisible((Control)this.unit, (boolean)true);
        } else if (object.equals(SpinnerWrapper.class.getName())) {
            this.properties.setText("Integer Input Properties");
            this.lowerBound.setIntegerBox(true);
            this.upperBound.setIntegerBox(true);
            GridUtils.setVisible((Control)this.lowerBoundLabel, (boolean)true);
            GridUtils.setVisible((Control)this.lowerBound, (boolean)true);
            GridUtils.setVisible((Control)this.upperBoundLabel, (boolean)true);
            GridUtils.setVisible((Control)this.upperBound, (boolean)true);
        } else if (object.equals(FileBox.class.getName())) {
            this.properties.setText("File Input Properties");
            GridUtils.setVisible((Control)this.folderLabel, (boolean)true);
            GridUtils.setVisible((Control)this.folder, (boolean)true);
            GridUtils.setVisible((Control)this.extensionsLabel, (boolean)true);
            GridUtils.setVisible((Control)this.extensions, (boolean)true);
            this.updateFileVis();
        }
        this.properties.layout(this.propControls.toArray(new Control[this.propControls.size()]));
        this.layout();
        this.getParent().layout();
        this.getShell().layout();
    }

    public IFieldWidget getDefaultValue() {
        return this.defaultValue;
    }

    public ComboWrapper getUiClass() {
        return this.uiClass;
    }

    public SpinnerWrapper getTextLimit() {
        return this.textLimit;
    }

    public TextWrapper getUnit() {
        return this.unit;
    }

    public NumberBox getUpperBound() {
        return this.upperBound;
    }

    public NumberBox getLowerBound() {
        return this.lowerBound;
    }

    public BooleanWrapper getFolder() {
        return this.folder;
    }

    public TextWrapper getUiLabel() {
        return this.uiLabel;
    }

    public TextWrapper getExtensions() {
        return this.extensions;
    }

    public VerticalListEditor getTextChoices() {
        return this.textChoices;
    }

    public TextWrapper getVariableName() {
        return this.variableName;
    }

    public BooleanWrapper getPassword() {
        return this.password;
    }
}

