/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.dawb.passerelle.actors.ui.config.StringValueBean;

public class FieldBean
implements Serializable {
    private static final long serialVersionUID = 7494988708038548535L;
    private String variableName = "x";
    private String uiClass = "uk.ac.gda.richbeans.components.wrappers.TextWrapper";
    private String uiLabel = null;
    private Number upperBound = 1000;
    private Number lowerBound = 0;
    private String unit = null;
    private Object defaultValue;
    private Integer textLimit = 0;
    private boolean isFolder = true;
    private boolean isPassword;
    private String fileFilterLabel = "All";
    private String extensions = "*";
    private List<StringValueBean> textChoices = new ArrayList<StringValueBean>(7);

    public void clear() {
        this.textChoices.clear();
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String getUiClass() {
        return this.uiClass;
    }

    public void setUiClass(String string) {
        this.uiClass = string;
    }

    public Number getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Number number) {
        this.upperBound = number;
    }

    public Number getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Number number) {
        this.lowerBound = number;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String string) {
        this.extensions = string;
    }

    public String getFileFilterLabel() {
        return this.fileFilterLabel;
    }

    public void setFileFilterLabel(String string) {
        this.fileFilterLabel = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        n = 31 * n + (this.extensions == null ? 0 : this.extensions.hashCode());
        n = 31 * n + (this.fileFilterLabel == null ? 0 : this.fileFilterLabel.hashCode());
        n = 31 * n + (this.isFolder ? 1231 : 1237);
        n = 31 * n + (this.isPassword ? 1231 : 1237);
        n = 31 * n + (this.lowerBound == null ? 0 : this.lowerBound.hashCode());
        n = 31 * n + (this.textChoices == null ? 0 : this.textChoices.hashCode());
        n = 31 * n + (this.textLimit == null ? 0 : this.textLimit.hashCode());
        n = 31 * n + (this.uiClass == null ? 0 : this.uiClass.hashCode());
        n = 31 * n + (this.uiLabel == null ? 0 : this.uiLabel.hashCode());
        n = 31 * n + (this.unit == null ? 0 : this.unit.hashCode());
        n = 31 * n + (this.upperBound == null ? 0 : this.upperBound.hashCode());
        n = 31 * n + (this.variableName == null ? 0 : this.variableName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldBean fieldBean = (FieldBean)object;
        if (this.defaultValue == null ? fieldBean.defaultValue != null : !this.defaultValue.equals(fieldBean.defaultValue)) {
            return false;
        }
        if (this.extensions == null ? fieldBean.extensions != null : !this.extensions.equals(fieldBean.extensions)) {
            return false;
        }
        if (this.fileFilterLabel == null ? fieldBean.fileFilterLabel != null : !this.fileFilterLabel.equals(fieldBean.fileFilterLabel)) {
            return false;
        }
        if (this.isFolder != fieldBean.isFolder) {
            return false;
        }
        if (this.isPassword != fieldBean.isPassword) {
            return false;
        }
        if (this.lowerBound == null ? fieldBean.lowerBound != null : !this.lowerBound.equals(fieldBean.lowerBound)) {
            return false;
        }
        if (this.textChoices == null ? fieldBean.textChoices != null : !this.textChoices.equals(fieldBean.textChoices)) {
            return false;
        }
        if (this.textLimit == null ? fieldBean.textLimit != null : !this.textLimit.equals(fieldBean.textLimit)) {
            return false;
        }
        if (this.uiClass == null ? fieldBean.uiClass != null : !this.uiClass.equals(fieldBean.uiClass)) {
            return false;
        }
        if (this.uiLabel == null ? fieldBean.uiLabel != null : !this.uiLabel.equals(fieldBean.uiLabel)) {
            return false;
        }
        if (this.unit == null ? fieldBean.unit != null : !this.unit.equals(fieldBean.unit)) {
            return false;
        }
        if (this.upperBound == null ? fieldBean.upperBound != null : !this.upperBound.equals(fieldBean.upperBound)) {
            return false;
        }
        return !(this.variableName == null ? fieldBean.variableName != null : !this.variableName.equals(fieldBean.variableName));
    }

    public String getErrorMessage() {
        return null;
    }

    public Integer getTextLimit() {
        return this.textLimit;
    }

    public void setTextLimit(Integer n) {
        this.textLimit = n;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(boolean bl) {
        this.isFolder = bl;
    }

    public String getUiLabel() {
        return this.uiLabel;
    }

    public void setUiLabel(String string) {
        this.uiLabel = string;
    }

    public String getUserString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassString());
        stringBuffer.append("  ");
        if (this.getUiLabel() != null) {
            stringBuffer.append("'");
            stringBuffer.append(this.getUiLabel());
            stringBuffer.append("' ");
        }
        if (this.getDefaultValue() != null) {
            stringBuffer.append("'Default Value=");
            stringBuffer.append(this.getDefaultValue());
            if (this.getUnit() != null) {
                stringBuffer.append(" [");
                stringBuffer.append(this.unit);
                stringBuffer.append("]");
            }
            stringBuffer.append("'  ");
        }
        return stringBuffer.toString();
    }

    public String getClassString() {
        if (this.uiClass.endsWith(".TextWrapper")) {
            return "Text";
        }
        if (this.uiClass.endsWith(".ComboWrapper")) {
            return "Combo";
        }
        if (this.uiClass.endsWith(".StandardBox")) {
            return "Real";
        }
        if (this.uiClass.endsWith(".SpinnerWrapper")) {
            return "Integer";
        }
        if (this.uiClass.endsWith(".FileBox")) {
            return "File";
        }
        return this.uiClass;
    }

    public List<StringValueBean> getTextChoices() {
        return this.textChoices;
    }

    public void setTextChoices(List<StringValueBean> list) {
        this.textChoices = list;
    }

    public List<String> getTextChoicesAsStrings() {
        List<StringValueBean> list = this.getTextChoices();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (StringValueBean stringValueBean : list) {
            arrayList.add(stringValueBean.getTextValue());
        }
        return arrayList;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void setPassword(boolean bl) {
        this.isPassword = bl;
    }
}

