/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import org.dawb.passerelle.actors.ui.config.FieldBean;
import org.dawb.passerelle.actors.ui.config.FieldContainer;
import org.dawb.passerelle.actors.ui.config.FieldParameter;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.dawb.workbench.jmx.UserInputBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Manager;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class UserModifyTransformer
extends AbstractDataMessageTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UserModifyTransformer.class);
    protected static final String[] INPUT_CHOICES = new String[]{"Edit with dialog (non-blocking)", "Edit with editor part (non-blocking)"};
    private static final long serialVersionUID = -8123070610686014566L;
    private FieldParameter fieldParam;
    private StringParameter inputTypeParam;
    private Parameter silent;

    public UserModifyTransformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(0));
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
        this.fieldParam = new FieldParameter((NamedObj)this, "User Fields");
        this.registerConfigurableParameter((Parameter)this.fieldParam);
        this.inputTypeParam = new StringParameter((NamedObj)this, "User Input Type"){

            public String[] getChoices() {
                return INPUT_CHOICES;
            }
        };
        this.silent = new Parameter((NamedObj)this, "Silent");
        this.silent.setToken((Token)new BooleanToken(false));
        this.registerConfigurableParameter(this.silent);
        this.inputTypeParam.setExpression(INPUT_CHOICES[0]);
        this.registerConfigurableParameter((Parameter)this.inputTypeParam);
    }

    protected boolean doPreFire() throws ProcessingException {
        return super.doPreFire();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        try {
            Object object;
            HashMap<String, String> hashMap;
            MBeanServerConnection mBeanServerConnection;
            block8: {
                if (this.getManager() != null && (this.getManager().isExitingAfterWrapup() || this.getManager().getState() == Manager.EXITING || this.getManager().getState() == Manager.WRAPPING_UP)) {
                    return null;
                }
                Map map = MessageUtils.getScalar(list);
                mBeanServerConnection = ActorUtils.getWorkbenchConnection();
                boolean bl = INPUT_CHOICES[0].equals(this.inputTypeParam.getExpression());
                try {
                    mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), true, 3}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                    UserInputBean userInputBean = new UserInputBean();
                    userInputBean.setActorName(this.getName());
                    userInputBean.setPartName("Review");
                    userInputBean.setDialog(bl);
                    userInputBean.setConfigurationXML(this.fieldParam.getXML());
                    userInputBean.setScalarValues(map);
                    userInputBean.setSilent(((BooleanToken)this.silent.getToken()).booleanValue());
                    Object object2 = mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "createUserInput", new Object[]{userInputBean}, new String[]{UserInputBean.class.getName()});
                    hashMap = (HashMap<String, String>)object2;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>(7);
                        object = (FieldContainer)this.fieldParam.getBeanFromValue(FieldContainer.class);
                        for (FieldBean fieldBean : ((FieldContainer)object).getFields()) {
                            if (fieldBean.getDefaultValue() == null) continue;
                            hashMap.put(fieldBean.getVariableName(), fieldBean.getDefaultValue().toString());
                        }
                        break block8;
                    }
                    if (!hashMap.isEmpty()) break block8;
                    this.requestFinish();
                }
                catch (Throwable throwable) {
                    mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                    throw throwable;
                }
                mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                return null;
            }
            object = new DataMessageComponent();
            object.setMeta(MessageUtils.getMeta(list));
            object.addScalar(MessageUtils.getScalar(list));
            object.addScalar(hashMap);
            Object object3 = object;
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
            return object3;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot allow user to modify message '" + this.getName() + "'", exception);
        }
    }

    protected String getOperationName() {
        return "User modify scalar values";
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            FieldContainer fieldContainer = (FieldContainer)this.fieldParam.getBeanFromValue(FieldContainer.class);
            if (fieldContainer == null || fieldContainer.isEmpty()) {
                return list;
            }
            for (FieldBean fieldBean : fieldContainer.getFields()) {
                list.add(new Variable(fieldBean.getVariableName(), IVariable.VARIABLE_TYPE.SCALAR, fieldBean.getDefaultValue(), String.class));
            }
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }
}

