/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.message.ManagedMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import org.dawb.passerelle.actors.ui.config.FieldBean;
import org.dawb.passerelle.actors.ui.config.FieldContainer;
import org.dawb.passerelle.actors.ui.config.FieldParameter;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.dawb.workbench.jmx.UserInputBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Manager;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class UserInputSource
extends AbstractDataMessageSource {
    protected static final String[] INPUT_CHOICES = new String[]{"Edit with dialog (non-blocking)", "Edit with editor part (non-blocking)"};
    private static final long serialVersionUID = 1963665538170982944L;
    private static final Logger logger = LoggerFactory.getLogger(UserInputSource.class);
    private FieldParameter fieldParam = new FieldParameter((NamedObj)this, "User Fields");
    private StringParameter inputTypeParam;
    private Parameter silent;
    private boolean haveSendMessage = false;
    private ManagedMessage triggerMsg;

    public UserInputSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.fieldParam);
        this.inputTypeParam = new StringParameter((NamedObj)this, "User Input Type"){

            public String[] getChoices() {
                return INPUT_CHOICES;
            }
        };
        this.silent = new Parameter((NamedObj)this, "Silent");
        this.silent.setToken((Token)new BooleanToken(false));
        this.registerConfigurableParameter(this.silent);
        this.inputTypeParam.setExpression(INPUT_CHOICES[0]);
        this.registerConfigurableParameter((Parameter)this.inputTypeParam);
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        if (this.trigger.getWidth() <= 0 && this.haveSendMessage) {
            return null;
        }
        try {
            Serializable serializable;
            HashMap<String, String> hashMap;
            Map map;
            MBeanServerConnection mBeanServerConnection;
            block20: {
                if (this.getManager() != null && (this.getManager().isExitingAfterWrapup() || this.getManager().getState() == Manager.EXITING || this.getManager().getState() == Manager.WRAPPING_UP)) {
                    return null;
                }
                mBeanServerConnection = ActorUtils.getWorkbenchConnection();
                map = null;
                if (this.triggerMsg != null) {
                    try {
                        DataMessageComponent dataMessageComponent = MessageUtils.coerceMessage((ManagedMessage)this.triggerMsg);
                        map = dataMessageComponent.getScalar();
                    }
                    catch (Exception exception) {
                        logger.info("Trigger for " + this.getName() + " is not DataMessageComponent, no data added.");
                    }
                }
                boolean bl = INPUT_CHOICES[0].equals(this.inputTypeParam.getExpression());
                try {
                    mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), true, 3}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                    UserInputBean userInputBean = new UserInputBean();
                    userInputBean.setActorName(this.getName());
                    userInputBean.setPartName("Set Values");
                    userInputBean.setDialog(bl);
                    userInputBean.setConfigurationXML(this.fieldParam.getXML());
                    userInputBean.setScalarValues(map);
                    userInputBean.setSilent(((BooleanToken)this.silent.getToken()).booleanValue());
                    Object object2 = mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "createUserInput", new Object[]{userInputBean}, new String[]{UserInputBean.class.getName()});
                    hashMap = (HashMap<String, String>)object2;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>(7);
                        serializable = (FieldContainer)this.fieldParam.getBeanFromValue(FieldContainer.class);
                        for (FieldBean object3 : ((FieldContainer)serializable).getFields()) {
                            if (object3.getDefaultValue() == null) continue;
                            hashMap.put(object3.getVariableName(), object3.getDefaultValue().toString());
                        }
                        break block20;
                    }
                    if (!hashMap.isEmpty()) break block20;
                    this.requestFinish();
                }
                catch (Throwable throwable) {
                    try {
                        mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw this.createDataMessageException("Cannot allow user to modify message '" + this.getName() + "'", exception);
                    }
                }
                mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
                return null;
            }
            serializable = new HashMap(7);
            if (map != null) {
                serializable.putAll(map);
            }
            if (hashMap != null) {
                serializable.putAll(hashMap);
            }
            DataMessageComponent dataMessageComponent = new DataMessageComponent();
            dataMessageComponent.addScalar((Map)((Object)serializable));
            ManagedMessage managedMessage = MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent);
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{this.getModelPath(), this.getName(), false, -1}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
            return managedMessage;
        }
        finally {
            this.haveSendMessage = true;
        }
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggerMsg = managedMessage;
    }

    protected boolean mustWaitForTrigger() {
        return this.trigger.getWidth() >= 1;
    }

    protected String getExtendedInfo() {
        return "A source of information from a user input form";
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            FieldContainer fieldContainer = (FieldContainer)this.fieldParam.getBeanFromValue(FieldContainer.class);
            if (fieldContainer == null || fieldContainer.isEmpty()) {
                return list;
            }
            for (FieldBean fieldBean : fieldContainer.getFields()) {
                list.add(new Variable(fieldBean.getVariableName(), IVariable.VARIABLE_TYPE.SCALAR, fieldBean.getDefaultValue(), String.class));
            }
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }
}

