/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.ui;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.util.ptolemy.IAvailableChoices;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import org.dawb.passerelle.common.actors.AbstractDataMessageSink;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class MessageSink
extends AbstractDataMessageSink {
    private static final long serialVersionUID = 7807261809740835047L;
    private static final Logger logger = LoggerFactory.getLogger(MessageSink.class);
    private Parameter messageType = new StringChoiceParameter((NamedObj)this, "Message Type", new IAvailableChoices(){

        public Map<String, String> getVisibleChoices() {
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            hashMap.put("1", "ERROR");
            hashMap.put("4", "WARNING");
            hashMap.put("2", "INFORMATION");
            return hashMap;
        }

        public String[] getChoices() {
            return new String[]{"1", "4", "2"};
        }
    }, 4);
    private Parameter messageParam;
    private Parameter messageTitle;
    public Port shownMessagePort;

    public MessageSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.messageType.setExpression("1");
        this.registerConfigurableParameter(this.messageType);
        this.messageParam = new StringParameter((NamedObj)this, "Message");
        this.messageParam.setExpression("${message_text}");
        this.registerConfigurableParameter(this.messageParam);
        this.messageTitle = new StringParameter((NamedObj)this, "Message Title");
        this.messageTitle.setExpression("Error Message");
        this.registerConfigurableParameter(this.messageTitle);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(1));
        this.passModeParameter.setVisibility(Settable.NONE);
        this.shownMessagePort = PortFactory.getInstance().createOutputPort((Entity)this, "shownMessage");
    }

    protected void sendCachedData(List<DataMessageComponent> list) throws ProcessingException {
        try {
            if (list == null) {
                return;
            }
            if (list.isEmpty()) {
                return;
            }
            DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
            if (dataMessageComponent.getScalar() == null || dataMessageComponent.getScalar().isEmpty()) {
                return;
            }
            String string = ParameterUtils.getSubstituedValue((Parameter)this.messageTitle, list);
            String string2 = ParameterUtils.getSubstituedValue((Parameter)this.messageParam, list);
            int n = Integer.parseInt(this.messageType.getExpression());
            try {
                MBeanServerConnection mBeanServerConnection;
                Object object;
                if (MessageUtils.isErrorMessage(list)) {
                    this.getManager().stop();
                }
                if ((object = (mBeanServerConnection = ActorUtils.getWorkbenchConnection()).invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "showMessage", new Object[]{string, string2, n}, new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName()})) == null || !((Boolean)object).booleanValue()) {
                    throw this.createDataMessageException("Show message '" + this.getName() + "'!", new Exception());
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                logger.error(String.valueOf(string) + ">  " + string2);
            }
            if (this.shownMessagePort.getWidth() > 0) {
                this.shownMessagePort.broadcast((Token)new PasserelleToken(MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent)));
            }
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot show error message '" + this.getName() + "'", exception);
        }
    }

    public List<IVariable> getOutputVariables() {
        return this.getInputVariables();
    }
}

