/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.scripts;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jep.Jep;
import jep.JepException;
import org.dawb.common.python.NumpyUtils;
import org.dawb.common.python.PythonUtils;
import org.dawb.common.python.rpc.PythonService;
import org.dawb.gda.extensions.jython.JythonInterpreterUtils;
import org.dawb.passerelle.common.actors.AbstractScriptTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.jython.ActorInterpreterUtils;
import org.eclipse.core.resources.IResource;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.AtomicActor;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.gda.util.list.ListUtils;

public class PythonScript
extends AbstractScriptTransformer {
    private static final Logger logger = LoggerFactory.getLogger(PythonScript.class);
    private static String[] INTERPRETER_CHOICES = new String[]{"Jython", "Python"};
    private static String[] PYLINK_CHOICES = new String[]{"RPC", "Jep"};
    private static String[] PYDEBUG_CHOICES = new String[]{"Start new python rcp server", "Python rpc server already running"};
    private final Parameter createNewParameter = new Parameter((NamedObj)this, "Create Separate Interpreter", (Token)new BooleanToken(false));
    private boolean isNewInterpreter = false;
    private final Parameter passInputsParameter;
    private boolean isPassInputs = true;
    private final StringParameter interpreterTypeParam;
    private final StringParameter outputsParam;
    private List<String> outputs;
    private StringParameter pythonCommand;
    private StringParameter pythonLink;
    private StringParameter pythonDebug;
    private static final long serialVersionUID = 5076235276519285512L;

    public PythonScript(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        this.registerConfigurableParameter(this.createNewParameter);
        this.passInputsParameter = new Parameter((NamedObj)this, "Pass Inputs On", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.passInputsParameter);
        this.interpreterTypeParam = new StringParameter((NamedObj)this, "Interpreter Type"){

            public String[] getChoices() {
                return INTERPRETER_CHOICES;
            }
        };
        this.interpreterTypeParam.setExpression(INTERPRETER_CHOICES[1]);
        this.registerConfigurableParameter((Parameter)this.interpreterTypeParam);
        this.outputsParam = new StringParameter((NamedObj)this, "Dataset Outputs");
        this.registerConfigurableParameter((Parameter)this.outputsParam);
        this.pythonCommand = new StringParameter((NamedObj)this, "Python Interpreter Command");
        this.registerConfigurableParameter((Parameter)this.pythonCommand);
        this.pythonCommand.setExpression(PythonUtils.getPythonInterpreterCommand());
        this.pythonLink = new StringParameter((NamedObj)this, "Python Link"){

            public String[] getChoices() {
                return PYLINK_CHOICES;
            }
        };
        this.registerExpertParameter((Parameter)this.pythonLink);
        this.pythonLink.setExpression(PYLINK_CHOICES[0]);
        this.pythonDebug = new StringParameter((NamedObj)this, "Python Debug"){

            public String[] getChoices() {
                return PYDEBUG_CHOICES;
            }
        };
        this.registerExpertParameter((Parameter)this.pythonDebug);
        this.pythonDebug.setExpression(PYDEBUG_CHOICES[0]);
    }

    protected ResourceParameter getScriptParameter(Actor actor) throws Exception {
        return new ResourceParameter((NamedObj)actor, "Python Script", "Python Files", new String[]{"*.py", "*.jy"});
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.createNewParameter) {
            this.isNewInterpreter = ((BooleanToken)this.createNewParameter.getToken()).booleanValue();
        } else if (attribute == this.passInputsParameter) {
            this.isPassInputs = ((BooleanToken)this.passInputsParameter.getToken()).booleanValue();
        } else if (attribute == this.outputsParam) {
            this.outputs = ListUtils.getList((String)this.outputsParam.getExpression());
        }
        super.attributeChanged(attribute);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws Exception {
        if (this.isPython()) {
            if (PYLINK_CHOICES[0].equals(this.pythonLink.getExpression())) {
                return this.getPythonRpcMessage(list);
            }
            return this.getPythonJepMessage(list);
        }
        return this.getJythonMessage(list);
    }

    private DataMessageComponent getPythonRpcMessage(List<DataMessageComponent> list) throws Exception {
        PythonService pythonService = null;
        try {
            Object object;
            Object object22;
            HashMap<Object, Object> hashMap;
            if (PYDEBUG_CHOICES[1].equals(this.pythonDebug.getExpression())) {
                int n = PythonService.getDebugPort();
                pythonService = PythonService.openClient((int)n);
            } else {
                pythonService = PythonService.openConnection((String)this.pythonCommand.getExpression());
            }
            DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
            dataMessageComponent.setMeta(MessageUtils.getMeta(list));
            dataMessageComponent.putScalar("python_script", this.getResource().getName());
            HashMap<Object, Object> hashMap2 = hashMap = dataMessageComponent.getList() != null ? new HashMap<Object, Object>(dataMessageComponent.getList()) : new HashMap();
            if (dataMessageComponent.getScalar() != null) {
                for (Object object22 : dataMessageComponent.getScalar().keySet()) {
                    if (((String)object22).indexOf(46) > -1) continue;
                    object = (String)dataMessageComponent.getScalar().get(object22);
                    if (!PythonUtils.isLegalName((String)object22)) {
                        object22 = PythonUtils.getLegalVarName((String)object22, dataMessageComponent.getList().keySet());
                    }
                    try {
                        int n = Integer.parseInt((String)object);
                        hashMap.put(object22, n);
                    }
                    catch (Throwable throwable) {
                        try {
                            double d = Double.parseDouble((String)object);
                            hashMap.put(object22, d);
                        }
                        catch (Throwable throwable2) {
                            hashMap.put(object22, object);
                        }
                    }
                }
            }
            object22 = this.getResource();
            if (this.outputs == null) {
                this.outputs = Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList(this.outputs.size() + hashMap.size());
            arrayList.addAll(this.outputs);
            arrayList.addAll(hashMap.keySet());
            object = pythonService.runScript(object22.getLocation().toOSString(), hashMap, (Collection)arrayList);
            for (String string : object.keySet()) {
                Object v = object.get(string);
                if (v instanceof AbstractDataset) {
                    AbstractDataset abstractDataset = (AbstractDataset)v;
                    abstractDataset.setName(string);
                    dataMessageComponent.addList(string, abstractDataset);
                    continue;
                }
                dataMessageComponent.putScalar(string, String.valueOf(v));
            }
            DataMessageComponent dataMessageComponent2 = dataMessageComponent;
            return dataMessageComponent2;
        }
        catch (Throwable throwable) {
            throw this.createDataMessageException("Error when executing actor " + this.getName() + ": " + throwable.getMessage() + "\nPlease see log for more information.", throwable);
        }
        finally {
            if (pythonService != null) {
                pythonService.stop();
            }
        }
    }

    private DataMessageComponent getPythonJepMessage(List<DataMessageComponent> list) throws Exception {
        Jep jep = null;
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        try {
            try {
                jep = new Jep();
                ArrayList<String> arrayList = new ArrayList<String>(7);
                for (DataMessageComponent iResource2 : list) {
                    Object object;
                    if (iResource2.getList() != null) {
                        for (String string : iResource2.getList().keySet()) {
                            object = iResource2.getList().get(string);
                            if (object instanceof AbstractDataset) {
                                AbstractDataset n = (AbstractDataset)iResource2.getList().get(string);
                                NumpyUtils.setNumpy((Jep)jep, (AbstractDataset)n);
                                if (!this.isPassInputs) continue;
                                arrayList.add(string);
                                continue;
                            }
                            jep.set(string, object);
                        }
                    }
                    if (iResource2.getScalar() == null) continue;
                    for (String string : iResource2.getScalar().keySet()) {
                        if (string.indexOf(46) > -1) continue;
                        object = (String)iResource2.getScalar().get(string);
                        try {
                            int d = Integer.parseInt(object);
                            jep.set(string, d);
                        }
                        catch (Throwable throwable) {
                            try {
                                double d = Double.parseDouble(object);
                                jep.set(string, d);
                            }
                            catch (Throwable throwable2) {
                                jep.set(string, object);
                            }
                        }
                    }
                }
                IResource iResource = this.getResource();
                if (iResource.exists()) {
                    jep.runScript(iResource.getLocation().toOSString());
                }
                dataMessageComponent.addScalar(MessageUtils.getScalar(list));
                dataMessageComponent.setMeta(MessageUtils.getMeta(list));
                dataMessageComponent.putScalar("Python Script", this.getResource().getName());
                if (this.outputs == null) {
                    this.outputs = Collections.emptyList();
                }
                ArrayList arrayList2 = new ArrayList(this.outputs.size() + arrayList.size());
                arrayList2.addAll(this.outputs);
                arrayList2.addAll(arrayList);
                Iterator<Object> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    string = (String)iterator.next();
                    try {
                        dataMessageComponent.addList(string, NumpyUtils.getNumpy((Jep)jep, (String)string));
                    }
                    catch (Throwable throwable) {
                        dataMessageComponent.putScalar(string, jep.getValue(string).toString());
                    }
                }
            }
            catch (JepException jepException) {
                throw this.createDataMessageException("Script error in actor " + this.getName() + ": " + jepException.getMessage(), jepException);
            }
            catch (Throwable throwable) {
                logger.error(throwable.getStackTrace().toString());
                throw this.createDataMessageException("Error when executing actor " + this.getName() + ": " + throwable.getMessage() + "\nPlease see log for more information.", throwable);
            }
        }
        finally {
            if (jep != null) {
                jep.close();
            }
        }
        return dataMessageComponent;
    }

    private DataMessageComponent getJythonMessage(List<DataMessageComponent> list) throws Exception {
        Object object;
        Object object22;
        PythonInterpreter pythonInterpreter = this.isNewInterpreter ? JythonInterpreterUtils.getInterpreter() : ActorInterpreterUtils.getInterpreterForRun((AtomicActor)this);
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        for (DataMessageComponent iResource2 : list) {
            if (iResource2.getList() == null) continue;
            for (Object object22 : iResource2.getList().keySet()) {
                object = iResource2.getList().get(object22);
                pythonInterpreter.set((String)object22, object);
                if (!(object instanceof AbstractDataset)) continue;
                pythonInterpreter.exec(String.valueOf(object22) + " = jycore.Sciwrap(" + (String)object22 + ")");
                if (!this.isPassInputs) continue;
                arrayList.add(object22);
            }
        }
        IResource iResource = this.getResource();
        if (iResource.exists()) {
            pythonInterpreter.execfile((InputStream)new FileInputStream(iResource.getLocation().toOSString()));
        }
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        object22 = new HashMap(7);
        if (this.outputs == null) {
            this.outputs = Collections.emptyList();
        }
        ArrayList arrayList2 = new ArrayList(this.outputs.size() + arrayList.size());
        arrayList2.addAll(this.outputs);
        arrayList2.addAll(arrayList);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            PyObject pyObject = pythonInterpreter.get(object);
            AbstractDataset abstractDataset = (AbstractDataset)pyObject.__tojava__(AbstractDataset.class);
            if (abstractDataset instanceof PyProxy) {
                abstractDataset = abstractDataset.getView();
            }
            abstractDataset.setName(object);
            object22.put(object, abstractDataset);
        }
        dataMessageComponent.setList((Map)object22);
        dataMessageComponent.setMeta(MessageUtils.getMeta(list));
        dataMessageComponent.addScalar(MessageUtils.getScalar(list));
        dataMessageComponent.putScalar("Jython Script", this.getResource().getName());
        return dataMessageComponent;
    }

    private boolean isPython() {
        String string = this.interpreterTypeParam.getExpression();
        return INTERPRETER_CHOICES[1].equals(string);
    }

    public String getExtendedInfo() {
        return "Parses an expression of data sets using a Jython expression or script file.";
    }

    public void setMomlResource(IResource iResource) {
    }

    protected String getOperationName() {
        return this.isPython() ? "python" : "jython";
    }

    protected String createScript() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isPython()) {
            stringBuilder.append("from numpy import *\r\n");
        } else {
            stringBuilder.append("import " + AbstractDataset.class.getName() + " as _ds\r\n");
            stringBuilder.append("import scisoftpy as dnp\r\n");
            stringBuilder.append("import scisoftpy.core as scp\r\n");
            stringBuilder.append("import scisoftpy.maths as maths\r\n");
            stringBuilder.append("\r\n\r\n");
            List list = this.getInputVariables();
            if (list != null && list.size() > 0) {
                stringBuilder.append("# Jython script for manipulating data sets.\r\n");
                stringBuilder.append("# The variables going into this actor in the workflow are available in the script.\r\n");
                stringBuilder.append("# Expected variable sets available and set when this script is run:\r\n");
                for (IVariable iVariable : list) {
                    if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.ARRAY) continue;
                    stringBuilder.append("# ");
                    stringBuilder.append(iVariable.getVariableName());
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append("\r\n# Please provide maths of these variables and other available ones in the following lines.\r\n");
            }
        }
        return stringBuilder.toString();
    }

    public List<IVariable> getOutputVariables() {
        List list = super.getOutputVariables();
        if (this.outputs == null) {
            this.outputs = ListUtils.getList((String)this.outputsParam.getExpression());
        }
        if (this.outputs != null) {
            for (String object : this.outputs) {
                list.add(new Variable(object, IVariable.VARIABLE_TYPE.ARRAY, (Object)"[...]"));
            }
        }
        if (this.isPassInputs) {
            List list2 = this.getInputVariables();
            for (IVariable iVariable : list2) {
                if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.ARRAY) continue;
                list.add(iVariable);
            }
        }
        return list;
    }
}

