/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.process;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.util.commandline.ManagedCommandline;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.gda.util.OSUtils;

public class ProcessTransformer
extends AbstractDataMessageTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTransformer.class);
    private static final long serialVersionUID = -6156476506138933499L;
    private final StringParameter cmdParam;
    private final StringParameter outputVar;
    private final StringParameter winCmdParam;
    private final Parameter waitParam;
    private final StringParameter dirParam;
    private final DateFormat dateFormat = new SimpleDateFormat("dd_MMM_yyyy[HH'h'_mm'm'_ss's'_SS'ms']");

    public ProcessTransformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.cmdParam = new StringParameter((NamedObj)this, "Command");
        this.registerConfigurableParameter((Parameter)this.cmdParam);
        this.winCmdParam = new StringParameter((NamedObj)this, "Windows Command");
        this.registerConfigurableParameter((Parameter)this.winCmdParam);
        this.dirParam = new StringParameter((NamedObj)this, "Run Directory");
        this.registerConfigurableParameter((Parameter)this.dirParam);
        this.waitParam = new Parameter((NamedObj)this, "Wait", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.waitParam);
        this.outputVar = new StringParameter((NamedObj)this, "Output Variable");
        this.registerConfigurableParameter((Parameter)this.outputVar);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(0));
        this.passMode = (String)EXPRESSION_MODE.get(0);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        try {
            Object object;
            String string = OSUtils.isWindowsOS() && this.winCmdParam.getExpression() != null && !"".equals(this.winCmdParam.getExpression()) ? ParameterUtils.getSubstituedValue((Parameter)this.winCmdParam, list) : ParameterUtils.getSubstituedValue((Parameter)this.cmdParam, list);
            ManagedCommandline managedCommandline = new ManagedCommandline();
            if (OSUtils.isLinuxOS()) {
                managedCommandline.addArguments(new String[]{"/bin/sh", "-c", string});
            } else {
                managedCommandline.addArguments(new String[]{"cmd.exe", "/C", string});
            }
            String string2 = ParameterUtils.getSubstituedValue((Parameter)this.outputVar, list);
            if (string2 != null) {
                managedCommandline.setStreamLogsToLoggingAndSaved(true);
            } else {
                managedCommandline.setStreamLogsToLogging(true);
            }
            managedCommandline.setEnv(System.getenv());
            long l = System.currentTimeMillis();
            DataMessageComponent dataMessageComponent = MessageUtils.copy(list);
            dataMessageComponent.putScalar("execution_time", "" + l);
            dataMessageComponent.putScalar("execution_date", this.dateFormat.format(l));
            if (this.dirParam.getExpression() != null && !"".equals(this.dirParam.getExpression())) {
                object = ParameterUtils.getSubstituedValue((Parameter)this.dirParam, (DataMessageComponent)dataMessageComponent);
                String string3 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                File file = new File(String.valueOf(string3) + "/" + (String)object);
                if (!file.exists()) {
                    file.mkdirs();
                    AbstractPassModeTransformer.refreshResource((IResource)ModelUtils.getProject((NamedObj)this));
                }
                managedCommandline.setWorkingDir(file);
            }
            object = managedCommandline.execute();
            if (((BooleanToken)this.waitParam.getToken()).booleanValue()) {
                int n = ((Process)object).waitFor();
                logger.debug("Process '" + string + "' exited with code " + n);
            }
            AbstractPassModeTransformer.refreshResource((IResource)ModelUtils.getProject((NamedObj)this));
            if (string2 != null) {
                dataMessageComponent.putScalar(string2, managedCommandline.getStdoutAsString());
            }
            return dataMessageComponent;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot run command " + this.cmdParam.getExpression(), exception);
        }
    }

    public List<IVariable> getOutputVariables() {
        List list = super.getOutputVariables();
        long l = System.currentTimeMillis();
        list.add(new Variable("execution_time", IVariable.VARIABLE_TYPE.SCALAR, (Object)l));
        list.add(new Variable("execution_date", IVariable.VARIABLE_TYPE.SCALAR, (Object)this.dateFormat.format(l)));
        try {
            String string = ParameterUtils.getSubstituedValue((Parameter)this.outputVar);
            if (string != null) {
                list.add(new Variable(string, IVariable.VARIABLE_TYPE.SCALAR, (Object)"stdout"));
            }
        }
        catch (Exception exception) {
            logger.error("Cannot get expression name for " + this.outputVar.getDisplayName());
        }
        return list;
    }

    protected String getExtendedInfo() {
        return "An actor which runs a native process, may have input and output files.";
    }

    protected String getOperationName() {
        return "System Command";
    }
}

