/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.plot;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageSink;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class PlotSink
extends AbstractDataMessageSink {
    private boolean update;
    private String plotPartName;
    private String title;
    private Parameter updateParam = new Parameter((NamedObj)this, "Update Graph", (Token)new BooleanToken(false));
    private Parameter plotName;
    private Parameter plotTitle;
    private static final long serialVersionUID = -8241926002035209866L;

    public PlotSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.updateParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerConfigurableParameter(this.updateParam);
        this.plotName = new StringParameter((NamedObj)this, "Plot Name");
        this.plotName.setExpression("Plot 1");
        this.registerConfigurableParameter(this.plotName);
        this.plotPartName = this.plotName.getExpression();
        this.plotTitle = new StringParameter((NamedObj)this, "Plot Title");
        this.registerConfigurableParameter(this.plotTitle);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.updateParam) {
            this.setUpdate(((BooleanToken)this.updateParam.getToken()).booleanValue());
        } else if (attribute == this.plotName) {
            this.setPlotPartName(this.plotName.getExpression());
        } else if (attribute == this.plotTitle) {
            this.setTitle(this.plotTitle.getExpression());
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected void sendCachedData(List<DataMessageComponent> list) throws ProcessingException {
        try {
            IDataset iDataset = this.getXAxis(list);
            IDataset[] iDatasetArray = this.getYAxes(list);
            if ((iDatasetArray != null || iDataset.getShape().length == 1) && iDatasetArray == null) {
                iDatasetArray = new IDataset[]{iDataset};
                iDataset = AbstractDataset.arange((double)iDataset.getSize(), (int)3);
            }
        }
        catch (Exception exception) {
            if (list != null) {
                throw this.createDataMessageException("Cannot process plot, writing as a CSV instead", exception);
            }
            throw this.createDataMessageException("Cannot process plot!", exception);
        }
    }

    private IDataset[] getYAxes(List<DataMessageComponent> list) {
        List list2 = MessageUtils.getDatasets(list);
        if (list2.size() < 2) {
            return null;
        }
        list2.remove(0);
        return list2.toArray(new IDataset[list2.size()]);
    }

    private IDataset getXAxis(List<DataMessageComponent> list) {
        List list2 = MessageUtils.getDatasets(list);
        return (IDataset)list2.get(0);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public String getPlotPartName() {
        return this.plotPartName;
    }

    public void setPlotPartName(String string) {
        this.plotPartName = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

