/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.flow;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.message.ManagedMessage;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class TimerSource
extends AbstractDataMessageSource {
    private static final Logger logger = LoggerFactory.getLogger(TimerSource.class);
    private ManagedMessage triggerMsg;
    private Parameter sourceFreq = new Parameter((NamedObj)this, "Timing Frequency", (Token)new IntToken(100));
    private int totalTime;
    private static final long serialVersionUID = 1786893904448598313L;

    public TimerSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter(this.sourceFreq);
    }

    public void doPreInitialize() throws InitializationException {
        super.doPreInitialize();
        this.totalTime = 0;
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent = this.triggerMsg != null ? MessageUtils.coerceMessage((ManagedMessage)this.triggerMsg) : new DataMessageComponent();
            dataMessageComponent.putScalar("current_time", String.valueOf(System.currentTimeMillis()));
            dataMessageComponent.putScalar("total_time", String.valueOf(this.totalTime));
            return MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent);
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot send data from " + ((Object)((Object)this)).getClass().getSimpleName(), exception);
        }
    }

    protected boolean mustWaitForTrigger() {
        if (this.triggerMsg != null) {
            return false;
        }
        return this.trigger.getWidth() > 0;
    }

    protected String getExtendedInfo() {
        return "Monitors fridge temperature evey 100ms";
    }

    public boolean hasNoMoreMessages() {
        return this.isFinishRequested();
    }

    protected boolean doPostFire() throws ProcessingException {
        try {
            int n = ((IntToken)this.sourceFreq.getToken()).intValue();
            if (this.isFinishRequested()) {
                return super.doPostFire();
            }
            Thread.sleep(n);
            this.totalTime += n;
        }
        catch (Exception exception) {
            throw new ProcessingException("Cannot wait for new temperature data read!", (Object)this, (Throwable)exception);
        }
        return super.doPostFire();
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            list.add(new Variable("current_time", IVariable.VARIABLE_TYPE.SCALAR, (Object)System.currentTimeMillis(), Long.class));
            list.add(new Variable("time_time", IVariable.VARIABLE_TYPE.SCALAR, (Object)0, Long.class));
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggerMsg = managedMessage;
    }
}

