/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.flow;

import org.dawb.passerelle.actors.flow.ExpressionContainer;
import org.dawb.passerelle.actors.flow.ExpressionDialog;
import org.dawb.passerelle.common.parameter.CellEditorParameter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ExpressionParameter
extends CellEditorParameter {
    private String nameParameter;
    private boolean automaticExpressionCreation = true;
    private static final long serialVersionUID = 8999174318856900808L;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionParameter.class);

    public ExpressionParameter(NamedObj namedObj, String string) throws IllegalActionException, NameDuplicationException {
        super(namedObj, string);
    }

    public CellEditor createCellEditor(Control control) {
        DialogCellEditor dialogCellEditor = new DialogCellEditor((Composite)control){

            protected Object openDialogBox(Control control) {
                ExpressionDialog expressionDialog = new ExpressionDialog(control.getShell(), ExpressionParameter.this.getContainer());
                expressionDialog.setAutomaticExpressionCreation(ExpressionParameter.this.automaticExpressionCreation);
                expressionDialog.create();
                if (ExpressionParameter.this.nameParameter != null) {
                    expressionDialog.setNameLabel(ExpressionParameter.this.nameParameter);
                }
                expressionDialog.getShell().setSize(400, 435);
                expressionDialog.getShell().setText("Create expressions");
                expressionDialog.setBean(ExpressionParameter.this.getBeanFromValue(ExpressionContainer.class));
                int n = expressionDialog.open();
                if (n == 0) {
                    return ExpressionParameter.this.getValueFromBean((ExpressionContainer)expressionDialog.getBean());
                }
                return null;
            }

            protected void updateContents(Object object) {
                if (this.getDefaultLabel() == null) {
                    return;
                }
                this.getDefaultLabel().setText(ExpressionParameter.this.getRendererText());
            }
        };
        return dialogCellEditor;
    }

    public String getRendererText() {
        return this.getBeanFromValue(ExpressionContainer.class).toString();
    }

    public void setNameParameter(String string) {
        this.nameParameter = string;
    }

    public boolean isAutomaticExpressionCreation() {
        return this.automaticExpressionCreation;
    }

    public void setAutomaticExpressionCreation(boolean bl) {
        this.automaticExpressionCreation = bl;
    }
}

