/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.flow;

import java.util.HashMap;
import java.util.List;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.passerelle.actors.flow.ExpressionBean;
import org.dawb.passerelle.actors.flow.ExpressionComposite;
import org.dawb.passerelle.actors.flow.ExpressionContainer;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.IVariable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import ptolemy.kernel.util.NamedObj;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.dialog.BeanDialog;

public class ExpressionDialog
extends BeanDialog {
    private VerticalListEditor expressions;
    private boolean automaticExpressionCreation = true;
    private AbstractDataMessageTransformer parent;

    protected ExpressionDialog(Shell shell, NamedObj namedObj) {
        super(shell);
        this.parent = (AbstractDataMessageTransformer)namedObj;
    }

    public void setNameLabel(String string) {
        ExpressionComposite expressionComposite = (ExpressionComposite)((Object)this.expressions.getEditorUI());
        expressionComposite.setNameLabel(string);
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.expressions = new VerticalListEditor(composite2, 0);
        this.expressions.setRequireSelectionPack(false);
        this.expressions.setLayoutData((Object)new GridData(4, 4, true, true));
        this.expressions.setMinItems(0);
        this.expressions.setMaxItems(25);
        this.expressions.setDefaultName(this.getActorName());
        this.expressions.setEditorClass(ExpressionBean.class);
        this.expressions.setEditorUI(this.createExpressionComposite());
        this.expressions.setNameField("actorName");
        this.expressions.setAdditionalFields(new String[]{"expression"});
        this.expressions.setColumnWidths(new int[]{100, 300});
        this.expressions.setListHeight(150);
        GridUtils.setVisibleAndLayout((Control)this.expressions, (boolean)true);
        return composite2;
    }

    private Object createExpressionComposite() {
        ExpressionComposite expressionComposite = new ExpressionComposite((Composite)this.expressions, 0);
        if (this.automaticExpressionCreation) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
            List list = this.parent.getInputVariables();
            for (IVariable iVariable : list) {
                Object object = iVariable.getExampleValue();
                if (object instanceof String) {
                    try {
                        object = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {}
                }
                hashMap.put(iVariable.getVariableName(), object);
            }
            expressionComposite.setExpressionVariables(hashMap);
        }
        return expressionComposite;
    }

    private String getActorName() {
        List list = this.parent.output.connectedPortList();
        if (list != null && !list.isEmpty()) {
            return ((NamedObj)list.get(0)).getContainer().getName();
        }
        return "actor_name";
    }

    public VerticalListEditor getExpressions() {
        return this.expressions;
    }

    public int open() {
        this.expressions.setShowAdditionalFields(true);
        int n = super.open();
        this.expressions = null;
        return n;
    }

    public void setBean(Object object) {
        ExpressionContainer expressionContainer = (ExpressionContainer)object;
        List list = this.parent.output.connectedPortList();
        if (list != null && !list.isEmpty()) {
            for (NamedObj namedObj : list) {
                String string = namedObj.getContainer().getName();
                if (expressionContainer.containsActor(string)) continue;
                expressionContainer.addExpression(new ExpressionBean(string, "true"));
            }
        }
        super.setBean((Object)expressionContainer);
    }

    public boolean isAutomaticExpressionCreation() {
        return this.automaticExpressionCreation;
    }

    public void setAutomaticExpressionCreation(boolean bl) {
        this.automaticExpressionCreation = bl;
    }
}

