/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.file;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.actor.IPartListenerActor;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import com.isencia.passerelle.workbench.util.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.dawb.passerelle.editors.SubstitutionEditor;
import org.dawb.passerelle.editors.SubstitutionParticipant;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class SubstituteTransformer
extends AbstractDataMessageTransformer
implements SubstitutionParticipant,
IResourceActor,
IPartListenerActor {
    private static final long serialVersionUID = -5382424251791664468L;
    private static Logger logger = LoggerFactory.getLogger(SubstituteTransformer.class);
    private ResourceParameter templateParam = new ResourceParameter((NamedObj)this, "Template Source");
    private ResourceParameter outputParam;
    private StringParameter encoding;

    public SubstituteTransformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.templateParam);
        this.outputParam = new ResourceParameter((NamedObj)this, "Output");
        this.outputParam.setResourceType(2);
        this.outputParam.setExpression("/${project_name}/output/");
        this.registerConfigurableParameter((Parameter)this.outputParam);
        this.encoding = new StringParameter((NamedObj)this, "Encoding"){
            private static final long serialVersionUID = -1902977727142062610L;

            public String[] getChoices() {
                return new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
            }
        };
        this.encoding.setExpression("UTF-8");
        this.registerConfigurableParameter((Parameter)this.encoding);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        String string;
        String string2 = null;
        String string3 = null;
        try {
            string2 = ParameterUtils.getSubstituedValue((Parameter)this.templateParam, list);
            string3 = ParameterUtils.getSubstituedValue((Parameter)this.outputParam, list);
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot substitute parameter of " + this.templateParam.getDisplayName() + " and/or " + this.outputParam.getDisplayName() + " in " + this.getDisplayName(), exception);
        }
        IFile iFile = (IFile)ResourceUtils.getResource((String)string2);
        IResource iResource = ResourceUtils.getResource((String)string3);
        IFile iFile2 = null;
        if (iResource instanceof IContainer) {
            if (iResource instanceof IProject) {
                iFile2 = ((IProject)iResource).getFile(iFile.getName());
            } else if (iResource instanceof IFolder) {
                iFile2 = ((IFolder)iResource).getFile(iFile.getName());
            }
        } else if (iFile2 instanceof IFile) {
            iFile2 = (IFile)iResource;
        }
        try {
            if (!iFile2.exists()) {
                iFile2.create(iFile.getContents(), true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                iFile2.setContents(iFile.getContents(), true, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot read file " + string2 + " and/or write file " + string3, exception);
        }
        try {
            string = SubstituteUtils.substitute((InputStream)iFile2.getContents(), (Map)MessageUtils.getScalar(list));
            iFile2.setContents((InputStream)new ByteArrayInputStream(string.getBytes(this.encoding.getExpression())), true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot substitute " + iFile2, exception);
        }
        string = MessageUtils.mergeAll(list);
        string.putScalar("substitute_output", iFile2.getLocation().toOSString());
        return string;
    }

    public List<IVariable> getOutputVariables() {
        List list = super.getOutputVariables();
        list.add(new Variable("substitute_output", IVariable.VARIABLE_TYPE.PATH, (Object)this.outputParam.getExpression(), String.class));
        return list;
    }

    protected String getOperationName() {
        return "Substitute file with variables.";
    }

    public void setMomlResource(IResource iResource) {
    }

    public int getResourceCount() {
        return 1;
    }

    public ResourceObject getResource(int n) throws Exception {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource((Object)this.getResource());
            resourceObject.setResourceTypeName("Substitution Editor");
            resourceObject.setEditorId("org.dawb.passerelle.editors.substitutionEditor");
            return resourceObject;
        }
        return null;
    }

    private IFile getResource() throws Exception {
        String string = ParameterUtils.substitute((String)this.templateParam.getExpression(), (NamedObj)this);
        IFile iFile = (IFile)ResourceUtils.getResource((String)string);
        return iFile;
    }

    @Override
    public String getDefaultSubstitution() {
        if (this.templateParam.getExpression() == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = FileUtils.readFile((File)new File(this.templateParam.getExpression()));
        }
        catch (Exception exception) {
            return "";
        }
        return stringBuffer != null ? stringBuffer.toString() : "";
    }

    public void partPreopen(ResourceObject resourceObject) {
        try {
            IFile iFile = this.getResource();
            if (!iFile.exists()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getDefaultSubstitution().getBytes("UTF-8"));
                if (!iFile.getParent().exists() && iFile.getParent() instanceof IFolder) {
                    IFolder iFolder = (IFolder)iFile.getParent();
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            logger.error("Cannot create file " + resourceObject.getResourceTypeName(), (Throwable)exception);
        }
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart, ResourceObject resourceObject) {
        SubstitutionEditor substitutionEditor = (SubstitutionEditor)iWorkbenchPart;
        substitutionEditor.setSubstitutionParticipant(this);
        iWorkbenchPart.setFocus();
    }
}

