/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.file;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.Grep;
import org.dawb.passerelle.common.actors.AbstractDataMessageSink;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class OpenFileSink
extends AbstractDataMessageSink {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileSink.class);
    private Parameter fileNameParam = new StringParameter((NamedObj)this, "File Path");
    private String fileName;
    private static final long serialVersionUID = -8241926002035209866L;

    public OpenFileSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.fileNameParam.setExpression("${file_path}");
        this.registerConfigurableParameter(this.fileNameParam);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(0));
        this.memoryManagementParam.setVisibility(Settable.NONE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileNameParam) {
            this.fileName = this.fileNameParam.getExpression();
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected void sendCachedData(List<DataMessageComponent> list) throws ProcessingException {
        List list2 = Grep.group((String)this.fileName, (String)"\\$\\{([a-zA-Z0-9_ ]+)\\}", (int)1);
        for (DataMessageComponent dataMessageComponent : list) {
            try {
                String[] stringArray;
                Map map = MessageUtils.getValues((DataMessageComponent)dataMessageComponent, (Collection)list2, (NamedObj)this);
                if (!list2.isEmpty() && map.isEmpty()) continue;
                String string = SubstituteUtils.substitute((String)this.fileName, (Map)map);
                String[] stringArray2 = stringArray = string.split("\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    try {
                        MBeanServerConnection mBeanServerConnection = ActorUtils.getWorkbenchConnection();
                        Object object = mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "openFile", new Object[]{string2}, new String[]{String.class.getName()});
                        if (object == null || !((Boolean)object).booleanValue()) {
                            logger.error("Cannot open file " + string2);
                        }
                    }
                    catch (Exception exception) {
                        logger.debug("Cannot get workbench service, however this is legal for when there is no workbench and the workflow runs in batch.");
                        logger.trace("Cannot get workbench service, however this is legal for when there is no workbench and the workflow runs in batch.", (Throwable)exception);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.error("Cannot open file " + this.fileName + ". Expand probably failed on value because scalar value not present.");
            }
        }
    }
}

