/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.file;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.Grep;
import org.dawb.passerelle.common.actors.AbstractDataMessageSink;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class MonitorFolderSink
extends AbstractDataMessageSink {
    private static final Logger logger = LoggerFactory.getLogger(MonitorFolderSink.class);
    private Parameter dirNameParam = new StringParameter((NamedObj)this, "Directory Path");
    private Parameter monitorParam;
    private String dirName;
    private String fullPath;
    private boolean isMonitoring;
    private static final long serialVersionUID = -8241926002035209866L;

    public MonitorFolderSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.dirNameParam.setExpression("${file_dir}");
        this.registerConfigurableParameter(this.dirNameParam);
        this.monitorParam = new Parameter((NamedObj)this, "Start Monitor");
        this.monitorParam.setToken((Token)new BooleanToken(false));
        this.registerConfigurableParameter(this.monitorParam);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(1));
        this.memoryManagementParam.setVisibility(Settable.NONE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.dirNameParam) {
            this.dirName = this.dirNameParam.getExpression();
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected void sendCachedData(List<DataMessageComponent> list) throws ProcessingException {
        List list2 = Grep.group((String)this.dirName, (String)"\\$\\{([a-zA-Z0-9_ ]+)\\}", (int)1);
        DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
        try {
            Map map = MessageUtils.getValues((DataMessageComponent)dataMessageComponent, (Collection)list2, (NamedObj)this);
            if (!list2.isEmpty() && map.isEmpty()) {
                return;
            }
            this.fullPath = SubstituteUtils.substitute((String)this.dirName, (Map)map);
            try {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fullPath);
                if (iResource != null) {
                    this.fullPath = iResource.getLocation().toOSString();
                }
            }
            catch (Exception exception) {
                logger.error("Cannot find relative path! " + this.fullPath, (Throwable)exception);
            }
            this.isMonitoring = ((BooleanToken)this.monitorParam.getToken()).booleanValue();
            this.fireOpenMonitor();
        }
        catch (Exception exception) {
            logger.error("Cannot open file " + this.dirName + ". Expand probably failed on value because scalar value not present.");
        }
    }

    private void fireOpenMonitor() {
        try {
            MBeanServerConnection mBeanServerConnection = ActorUtils.getWorkbenchConnection();
            Object object = mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "monitorDirectory", new Object[]{this.fullPath, this.isMonitoring}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
            if (object == null || !((Boolean)object).booleanValue()) {
                logger.error("Cannot monitor directory " + this.fullPath);
            }
        }
        catch (Exception exception) {
            logger.debug("Cannot get workbench service, however this is legal for when there is no workbench and the workflow runs in batch.");
            logger.trace("Cannot get workbench service, however this is legal for when there is no workbench and the workflow runs in batch.", (Throwable)exception);
        }
    }

    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.fullPath == null) {
            return;
        }
        if (this.isFinishRequested()) {
            this.fireOpenMonitor();
        }
    }
}

