/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.edna;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dawb.common.python.EDJob;
import org.dawb.common.python.PythonUtils;
import org.dawb.common.python.rpc.PythonService;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.IFileUtils;
import org.dawb.common.util.io.PropUtils;
import org.dawb.common.util.xml.XMLUtils;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.XPathVariable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.dawb.passerelle.editors.SubstitutionParticipant;
import org.dawb.passerelle.editors.XPathParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.util.Time;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public abstract class AbstractEdnaPlugin
extends AbstractDataMessageTransformer
implements Actor,
IResourceActor,
IVariableProvider,
SubstitutionParticipant,
XPathParticipant {
    private static String[] PYLINK_CHOICES = new String[]{"RPC", "Jep"};
    private static String[] PYDEBUG_CHOICES = new String[]{"Start new python rcp server", "Python rpc server already running"};
    private static Logger logger = LoggerFactory.getLogger(AbstractEdnaPlugin.class);
    private static final long serialVersionUID = 1551436102354087550L;
    protected StringParameter pluginParam = new StringParameter((NamedObj)this, "Plugin Name");
    protected String plugin;
    protected ResourceParameter inputParam;
    protected String inputString;
    protected ResourceParameter outputParam;
    protected String output;
    private final Parameter passInputsParameter;
    private final Parameter debugModeParameter;
    private final Parameter enableChangeWorkingDirParameter;
    private boolean isPassInputs = true;
    private boolean isDebugMode = false;
    private boolean isEnabledChangeWorkingDir = false;
    private StringParameter pythonCommand;
    private StringParameter pythonLink;
    private StringParameter pythonDebug;
    protected static PythonService sharedService;
    protected static String managerName;
    private String cachedTagName = null;
    private IResource momlFile;
    private static final DateFormat DATE_FOLDER;
    private static final Object LOCK;
    private static final Pattern FIRST_TAG;

    static {
        DATE_FOLDER = new SimpleDateFormat("yyyyMMdd_HHmmss");
        LOCK = new Object();
        FIRST_TAG = Pattern.compile("\\<([a-zA-Z0-9_]+)( |\\>).*", 32);
    }

    public AbstractEdnaPlugin(String string, CompositeEntity compositeEntity, String string2) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string2);
        this.registerExpertParameter((Parameter)this.pluginParam);
        this.pluginParam.setExpression(string);
        this.plugin = string;
        this.inputParam = new ResourceParameter((NamedObj)this, "Input Template", "XML File", new String[]{"*.xml"});
        this.registerConfigurableParameter((Parameter)this.inputParam);
        this.outputParam = new ResourceParameter((NamedObj)this, "Output Template", "XML File", new String[]{"*.xml"});
        this.registerConfigurableParameter((Parameter)this.outputParam);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(1));
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
        this.passInputsParameter = new Parameter((NamedObj)this, "Pass Inputs On", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.passInputsParameter);
        this.debugModeParameter = new Parameter((NamedObj)this, "Debug mode", (Token)new BooleanToken(false));
        this.registerConfigurableParameter(this.debugModeParameter);
        this.enableChangeWorkingDirParameter = new Parameter((NamedObj)this, "Enable change to edna_working_dir", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.enableChangeWorkingDirParameter);
        this.pythonCommand = new StringParameter((NamedObj)this, "Python Interpreter Command");
        this.registerConfigurableParameter((Parameter)this.pythonCommand);
        this.pythonCommand.setExpression(PythonUtils.getPythonInterpreterCommand());
        this.pythonLink = new StringParameter((NamedObj)this, "Python Link"){

            public String[] getChoices() {
                return PYLINK_CHOICES;
            }
        };
        this.registerExpertParameter((Parameter)this.pythonLink);
        this.pythonLink.setExpression(PYLINK_CHOICES[0]);
        this.pythonDebug = new StringParameter((NamedObj)this, "Python Debug"){

            public String[] getChoices() {
                return PYDEBUG_CHOICES;
            }
        };
        this.registerExpertParameter((Parameter)this.pythonDebug);
        this.pythonDebug.setExpression(PYDEBUG_CHOICES[0]);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pluginParam) {
            this.plugin = this.pluginParam.getExpression();
        } else if (attribute == this.inputParam) {
            this.inputString = this.inputParam.getExpression();
        } else if (attribute == this.passInputsParameter) {
            BooleanToken booleanToken = (BooleanToken)this.passInputsParameter.getToken();
            this.isPassInputs = booleanToken.booleanValue();
        } else if (attribute == this.debugModeParameter) {
            BooleanToken booleanToken = (BooleanToken)this.debugModeParameter.getToken();
            this.isDebugMode = booleanToken.booleanValue();
        } else if (attribute == this.enableChangeWorkingDirParameter) {
            BooleanToken booleanToken = (BooleanToken)this.enableChangeWorkingDirParameter.getToken();
            this.isEnabledChangeWorkingDir = booleanToken.booleanValue();
        } else if (attribute == this.outputParam) {
            this.output = this.outputParam.getExpression();
        }
        super.attributeChanged(attribute);
    }

    public boolean doPreFire() throws ProcessingException {
        boolean bl = super.doPreFire();
        if (PYLINK_CHOICES[0].equals(this.pythonLink.getExpression())) {
            String string = this.getManager().getName();
            if (sharedService == null || !string.equals(managerName)) {
                boolean bl2 = PYDEBUG_CHOICES[1].equals(this.pythonDebug.getExpression());
                try {
                    if (bl2) {
                        logger.debug(String.valueOf(this.getName()) + ": setting shared rpc service");
                        sharedService = PythonService.openClient((int)PythonService.getDebugPort());
                    } else {
                        logger.debug(String.valueOf(this.getName()) + ": setting normal rpc service");
                        sharedService = PythonService.openConnection((String)this.pythonCommand.getExpression());
                    }
                    this.getManager().addExecutionListener(new ExecutionListener(){

                        public void executionFinished(Manager manager) {
                            sharedService.stop();
                        }

                        public void managerStateChanged(Manager manager) {
                        }

                        public void executionError(Manager manager, Throwable throwable) {
                        }
                    });
                }
                catch (Exception exception) {
                    throw new ProcessingException("Cannot start python connection!", (Object)this, (Throwable)exception);
                }
                managerName = string;
            }
        }
        return bl;
    }

    protected abstract String getSchemaLocation();

    protected abstract String getPythonLocation();

    public abstract String getDefaultInputXML();

    protected abstract String getExampleOutputLocation();

    public abstract Properties getDefaultOutputProperties();

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        String string = null;
        IFolder iFolder = null;
        logger.debug(String.valueOf(this.getName()) + " - in AbstractEdnaPlugin.getTransformedMessage");
        try {
            Object object2;
            iFolder = this.getEdnaWorkingDirFolder();
            String string2 = iFolder.getLocation().lastSegment();
            String string3 = iFolder.getLocation().toOSString();
            if (this.isEnabledChangeWorkingDir) {
                for (DataMessageComponent eDJob2 : list) {
                    if (eDJob2.getScalar() == null) continue;
                    for (Object object2 : eDJob2.getScalar().keySet()) {
                        boolean map2;
                        if (!((String)object2).equals("edna_working_dir") || (map2 = new File(string3 = String.valueOf((String)eDJob2.getScalar().get(object2)) + "/" + string2).mkdirs())) continue;
                        logger.warn("Cannot create EDNA working directory: " + string3);
                        string3 = iFolder.getLocation().toOSString();
                        logger.warn("Reverting back to workspace location: " + string3);
                    }
                }
            }
            EDJob eDJob = new EDJob(sharedService, this.plugin, string3);
            String string4 = this.getDataInput(list);
            eDJob.setDataInput(string4);
            eDJob.setDebugMode(this.isDebugMode);
            eDJob.execute();
            string = eDJob.getDataOutput();
            object2 = PropUtils.loadProperties((InputStream)this.getOutputFile().getContents());
            Map map = XPathVariable.getXPaths((Map)object2);
            Map map2 = XPathVariable.getRenames((Map)object2);
            Map map3 = MessageUtils.getValues(list, map.keySet(), (NamedObj)this);
            if (map == null) {
                throw this.createDataMessageException("Cannot run edna task " + this.getName() + ", the xpaths could not be found!", null);
            }
            if (map3 == null) {
                throw this.createDataMessageException("Cannot run edna task " + this.getName() + ", the xpath existing variables could not be extracted!", null);
            }
            if (string == null || "".equals(string)) {
                throw this.createDataMessageException("Cannot run edna task " + this.getName() + ", the output XML is null!", null);
            }
            DataMessageComponent dataMessageComponent = new DataMessageComponent();
            Map map4 = XMLUtils.getVariables((Map)map, (String)string, (Map)map3);
            this.transformNames(map4, map2);
            this.transformOutputValues(map4);
            dataMessageComponent.setMeta(MessageUtils.getMeta(list));
            if (this.isPassInputs) {
                Map map5 = MessageUtils.getScalar(list);
                dataMessageComponent.addScalar(map5);
            }
            dataMessageComponent.addScalar(map4, true);
            this.assignAdditiveProperties(dataMessageComponent, map);
            DataMessageComponent dataMessageComponent2 = dataMessageComponent;
            return dataMessageComponent2;
        }
        catch (Throwable throwable) {
            logger.error("Output XML from " + this.getName() + " may be invalid. It is:\n" + string);
            throw this.createDataMessageException("Cannot run edna task " + this.plugin, throwable);
        }
        finally {
            try {
                if (iFolder != null) {
                    iFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    AbstractPassModeTransformer.refreshResource((IResource)iFolder.getProject());
                }
            }
            catch (Throwable throwable) {
                logger.error("Cannot refresh folder " + iFolder);
                throw this.createDataMessageException("Cannot run edna task " + this.plugin, throwable);
            }
        }
    }

    public String getEdnaProject() {
        return System.getenv("EDNA_HOME");
    }

    private void assignAdditiveProperties(DataMessageComponent dataMessageComponent, Map map) {
        for (Object k : map.keySet()) {
            if (map.get(k) == null || "".equals(map.get(k))) continue;
            dataMessageComponent.setValueType(k.toString(), DataMessageComponent.VALUE_TYPE.OVERWRITE_STRING);
        }
    }

    protected String getDataInput(List<DataMessageComponent> list) throws Exception {
        IFile iFile = this.getInputFile();
        List list2 = XMLUtils.getVariables((IFile)iFile);
        Map map = MessageUtils.getValues(list, (Collection)list2, (NamedObj)this);
        return SubstituteUtils.substitute((InputStream)iFile.getContents(), (Map)map);
    }

    public int getResourceCount() {
        return 2;
    }

    public ResourceObject getResource(int n) {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource((Object)this.getLinkerFile());
            resourceObject.setResourceTypeName("Linker");
            resourceObject.setEditorId("org.dawb.passerelle.editors.ednaEditor");
            return resourceObject;
        }
        ResourceObject resourceObject = new ResourceObject();
        File file = new File(String.valueOf(this.getEdnaProject()) + "/" + this.getPythonLocation());
        resourceObject.setResource((Object)file);
        resourceObject.setResourceTypeName("'" + this.plugin + "'");
        return resourceObject;
    }

    protected String getOutputTagName() throws Exception {
        String string = this.getInputTagName();
        string = string.replace("Input", "Output");
        string = string.replace("input", "output");
        return string;
    }

    protected abstract String getInputTagName() throws Exception;

    public void setMomlResource(IResource iResource) {
        this.momlFile = iResource;
    }

    private IResource getLinkerFile() {
        if (!PlatformUI.isWorkbenchRunning() || this.momlFile == null) {
            return null;
        }
        IFolder iFolder = null;
        try {
            iFolder = this.getEdnaXmlFolder();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("org.dawb.edna.name = ");
            stringBuilder.append(this.getName());
            stringBuilder.append("\n");
            stringBuilder.append("org.dawb.edna.moml = ");
            stringBuilder.append(this.momlFile.getFullPath().toString());
            stringBuilder.append("\n");
            stringBuilder.append("org.dawb.edna.input = ");
            stringBuilder.append(this.getInputFile().getFullPath().toString());
            stringBuilder.append("\n");
            stringBuilder.append("org.dawb.edna.output = ");
            stringBuilder.append(this.getOutputFile().getFullPath().toString());
            stringBuilder.append("\n");
            stringBuilder.append("org.dawb.edna.schema = ");
            stringBuilder.append(String.valueOf(this.getEdnaProject()) + "/" + this.getSchemaLocation());
            stringBuilder.append("\n");
            IFile iFile = iFolder.getFile(String.valueOf(this.getName()) + ".properties");
            if (iFile.exists()) {
                iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
            iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
            iFile.setHidden(true);
            return iFile;
        }
        catch (Exception exception) {
            logger.error("Cannot create input xml!", (Throwable)exception);
            return null;
        }
    }

    protected IFile getInputFile() {
        try {
            return this.getFileForParameter(this.inputParam, this.getInputTagName(), "xml", this.getDefaultInputXML());
        }
        catch (Exception exception) {
            logger.error("Cannot create input xml!", (Throwable)exception);
            return null;
        }
    }

    protected IFile getOutputFile() {
        try {
            String string = PropUtils.getPropertiesAsString((Properties)this.getDefaultOutputProperties());
            return this.getFileForParameter(this.outputParam, this.getOutputTagName(), "properties", string);
        }
        catch (Exception exception) {
            logger.error("Cannot create input xml!", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFile getFileForParameter(ResourceParameter resourceParameter, String string, String string2, String string3) throws Exception {
        ResourceParameter resourceParameter2 = resourceParameter;
        synchronized (resourceParameter2) {
            String string4 = resourceParameter.getExpression();
            string4 = ParameterUtils.substitute((String)string4, (NamedObj)this);
            IFile iFile = null;
            if (!string4.equals("")) {
                iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string4);
                logger.debug(String.valueOf(this.getName()) + " - Linker getFileForParameter path=" + string4);
            }
            IFolder iFolder = this.getEdnaXmlFolder();
            if (iFile == null) {
                iFile = IFileUtils.getUniqueIFile((IFolder)iFolder, (String)string, (String)string2);
                resourceParameter.setExpression(iFile.getFullPath().toString());
                logger.debug(String.valueOf(this.getName()) + " - Linker new input file: " + iFile.getFullPath().toString());
            } else {
                resourceParameter.setExpression(iFile.getFullPath().toString());
                logger.debug(String.valueOf(this.getName()) + " - Linker existing input file: " + iFile.getFullPath().toString());
            }
            if (!iFile.exists()) {
                if (System.getProperty("org.dawb.worbench.jmx.service") == null || !System.getProperty("org.dawb.worbench.jmx.service").equals("true")) {
                    logger.debug(String.valueOf(this.getName()) + " - Linker input file doesn't exist, we create one");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF-8"));
                    iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    throw this.createDataMessageException("Cannot run edna task " + this.getName() + ", the linker path(s) could not be found!", null);
                }
            }
            return iFile;
        }
    }

    private IFolder getEdnaXmlFolder() throws Exception {
        IProject iProject = this.getProject();
        IFolder iFolder = iProject.getFolder((IPath)new Path("edna-xml"));
        if (!iFolder.exists()) {
            try {
                iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                logger.error("Did not create new folder " + iFolder.getName(), (Throwable)exception);
            }
        }
        return iFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFolder getEdnaWorkingDirFolder() throws Exception {
        IProject iProject = this.getProject();
        logger.debug(String.valueOf(this.getName()) + " - Containing project is " + iProject);
        IFolder iFolder = iProject.getFolder("edna-working-dir");
        Object object = LOCK;
        synchronized (object) {
            String string;
            IFolder iFolder2;
            Time time;
            if (!iFolder.exists()) {
                iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            Time time2 = time = this.getDirector() != null ? this.getDirector().getModelTime() : new Time(null, 0L);
            if (time.getLongValue() <= 0L) {
                time = new Time(this.getDirector(), System.currentTimeMillis());
                if (this.getDirector() != null) {
                    this.getDirector().setModelTime(time);
                }
            }
            if (!(iFolder2 = iFolder.getFolder(string = DATE_FOLDER.format(new Date(time.getLongValue())))).exists()) {
                iFolder2.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            return iFolder2;
        }
    }

    @Override
    public List<IVariable> getInputVariables() {
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        ArrayList<String> arrayList2 = new ArrayList<String>(7);
        List list = super.getInputVariables();
        for (IVariable iVariable : list) {
            if (arrayList2.contains(iVariable.getVariableName())) continue;
            arrayList.add(iVariable);
            arrayList2.add(iVariable.getVariableName());
        }
        return arrayList;
    }

    public boolean isDefinitelyLocalOutput(String string) throws IOException, CoreException {
        Properties properties = PropUtils.loadProperties((InputStream)this.getOutputFile().getContents());
        return properties.containsKey(string);
    }

    protected void transformOutputValues(Map<String, String> map) {
    }

    protected void transformNames(Map<String, String> map, Map<String, String> map2) {
        if (map2 == null || map2.isEmpty()) {
            return;
        }
        for (String string : map2.keySet()) {
            String string2 = map2.get(string);
            String string3 = this.transformName(map.get(string), string2);
            map.put(string, string3);
        }
    }

    private String transformName(String string, String string2) {
        if (string2 == null || string == null) {
            return string;
        }
        if ("".equals(string2) || "".equals(string)) {
            return string;
        }
        Matcher matcher = FIRST_TAG.matcher(string.trim());
        if (!matcher.matches()) {
            return string;
        }
        String string3 = matcher.group(1);
        string = string.replace("<" + string3 + ">", "<" + string2 + ">");
        string = string.replace("<" + string3 + "/>", "<" + string2 + "/>");
        string = string.replace("<" + string3 + " ", "<" + string2 + " ");
        string = string.replace("</" + string3 + ">", "</" + string2 + ">");
        return string;
    }

    protected void transformExampleValue(IVariable iVariable) {
        if (iVariable instanceof XPathVariable) {
            XPathVariable xPathVariable = (XPathVariable)iVariable;
            if (this.getExampleOutputLocation() != null) {
                xPathVariable.setExampleValue((Object)this.getExampleValueFromFile(this.getExampleOutputLocation(), xPathVariable.getxPath(), xPathVariable.getRename()));
            }
        }
    }

    protected String getExampleValueFromFile(String string, String string2, String string3) {
        File file = new File(String.valueOf(this.getEdnaProject()) + "/" + string);
        try {
            String string4 = XMLUtils.getXPathValue((File)file, (String)string2);
            string4 = this.transformName(string4, string3);
            return string4;
        }
        catch (Exception exception) {
            logger.error("Cannot parse " + file, (Throwable)exception);
            return null;
        }
    }

    @Override
    public String getExampleValue(String string, String string2) {
        return this.getExampleValueFromFile(this.getExampleOutputLocation(), string, string2);
    }

    protected String getOperationName() {
        return this.plugin;
    }

    @Override
    public String getDefaultSubstitution() {
        return this.getDefaultInputXML();
    }

    @Override
    public boolean isUpstreamVariable(String string) {
        try {
            Properties properties = PropUtils.loadProperties((InputStream)this.getOutputFile().getContents());
            if (properties.containsKey(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            logger.error("Cannot read properties file!", (Throwable)exception);
        }
        return super.isUpstreamVariable(string);
    }

    public List<IVariable> getOutputVariables() {
        List<IVariable> list = this.getXPathVariables();
        List<IVariable> list2 = this.isPassInputs ? this.getInputVariables() : new ArrayList<IVariable>(list.size());
        list2.addAll(list);
        return list2;
    }

    @Override
    public List<IVariable> getXPathVariables() {
        try {
            IFile iFile = this.getOutputFile();
            Properties properties = PropUtils.loadProperties((InputStream)iFile.getContents());
            ArrayList<IVariable> arrayList = new ArrayList<IVariable>(properties.size());
            for (Object object : properties.keySet()) {
                String string = (String)object;
                String string2 = properties.getProperty(string);
                if (string2 == null || "".equals(string2)) continue;
                XPathVariable xPathVariable = new XPathVariable(string, string2);
                this.transformExampleValue((IVariable)xPathVariable);
                arrayList.add((IVariable)xPathVariable);
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.error("Cannot read output properties " + this.getOutputFile(), (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IVariable> getUpstreamVariables() {
        if (this.isPassInputs) {
            return this.getInputVariables();
        }
        return Collections.emptyList();
    }
}

