/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data.config;

import org.dawb.common.ui.slicing.DimsDataList;
import org.dawb.common.ui.slicing.SliceComponent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class SliceParameterDialog
extends Dialog {
    private static Logger logger = LoggerFactory.getLogger(SliceParameterDialog.class);
    private DimsDataList dimsDataList;
    private SliceComponent sliceComponent;

    protected SliceParameterDialog(Shell shell, NamedObj namedObj) {
        super(shell);
        this.setShellStyle(2160);
    }

    public Control createDialogArea(Composite composite) {
        this.sliceComponent = new SliceComponent("org.dawb.workbench.views.h5GalleryView");
        Control control = this.sliceComponent.createPartControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sliceComponent.setVisible(true);
        return composite;
    }

    public void setData(String string, String string2) {
        int[] nArray = this.getDataShape(string, string2);
        this.sliceComponent.setData(string, string2, nArray, null);
    }

    private int[] getDataShape(String string, String string2) {
        try {
            IMetaData iMetaData = LoaderFactory.getMetaData((String)string2, null);
            return (int[])iMetaData.getDataShapes().get(string);
        }
        catch (Exception exception) {
            logger.error("Cannot read data shape " + string, (Throwable)exception);
            return null;
        }
    }

    public DimsDataList getDimsDataList() {
        return this.dimsDataList;
    }

    public void setDimsDataList(DimsDataList dimsDataList) {
        if (dimsDataList == null) {
            return;
        }
        if (dimsDataList.size() < 1) {
            return;
        }
        try {
            this.sliceComponent.setDimsDataList(dimsDataList);
        }
        catch (Exception exception) {
            logger.error("Cannot set persisted string in slice component!", (Throwable)exception);
        }
    }

    protected void okPressed() {
        try {
            this.dimsDataList = this.sliceComponent.getDimsDataList();
        }
        catch (Exception exception) {
            logger.error("Cannot get persisted string in slice component!", (Throwable)exception);
        }
        super.okPressed();
    }
}

