/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data.config;

import com.isencia.passerelle.workbench.model.editor.ui.properties.CellEditorAttribute;
import java.io.File;
import org.dawb.common.ui.slicing.DimsDataList;
import org.dawb.passerelle.actors.data.DataImportSource;
import org.dawb.passerelle.actors.data.config.SliceParameterDialog;
import org.dawb.passerelle.common.parameter.CellEditorParameter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class SliceParameter
extends CellEditorParameter
implements CellEditorAttribute {
    private static final long serialVersionUID = 4735320242872076263L;
    private static final Logger logger = LoggerFactory.getLogger(SliceParameter.class);

    public SliceParameter(NamedObj namedObj, String string) throws IllegalActionException, NameDuplicationException {
        super(namedObj, string);
    }

    public CellEditor createCellEditor(Control control) {
        DataImportSource dataImportSource = (DataImportSource)this.getContainer();
        final String[] stringArray = dataImportSource.getDataSetNames();
        if (stringArray == null || stringArray.length != 1) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No data set chosen", (String)"Please choose one data set to slice for the pipeline.\n\nTo do this open the 'Data Sets' parameter and choose the\nimage stack (for instance) you would like to use then\nopen the 'Data Set Slice' and choose how to slice this\nstack, each slice will enter the pipeline separately.");
            return null;
        }
        final String string = dataImportSource.getSourcePath();
        if (string == null || !new File(string).exists()) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No file chosen", (String)"Please choose an existing file to slice for the pipeline.\n\nTo do this open the 'Path' parameter and choose an existing\nfile. Then the slicing can read the file to get the dimensionality.");
            return null;
        }
        DialogCellEditor dialogCellEditor = new DialogCellEditor((Composite)control){

            protected Object openDialogBox(Control control) {
                SliceParameterDialog sliceParameterDialog = new SliceParameterDialog(control.getShell(), SliceParameter.this.getContainer());
                sliceParameterDialog.create();
                sliceParameterDialog.getShell().setSize(400, 450);
                sliceParameterDialog.getShell().setText("Create Slices for Import");
                sliceParameterDialog.setData(stringArray[0], string);
                sliceParameterDialog.setDimsDataList((DimsDataList)SliceParameter.this.getBeanFromValue(DimsDataList.class));
                int n = sliceParameterDialog.open();
                if (n == 0) {
                    return SliceParameter.this.getValueFromBean(sliceParameterDialog.getDimsDataList());
                }
                return null;
            }

            protected void updateContents(Object object) {
                if (this.getDefaultLabel() == null) {
                    return;
                }
                this.getDefaultLabel().setText(SliceParameter.this.getRendererText());
            }
        };
        return dialogCellEditor;
    }

    public String getRendererText() {
        DataImportSource dataImportSource;
        int[] nArray = null;
        try {
            dataImportSource = (DataImportSource)this.getContainer();
            IMetaData iMetaData = LoaderFactory.getMetaData((String)dataImportSource.getSourcePath(), null);
            nArray = (int[])iMetaData.getDataShapes().get(dataImportSource.getDataSetNames()[0]);
        }
        catch (Exception exception) {
            nArray = null;
        }
        if (this.getExpression() == null || "".equals(this.getExpression())) {
            return "";
        }
        dataImportSource = (DimsDataList)this.getBeanFromValue(DimsDataList.class);
        return dataImportSource.toString(nArray);
    }
}

