/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.util.list.ListUtils;
import org.dawb.common.util.list.PrimitiveArrayEncoder;
import org.dawb.common.util.text.NumberUtils;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class TileDatasets
extends AbstractDataMessageTransformer {
    private static final long serialVersionUID = -6239616184296978488L;
    private StringParameter repetitions = new StringParameter((NamedObj)this, "Tile repetitions");
    private StringParameter dataNames;

    public TileDatasets(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.repetitions);
        this.dataNames = new StringParameter((NamedObj)this, "Data Names");
        this.registerConfigurableParameter((Parameter)this.dataNames);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        if (this.repetitions.getExpression() == null || "".equals(this.repetitions.getExpression())) {
            throw this.createDataMessageException("You must set the " + this.repetitions.getDisplayName() + " attribute!", null);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(31);
        int[] nArray = PrimitiveArrayEncoder.getIntArrayNoBrackets((String)this.repetitions.getExpression());
        if (this.dataNames.getExpression() == null || "".equals(this.dataNames.getExpression())) {
            for (DataMessageComponent map2 : list) {
                Map map = map2.getList();
                if (map == null) continue;
                for (String string : map.keySet()) {
                    Object v = map.get(string);
                    if (!(v instanceof IDataset)) continue;
                    IDataset iDataset = (IDataset)v;
                    AbstractDataset abstractDataset = DatasetUtils.tile((IDataset)iDataset, (int[])nArray);
                    hashMap.put(string, abstractDataset);
                }
            }
        } else {
            Map exception = MessageUtils.getScalar(list);
            Map map4 = MessageUtils.getList(list);
            List list2 = ListUtils.getList((String)this.dataNames.getExpression());
            for (String string : list2) {
                Object object;
                Object object2;
                IDataset iDataset = object2 = map4 != null ? (IDataset)map4.get(string) : null;
                if (object2 == null && exception != null && exception.containsKey(string)) {
                    object = (Number)NumberUtils.getNumberIfParses((String)((String)exception.get(string)));
                    object2 = object instanceof Integer ? new IntegerDataset(nArray) : new DoubleDataset(nArray);
                    ((AbstractDataset)object2).fill(object);
                    hashMap.put(string, object2);
                    continue;
                }
                if (object2 == null) {
                    this.createDataMessageException("Cannot tile variable '" + string + "'!", null);
                }
                object = DatasetUtils.tile((IDataset)object2, (int[])nArray);
                hashMap.put(string, object);
            }
        }
        try {
            DataMessageComponent dataMessageComponent = new DataMessageComponent();
            dataMessageComponent.setMeta(MessageUtils.getMeta(list));
            dataMessageComponent.addScalar(MessageUtils.getScalar(list));
            dataMessageComponent.setList(hashMap);
            dataMessageComponent.putScalar("operation_names", MessageUtils.getNames(hashMap.values()));
            return dataMessageComponent;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Tiling data sets", exception);
        }
    }

    protected String getExtendedInfo() {
        return "Tile data sets";
    }

    protected String getOperationName() {
        return "tile";
    }
}

