/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dawb.gda.extensions.spec.MultiScanDataEvent;
import org.dawb.gda.extensions.spec.MultiScanDataListener;
import org.dawb.gda.extensions.spec.MultiScanDataParser;
import org.dawb.passerelle.common.DatasetConstants;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class SpecImportSource
extends AbstractDataMessageSource
implements IResourceActor,
IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(SpecImportSource.class);
    protected Parameter folderParam;
    protected Parameter relativePathParam = new Parameter((NamedObj)this, "Relative Path", (Token)new BooleanToken(true));
    protected boolean isPathRelative = true;
    private final ResourceParameter path;
    private MultiScanDataParser scanParser;
    private List<MultiScanDataEvent> scanQueue;
    private static final long serialVersionUID = -851384753061854424L;
    private ManagedMessage lastTriggered;
    private boolean triggeredOnce = false;

    public SpecImportSource(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        this(compositeEntity, string, false);
    }

    protected SpecImportSource(CompositeEntity compositeEntity, String string, boolean bl) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, ModelUtils.findUniqueActorName((CompositeEntity)compositeEntity, (String)string));
        this.registerConfigurableParameter(this.relativePathParam);
        this.folderParam = new Parameter((NamedObj)this, "Folder", (Token)new BooleanToken(bl));
        this.folderParam.setVisibility(Settable.NONE);
        this.path = new ResourceParameter((NamedObj)this, "Path", "Data files", LoaderFactory.getSupportedExtensions().toArray(new String[0]));
        try {
            URI uRI = new File(StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder())).toURI();
            this.path.setBaseDirectory(uRI);
        }
        catch (Exception exception) {
            logger.error("Cannot set base directory for " + ((Object)((Object)this)).getClass().getName(), (Throwable)exception);
        }
        this.registerConfigurableParameter((Parameter)this.path);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute != this.path && attribute == this.relativePathParam) {
            this.isPathRelative = ((BooleanToken)this.relativePathParam.getToken()).booleanValue();
        }
        super.attributeChanged(attribute);
    }

    public void doPreInitialize() {
        this.scanQueue = null;
    }

    protected void doInitialize() throws InitializationException {
        super.doInitialize();
        this.scanQueue = new ArrayList<MultiScanDataEvent>(89);
        if (!this.isTriggerConnected()) {
            this.startScanParsing(null);
        }
    }

    private void startScanParsing(final ManagedMessage managedMessage) {
        this.lastTriggered = managedMessage;
        if (this.getManager() != null) {
            try {
                this.scanParser = new MultiScanDataParser((InputStream)new FileInputStream(this.getSourceFile()), new MultiScanDataListener(){

                    public boolean specDataPerformed(MultiScanDataEvent multiScanDataEvent) {
                        if (SpecImportSource.this.isFinishRequested()) {
                            return false;
                        }
                        multiScanDataEvent.setUserObject((Object)managedMessage);
                        SpecImportSource.this.scanQueue.add(multiScanDataEvent);
                        return true;
                    }
                });
                this.scanParser.start();
            }
            catch (Exception exception) {
                logger.error("Cannot start scan parser!", (Throwable)exception);
            }
        }
    }

    public boolean hasNoMoreMessages() {
        if (this.scanQueue == null) {
            return true;
        }
        return this.scanQueue.isEmpty() && super.hasNoMoreMessages();
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        if (this.scanQueue != null && this.scanQueue.isEmpty() && this.scanParser != null) {
            while (!this.scanParser.isParseComplete() && this.scanQueue.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Cannot wait for scan queue to be populated.", (Throwable)interruptedException);
                }
            }
        }
        if (this.scanQueue == null) {
            return null;
        }
        if (this.scanQueue.isEmpty()) {
            return null;
        }
        if (this.isFinishRequested()) {
            this.scanQueue.clear();
            return null;
        }
        ManagedMessage managedMessage = MessageFactory.getInstance().createMessage();
        MultiScanDataEvent multiScanDataEvent = this.scanQueue.remove(0);
        try {
            managedMessage.setBodyContent((Object)this.getData(multiScanDataEvent), DatasetConstants.CONTENT_TYPE_DATA);
        }
        catch (MessageException messageException) {
            logger.error("Cannot set map of data in message body!", (Throwable)messageException);
            managedMessage = MessageFactory.getInstance().createErrorMessage(new PasserelleException("Cannot set map of data in message body!", (Object)"application/x-data", (Throwable)messageException));
            this.scanQueue.clear();
        }
        catch (Exception exception) {
            this.scanQueue.clear();
            throw new DataMessageException("Cannot read data from '" + this.getSourceFile() + "'", (Object)this, (Throwable)exception);
        }
        try {
            managedMessage.setBodyHeader("TITLE", multiScanDataEvent.getScanName());
        }
        catch (MessageException messageException) {
            managedMessage = MessageFactory.getInstance().createErrorMessage(new PasserelleException("Cannot set header in message!", (Object)"application/x-data", (Throwable)messageException));
        }
        return managedMessage;
    }

    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.isFinishRequested()) {
            this.scanQueue.clear();
        }
    }

    protected DataMessageComponent getData(MultiScanDataEvent multiScanDataEvent) throws Exception {
        Collection collection;
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        ManagedMessage managedMessage = (ManagedMessage)multiScanDataEvent.getUserObject();
        if (managedMessage != null) {
            try {
                collection = MessageUtils.coerceMessage((ManagedMessage)managedMessage);
                dataMessageComponent.addScalar(collection.getScalar());
            }
            catch (Exception exception) {
                logger.info("Trigger for " + this.getName() + " is not DataMessageComponent, no data added.");
            }
        }
        if ((collection = multiScanDataEvent.getData()) != null) {
            for (AbstractDataset abstractDataset : collection) {
                dataMessageComponent.addList(abstractDataset.getName(), abstractDataset);
            }
        }
        dataMessageComponent.putScalar("file_path", this.getSourceFile().getAbsolutePath());
        dataMessageComponent.putScalar("file_name", this.getSourceFile().getName());
        dataMessageComponent.putScalar("file_dir", this.getSourceFile().getParent());
        return dataMessageComponent;
    }

    protected String getExtendedInfo() {
        return "A source which reads a spec file and sends each scan as a message.";
    }

    public File getSourceFile() {
        IResource iResource;
        String string = this.getReplacedPath();
        if (this.isPathRelative && (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string, true)) != null) {
            string = iResource.getLocation().toOSString();
        }
        this.getStandardMessageHeaders().put("__PSRL_SRC_INFO", string);
        return new File(string);
    }

    private Object getResource() {
        if (this.isPathRelative) {
            String string = this.getReplacedPath();
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string, true);
            if (iResource != null) {
                return iResource;
            }
        }
        return this.getSourceFile();
    }

    private String getReplacedPath() {
        String string = null;
        if (this.lastTriggered != null) {
            try {
                DataMessageComponent dataMessageComponent = MessageUtils.coerceMessage((ManagedMessage)this.lastTriggered);
                string = ParameterUtils.getSubstituedValue((Parameter)this.path, (DataMessageComponent)dataMessageComponent);
            }
            catch (Exception exception) {
                logger.error("Cannot substitute parameter " + this.path, (Throwable)exception);
            }
        } else {
            string = this.path.getExpression();
        }
        return string;
    }

    private String getResourceTypeName() {
        File file = this.getSourceFile();
        return file != null ? "'" + file.getName() + "'" : "";
    }

    public int getResourceCount() {
        return 1;
    }

    public ResourceObject getResource(int n) {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource(this.getResource());
            resourceObject.setResourceTypeName(this.getResourceTypeName());
            return resourceObject;
        }
        return null;
    }

    public void setMomlResource(IResource iResource) {
    }

    public List<IVariable> getOutputVariables() {
        List list = super.getOutputVariables();
        list.add(new Variable("file_path", IVariable.VARIABLE_TYPE.PATH, (Object)this.getSourceFile().getAbsolutePath(), String.class));
        list.add(new Variable("file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)this.getSourceFile().getName(), String.class));
        list.add(new Variable("file_dir", IVariable.VARIABLE_TYPE.PATH, (Object)this.getSourceFile().getParent(), String.class));
        return list;
    }

    protected boolean mustWaitForTrigger() {
        if (!this.isTriggerConnected()) {
            return false;
        }
        if (!this.triggeredOnce) {
            return true;
        }
        return this.scanQueue.isEmpty();
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggeredOnce = true;
        this.startScanParsing(managedMessage);
    }
}

