/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.workbench.model.editor.ui.properties.CellEditorAttribute;
import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.components.cell.FieldComponentCellEditor;
import uk.ac.gda.richbeans.components.scalebox.RangeBox;

public class Scalar
extends AbstractDataMessageSource {
    private static Logger logger = LoggerFactory.getLogger(Scalar.class);
    private static final long serialVersionUID = 6530803848861756427L;
    public Parameter valueParam;
    public Parameter nameParam = new StringParameter((NamedObj)this, "Name");
    private String strName;
    private String strValue;
    private List<? extends Number> rangeQueue;
    protected boolean firedStringValueAlready;

    public Scalar(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.nameParam.setExpression("x");
        this.nameParam.setDisplayName("Scalar Name");
        this.registerConfigurableParameter(this.nameParam);
        this.valueParam = new RangeParameter((NamedObj)this, "Value");
        this.valueParam.setExpression("1");
        this.valueParam.setDisplayName("Scalar Value");
        this.registerConfigurableParameter(this.valueParam);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.nameParam) {
            this.strName = this.nameParam.getExpression();
        } else if (attribute == this.valueParam) {
            this.strValue = this.valueParam.getExpression();
        }
        super.attributeChanged(attribute);
    }

    protected void doInitialize() throws InitializationException {
        super.doInitialize();
        this.firedStringValueAlready = false;
        try {
            this.rangeQueue = DOEUtils.expand((String)this.strValue);
        }
        catch (Throwable throwable) {
            this.rangeQueue = null;
        }
    }

    public boolean hasNoMoreMessages() {
        if (this.rangeQueue == null) {
            return true;
        }
        return this.rangeQueue.isEmpty() && super.hasNoMoreMessages();
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        Object object;
        if (this.rangeQueue == null && this.firedStringValueAlready) {
            return null;
        }
        if (this.rangeQueue != null && this.rangeQueue.isEmpty()) {
            return null;
        }
        if (this.rangeQueue == null) {
            this.firedStringValueAlready = true;
            object = this.strValue;
        } else {
            object = this.rangeQueue.remove(0);
        }
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        dataMessageComponent.putScalar(this.strName, object.toString());
        try {
            return MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent);
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot set scalar " + this.strName, exception);
        }
    }

    protected String getExtendedInfo() {
        return this.valueParam.getExpression();
    }

    public List<IVariable> getOutputVariables() {
        try {
            String string = ((StringToken)this.nameParam.getToken()).stringValue();
            String string2 = ((StringToken)this.valueParam.getToken()).stringValue();
            ArrayList<IVariable> arrayList = new ArrayList<IVariable>(1);
            arrayList.add((IVariable)new Variable(string, IVariable.VARIABLE_TYPE.SCALAR, (Object)string2, String.class));
            return arrayList;
        }
        catch (Exception exception) {
            logger.error("Cannot create outputs for " + this.getName(), (Throwable)exception);
            return null;
        }
    }

    public List<IVariable> getInputVariables() {
        return null;
    }

    protected boolean mustWaitForTrigger() {
        return false;
    }

    private static class RangeParameter
    extends StringParameter
    implements CellEditorAttribute {
        public RangeParameter(NamedObj namedObj, String string) throws IllegalActionException, NameDuplicationException {
            super(namedObj, string);
        }

        public CellEditor createCellEditor(Control control) {
            try {
                return new FieldComponentCellEditor((Composite)control, RangeBox.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("Cannot create editor for field " + (Object)((Object)this), (Throwable)classNotFoundException);
                return null;
            }
        }

        public String getRendererText() {
            return null;
        }
    }
}

