/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.passerelle.util.ptolemy.RegularExpressionParameter;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dawb.common.util.io.FileUtils;
import org.dawb.common.util.io.SortingUtils;
import org.dawb.passerelle.actors.data.TriggerObject;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gmf.runtime.common.core.util.StringMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public class FolderMonitorSource
extends AbstractDataMessageSource {
    private static final long serialVersionUID = 7377188139156058630L;
    private static final Logger logger = LoggerFactory.getLogger(FolderMonitorSource.class);
    private final ResourceParameter folderPath = new ResourceParameter((NamedObj)this, "Folder", "Folder to Monitor", new String[0]);
    protected Parameter relativePathParam;
    private Parameter sourceFreq;
    private Parameter inactiveFreq;
    private RegularExpressionParameter filterParam;
    private List<TriggerObject> fileQueue;
    private ManagedMessage triggerMsg;
    private long initTime;
    private Set<FileObject> reportedFiles;

    public FolderMonitorSource(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        this.folderPath.setResourceType(2);
        try {
            URI uRI = new File(StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder())).toURI();
            this.folderPath.setBaseDirectory(uRI);
        }
        catch (Exception exception) {
            logger.error("Cannot set base directory for " + ((Object)((Object)this)).getClass().getName(), (Throwable)exception);
        }
        this.registerConfigurableParameter((Parameter)this.folderPath);
        this.sourceFreq = new Parameter((NamedObj)this, "Checking Frequency", (Token)new IntToken(100));
        this.registerConfigurableParameter(this.sourceFreq);
        this.inactiveFreq = new Parameter((NamedObj)this, "Inactive After", (Token)new IntToken(-1));
        this.registerExpertParameter(this.inactiveFreq);
        this.relativePathParam = new Parameter((NamedObj)this, "Relative Path", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.relativePathParam);
        this.filterParam = new RegularExpressionParameter((NamedObj)this, "File Filter", true);
        this.registerConfigurableParameter((Parameter)this.filterParam);
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggerMsg = managedMessage;
        this.appendQueue(managedMessage);
    }

    public void doPreInitialize() {
        this.fileQueue = null;
        this.initTime = -1L;
        this.reportedFiles = null;
    }

    protected void doInitialize() throws InitializationException {
        super.doInitialize();
        this.initTime = System.currentTimeMillis();
        this.fileQueue = new ArrayList<TriggerObject>(89);
        this.reportedFiles = new HashSet<FileObject>(89);
        if (!this.isTriggerConnected()) {
            this.appendQueue(null);
        }
    }

    private void appendQueue(ManagedMessage managedMessage) {
        if (this.getManager() != null) {
            File file = new File(this.getSourcePath(managedMessage));
            if (file.isDirectory()) {
                File[] fileArray = this.getNewerFileList(file);
                if (fileArray == null || fileArray.length < 1) {
                    return;
                }
                List list = SortingUtils.getSortedFileList((File[])fileArray, (Comparator)SortingUtils.DEFAULT_COMPARATOR);
                for (File file2 : list) {
                    if (!this.isFileLegal(file2)) continue;
                    TriggerObject triggerObject = new TriggerObject();
                    triggerObject.setTrigger(managedMessage);
                    triggerObject.setFile(file2);
                    this.fileQueue.add(triggerObject);
                }
            } else {
                throw new RuntimeException("Must have a directory not " + file);
            }
        }
    }

    private File[] getNewerFileList(File file) {
        return file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (FolderMonitorSource.this.reportedFiles.contains(new FileObject(file))) {
                    return false;
                }
                long l = file.lastModified();
                return l > FolderMonitorSource.this.initTime;
            }
        });
    }

    private boolean isFileLegal(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isHidden()) {
            return false;
        }
        if (file.getName().startsWith(".")) {
            return false;
        }
        return this.isRequiredFileName(file.getName());
    }

    private boolean isRequiredFileName(String string) {
        String string2 = this.filterParam.getExpression();
        if (string2 == null || "".equals(string2)) {
            return true;
        }
        if (this.filterParam.isJustWildCard()) {
            StringMatcher stringMatcher = new StringMatcher(string2, false, false);
            return stringMatcher.match(string);
        }
        return string.matches(string2);
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        block10: {
            block9: {
                block8: {
                    try {
                        if (this.fileQueue != null) break block8;
                        return null;
                    }
                    catch (Exception exception) {
                        throw this.createDataMessageException("Cannot extract shared memory", exception);
                    }
                }
                if (!this.fileQueue.isEmpty()) break block9;
                return null;
            }
            if (!this.isFinishRequested()) break block10;
            this.fileQueue.clear();
            return null;
        }
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        TriggerObject triggerObject = this.fileQueue.remove(0);
        this.reportedFiles.add(new FileObject(triggerObject.getFile()));
        dataMessageComponent.putScalar("file_path", triggerObject.getFile().getAbsolutePath());
        dataMessageComponent.putScalar("file_name", triggerObject.getFile().getName());
        dataMessageComponent.putScalar("file_dir", triggerObject.getFile().getParent());
        if (this.triggerMsg != null) {
            try {
                DataMessageComponent dataMessageComponent2 = MessageUtils.coerceMessage((ManagedMessage)this.triggerMsg);
                dataMessageComponent.addScalar(dataMessageComponent2.getScalar());
            }
            catch (Exception exception) {
                logger.info("Trigger for " + this.getName() + " is not DataMessageComponent, no data added.");
            }
        }
        return MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent);
    }

    public boolean hasNoMoreMessages() {
        if (this.fileQueue == null) {
            return true;
        }
        return this.fileQueue.isEmpty() && super.hasNoMoreMessages();
    }

    protected boolean doPostFire() throws ProcessingException {
        try {
            if (this.isFinishRequested()) {
                return super.doPostFire();
            }
            int n = ((IntToken)this.inactiveFreq.getToken()).intValue();
            int n2 = ((IntToken)this.sourceFreq.getToken()).intValue();
            if (n < 0 && System.getProperty("org.dawb.test.session") != null) {
                n = 1000;
            }
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            for (int i = 0; i < n && !this.isFinishRequested() && this.fileQueue != null && this.fileQueue.isEmpty(); i += n2) {
                try {
                    Thread.sleep(n2);
                    this.appendQueue(this.triggerMsg);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("Cannot wait for source frequency time after last data!", (Object)this, (Throwable)exception);
        }
        return super.doPostFire();
    }

    protected String getExtendedInfo() {
        return "Actor to monitor a directory for new files.";
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            String string = this.getSourcePath(null);
            list.add(new Variable("file_path", IVariable.VARIABLE_TYPE.PATH, (Object)string, String.class));
            list.add(new Variable("file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)(string != null ? String.valueOf(new File(string).getName()) + "/*" : "Monitored file..."), String.class));
            list.add(new Variable("file_dir", IVariable.VARIABLE_TYPE.PATH, (Object)(string != null ? FileUtils.getDirectory((String)this.getSourcePath(null)) : "Monitored directory"), String.class));
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }

    private String getSourcePath(ManagedMessage managedMessage) {
        String string = null;
        try {
            DataMessageComponent dataMessageComponent = managedMessage != null ? MessageUtils.coerceMessage((ManagedMessage)managedMessage) : null;
            string = ParameterUtils.getSubstituedValue((Parameter)this.folderPath, (DataMessageComponent)dataMessageComponent);
        }
        catch (Exception exception) {
            logger.error("Cannot substitute parameter " + this.folderPath, (Throwable)exception);
        }
        boolean bl = false;
        try {
            bl = ((BooleanToken)this.relativePathParam.getToken()).booleanValue();
        }
        catch (IllegalActionException illegalActionException) {
            logger.error("Cannot deal with if path is relative! Assuming it is not and carrying on.");
        }
        if (bl) {
            IResource iResource;
            block8: {
                try {
                    iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string, true);
                    if (iResource != null) break block8;
                    return null;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
            string = iResource.getLocation().toOSString();
        }
        this.getStandardMessageHeaders().put("__PSRL_SRC_INFO", string);
        return string;
    }

    protected boolean mustWaitForTrigger() {
        if (this.triggerMsg != null) {
            return false;
        }
        return this.trigger.getWidth() > 0;
    }

    private final class FileObject {
        private File file;
        private long lastMod;

        public FileObject(File file) {
            this.file = file;
            this.lastMod = file.lastModified();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + ((Object)((Object)this.getOuterType())).hashCode();
            n = 31 * n + (this.file == null ? 0 : this.file.hashCode());
            n = 31 * n + (int)(this.lastMod ^ this.lastMod >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FileObject fileObject = (FileObject)object;
            if (!((Object)((Object)this.getOuterType())).equals((Object)fileObject.getOuterType())) {
                return false;
            }
            if (this.file == null ? fileObject.file != null : !this.file.equals(fileObject.file)) {
                return false;
            }
            return this.lastMod == fileObject.lastMod;
        }

        private FolderMonitorSource getOuterType() {
            return FolderMonitorSource.this;
        }
    }
}

