/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.passerelle.util.ptolemy.IAvailableChoices;
import com.isencia.passerelle.util.ptolemy.IAvailableMap;
import com.isencia.passerelle.util.ptolemy.RegularExpressionParameter;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import com.isencia.passerelle.util.ptolemy.StringMapParameter;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.python.PythonUtils;
import org.dawb.common.ui.slicing.DimsDataList;
import org.dawb.common.ui.slicing.SliceUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.common.util.io.SortingUtils;
import org.dawb.gda.extensions.loaders.H5LazyDataset;
import org.dawb.gda.extensions.loaders.H5Loader;
import org.dawb.gda.extensions.util.DatasetTitleUtils;
import org.dawb.passerelle.actors.data.TriggerObject;
import org.dawb.passerelle.actors.data.config.SliceParameter;
import org.dawb.passerelle.common.DatasetConstants;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.AbstractDatasetProvider;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gmf.runtime.common.core.util.StringMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.util.map.MapUtils;

public class DataImportSource
extends AbstractDataMessageSource
implements IResourceActor,
IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataImportSource.class);
    private static final String[] DATA_TYPES;
    private static final String[] SLICE_TYPES;
    protected Parameter folderParam;
    protected Parameter relativePathParam = new Parameter((NamedObj)this, "Relative Path", (Token)new BooleanToken(true));
    protected boolean isPathRelative = true;
    protected Parameter metaParam;
    protected boolean isMetaRequired = false;
    private final RegularExpressionParameter filterParam;
    private String fileFilter;
    private final ResourceParameter path;
    private final StringChoiceParameter names;
    private final StringMapParameter rename;
    private final StringParameter dataType;
    private final StringParameter sliceNameType;
    private final SliceParameter slicing;
    private List<TriggerObject> fileQueue;
    private static final long serialVersionUID = -851384753061854424L;
    private Collection<String> cachedDatasets = null;
    private Map<String, int[]> cachedShapes = null;
    private boolean triggeredOnce = false;

    static {
        try {
            H5Loader.setLoaderInFactory();
        }
        catch (Exception exception) {
            logger.error("Cannot replace H5Loader", (Throwable)exception);
        }
        DATA_TYPES = new String[]{"Complete data as numerical arrays", "Just path and file name"};
        SLICE_TYPES = new String[]{"Unique name for each slice", "Same name for each slice"};
    }

    public DataImportSource(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        this(compositeEntity, string, false);
    }

    protected DataImportSource(CompositeEntity compositeEntity, String string, boolean bl) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, ModelUtils.findUniqueActorName((CompositeEntity)compositeEntity, (String)string));
        this.registerConfigurableParameter(this.relativePathParam);
        this.folderParam = new Parameter((NamedObj)this, "Folder", (Token)new BooleanToken(bl));
        this.folderParam.setVisibility(Settable.NONE);
        this.metaParam = new Parameter((NamedObj)this, "Include Meta Data", (Token)new BooleanToken(false));
        this.registerConfigurableParameter(this.metaParam);
        this.filterParam = new RegularExpressionParameter((NamedObj)this, "File Filter", true);
        this.registerConfigurableParameter((Parameter)this.filterParam);
        this.path = new ResourceParameter((NamedObj)this, "Path", "Data files", LoaderFactory.getSupportedExtensions().toArray(new String[0]));
        try {
            URI uRI = new File(StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder())).toURI();
            this.path.setBaseDirectory(uRI);
        }
        catch (Exception exception) {
            logger.error("Cannot set base directory for " + ((Object)((Object)this)).getClass().getName(), (Throwable)exception);
        }
        this.registerConfigurableParameter((Parameter)this.path);
        this.names = new StringChoiceParameter((NamedObj)this, "Data Sets", new IAvailableChoices(){

            public String[] getChoices() {
                return DataImportSource.this.getAllDatasetsInFile();
            }

            public Map<String, String> getVisibleChoices() {
                DataImportSource.this.getAllDatasetsInFile();
                return DatasetTitleUtils.getChoppedNames((Collection)DataImportSource.this.cachedDatasets);
            }
        }, 2);
        this.registerConfigurableParameter((Parameter)this.names);
        this.rename = new StringMapParameter((NamedObj)this, "Rename Data Sets", new IAvailableMap(){

            public Map<String, String> getMap() {
                return DataImportSource.this.getDataSetsRenameName();
            }

            public Map<String, String> getVisibleKeyChoices() {
                DataImportSource.this.getAllDatasetsInFile();
                return DatasetTitleUtils.getChoppedNames((Collection)DataImportSource.this.cachedDatasets);
            }

            public Collection<String> getSelectedChoices() {
                String[] stringArray = DataImportSource.this.names.getValue();
                return stringArray != null ? Arrays.asList(stringArray) : null;
            }
        });
        this.registerConfigurableParameter((Parameter)this.rename);
        this.slicing = new SliceParameter((NamedObj)this, "Data Set Slice");
        this.registerConfigurableParameter((Parameter)this.slicing);
        this.dataType = new StringParameter((NamedObj)this, "Data Type"){

            public String[] getChoices() {
                return DATA_TYPES;
            }
        };
        this.dataType.setExpression(DATA_TYPES[0]);
        this.registerConfigurableParameter((Parameter)this.dataType);
        this.sliceNameType = new StringParameter((NamedObj)this, "Slice Name Type"){

            public String[] getChoices() {
                return SLICE_TYPES;
            }
        };
        this.sliceNameType.setExpression(SLICE_TYPES[0]);
        this.registerConfigurableParameter((Parameter)this.sliceNameType);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.path) {
            this.cachedDatasets = null;
            this.cachedShapes = null;
        } else if (attribute == this.relativePathParam) {
            this.isPathRelative = ((BooleanToken)this.relativePathParam.getToken()).booleanValue();
        } else if (attribute == this.metaParam) {
            this.isMetaRequired = ((BooleanToken)this.metaParam.getToken()).booleanValue();
        } else if (attribute != this.folderParam) {
            if (attribute == this.filterParam) {
                this.fileFilter = this.filterParam.getExpression();
            } else if (attribute == this.names) {
                logger.trace("Data set names changed to : " + this.names.getExpression());
            }
        }
        super.attributeChanged(attribute);
    }

    public void doPreInitialize() {
        this.fileQueue = null;
        this.cachedDatasets = null;
        this.cachedShapes = null;
    }

    protected void doInitialize() throws InitializationException {
        super.doInitialize();
        this.fileQueue = new ArrayList<TriggerObject>(89);
        if (!this.isTriggerConnected()) {
            this.appendQueue(null);
        }
    }

    private void appendQueue(ManagedMessage managedMessage) {
        if (this.getManager() != null) {
            File file = new File(this.getSourcePath(managedMessage));
            if (file.isDirectory()) {
                List list = SortingUtils.getSortedFileList((File)file);
                for (File file2 : list) {
                    if (!this.isFileLegal(file2)) continue;
                    TriggerObject triggerObject = new TriggerObject();
                    triggerObject.setTrigger(managedMessage);
                    triggerObject.setFile(file2);
                    this.fileQueue.add(triggerObject);
                }
            } else if (this.isFileLegal(file)) {
                if (this.isH5Slicing(managedMessage)) {
                    try {
                        IMetaData iMetaData = LoaderFactory.getMetaData((String)file.getAbsolutePath(), null);
                        int[] nArray = (int[])iMetaData.getDataShapes().get(this.getDataSetNames()[0]);
                        List list = SliceUtils.getExpandedSlices((int[])nArray, (Object)this.slicing.getBeanFromValue(DimsDataList.class));
                        int n = 0;
                        for (SliceObject sliceObject : list) {
                            TriggerObject triggerObject = new TriggerObject();
                            triggerObject.setTrigger(managedMessage);
                            triggerObject.setFile(file);
                            triggerObject.setSlice(sliceObject);
                            triggerObject.setIndex(n);
                            this.fileQueue.add(triggerObject);
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Problem reading slices in data import.", (Throwable)exception);
                        this.requestFinish();
                    }
                } else {
                    TriggerObject triggerObject = new TriggerObject();
                    triggerObject.setTrigger(managedMessage);
                    triggerObject.setFile(file);
                    this.fileQueue.add(triggerObject);
                }
            }
        }
    }

    private boolean isH5Slicing(ManagedMessage managedMessage) {
        boolean bl;
        String string = FileUtils.getFileExtension((String)this.getSourcePath(managedMessage));
        boolean bl2 = bl = LoaderFactory.getLoaderClass((String)string) == H5Loader.class;
        return bl && this.slicing.getExpression() != null && this.getDataSetNames() != null && this.getDataSetNames().length == 1;
    }

    private boolean isFileLegal(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isHidden()) {
            return false;
        }
        if (file.getName().startsWith(".")) {
            return false;
        }
        return this.isRequiredFileName(file.getName());
    }

    public boolean hasNoMoreMessages() {
        if (this.fileQueue == null) {
            return true;
        }
        return this.fileQueue.isEmpty() && super.hasNoMoreMessages();
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        if (this.fileQueue == null) {
            return null;
        }
        if (this.fileQueue.isEmpty()) {
            return null;
        }
        if (this.isFinishRequested()) {
            this.fileQueue.clear();
            return null;
        }
        ManagedMessage managedMessage = MessageFactory.getInstance().createMessage();
        TriggerObject triggerObject = this.fileQueue.remove(0);
        try {
            managedMessage.setBodyContent((Object)this.getData(triggerObject), DatasetConstants.CONTENT_TYPE_DATA);
        }
        catch (MessageException messageException) {
            logger.error("Cannot set map of data in message body!", (Throwable)messageException);
            managedMessage = MessageFactory.getInstance().createErrorMessage(new PasserelleException("Cannot set map of data in message body!", (Object)"application/x-data", (Throwable)messageException));
            this.fileQueue.clear();
        }
        catch (Exception exception) {
            this.fileQueue.clear();
            throw new DataMessageException("Cannot read data from '" + this.getSourcePath(managedMessage) + "'", (Object)this, (Throwable)exception);
        }
        try {
            managedMessage.setBodyHeader("TITLE", triggerObject.getFile().getName());
        }
        catch (MessageException messageException) {
            managedMessage = MessageFactory.getInstance().createErrorMessage(new PasserelleException("Cannot set header in message!", (Object)"application/x-data", (Throwable)messageException));
        }
        return managedMessage;
    }

    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.isFinishRequested()) {
            this.fileQueue.clear();
            if (this.cachedDatasets != null) {
                this.cachedDatasets.clear();
            }
            if (this.cachedShapes != null) {
                this.cachedShapes.clear();
            }
        }
    }

    private boolean isRequiredFileName(String string) {
        if (this.fileFilter == null || "".equals(this.fileFilter)) {
            return true;
        }
        if (this.filterParam.isJustWildCard()) {
            StringMatcher stringMatcher = new StringMatcher(this.fileFilter, false, false);
            return stringMatcher.match(string);
        }
        return string.matches(this.fileFilter);
    }

    protected String[] getAllDatasetsInFile() {
        if (this.cachedDatasets == null && this.getSourcePath(null) != null) {
            File file;
            block11: {
                String string = this.getSourcePath(null);
                file = new File(string);
                if (file.exists()) break block11;
                return null;
            }
            try {
                IMetaData iMetaData;
                if (file.isDirectory()) {
                    iMetaData = file.listFiles();
                    int n = 0;
                    while (n < ((IMetaData)iMetaData).length) {
                        if (!iMetaData[n].isDirectory()) {
                            file = iMetaData[n];
                            break;
                        }
                        ++n;
                    }
                }
                if ((iMetaData = LoaderFactory.getMetaData((String)file.getAbsolutePath(), null)) != null && iMetaData.getDataNames() != null) {
                    Collection collection = iMetaData.getDataNames();
                    Map map = iMetaData.getDataShapes();
                    if (collection != null && collection.size() == 1 && map != null && map.size() == 1 && map.get(collection.iterator().next()) != null && ((int[])map.get(collection.iterator().next())).length == 2) {
                        int[] nArray = (int[])map.get(collection.iterator().next());
                        this.cachedDatasets = Arrays.asList("image");
                        this.cachedShapes = new HashMap<String, int[]>(1);
                        this.cachedShapes.put("image", nArray);
                    } else {
                        this.cachedDatasets = collection;
                        this.cachedShapes = map;
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Cannot get data set names from " + this.getSourcePath(null), (Throwable)exception);
                this.cachedDatasets = Collections.emptyList();
                this.cachedShapes = Collections.emptyMap();
            }
        }
        if (this.cachedDatasets != null && !this.cachedDatasets.isEmpty()) {
            return this.cachedDatasets.toArray(new String[this.cachedDatasets.size()]);
        }
        return null;
    }

    private Map<String, String> getDataSetsRenameName() {
        Object object;
        String[] stringArray = this.getAllDatasetsInFile();
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        String string = DatasetTitleUtils.getRootName(this.cachedDatasets);
        if (string == null) {
            string = "";
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(7);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            try {
                linkedHashMap.put((String)object, PythonUtils.getLegalVarName((String)((String)object).substring(string.length()), linkedHashMap.values()));
            }
            catch (Exception exception) {
                linkedHashMap.put((String)object, (String)object);
            }
            ++n2;
        }
        if (this.rename.getExpression() == null) {
            return linkedHashMap;
        }
        object = MapUtils.getMap((String)this.rename.getExpression());
        if (object != null) {
            object.keySet().retainAll(linkedHashMap.keySet());
            linkedHashMap.putAll((Map<String, String>)object);
        }
        return linkedHashMap;
    }

    protected DataMessageComponent getData(TriggerObject triggerObject) throws Exception {
        Map<String, Serializable> map;
        String string;
        SliceObject sliceObject;
        File file = triggerObject.getFile();
        ManagedMessage managedMessage = triggerObject.getTrigger();
        String string2 = file.getAbsolutePath();
        if (triggerObject.getSlice() != null) {
            sliceObject = triggerObject.getSlice();
            sliceObject.setPath(file.getAbsolutePath());
            string = this.getDataSetNames()[0];
            sliceObject.setName(string);
            String string3 = this.getMappedName(string);
            if (SLICE_TYPES[0].equals(this.sliceNameType.getExpression())) {
                string3 = String.valueOf(string3) + "_slice_" + triggerObject.getIndex();
            }
            String string4 = PythonUtils.getLegalVarName((String)string3, null);
            AbstractDataset abstractDataset = SliceUtils.getSlice((SliceObject)sliceObject, null);
            abstractDataset.setName(string4);
            map = new HashMap<String, Serializable>(1);
            map.put(string4, (Serializable)abstractDataset);
        } else {
            map = this.getDatasets(string2, triggerObject);
        }
        sliceObject = new DataMessageComponent();
        if (managedMessage != null) {
            try {
                string = MessageUtils.coerceMessage((ManagedMessage)managedMessage);
                sliceObject.addScalar(string.getScalar());
            }
            catch (Exception exception) {
                logger.info("Trigger for " + this.getName() + " is not DataMessageComponent, no data added.");
            }
        }
        if (map != null) {
            sliceObject.setList(map);
        }
        if (this.isMetaRequired) {
            string = LoaderFactory.getMetaData((String)string2, null);
            sliceObject.setMeta((IMetaData)string);
        }
        sliceObject.putScalar("file_path", string2);
        sliceObject.putScalar("file_name", new File(string2).getName());
        sliceObject.putScalar("file_dir", FileUtils.getDirectory((String)string2));
        return sliceObject;
    }

    public String[] getDataSetNames() {
        return this.names.getValue();
    }

    private Map<String, Serializable> getDatasets(String string, TriggerObject triggerObject) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (!DATA_TYPES[0].equals(this.dataType.getExpression())) {
            return null;
        }
        String[] stringArray = this.names.getValue();
        Map map = null;
        if (stringArray != null && stringArray.length > 0) {
            map = LoaderFactory.getDataSets((String)string, Arrays.asList(stringArray), null);
        }
        if (map == null) {
            object3 = LoaderFactory.getData((String)string, null);
            map = object3.getMap();
            if (stringArray != null && stringArray.length > 0) {
                map.keySet().retainAll(Arrays.asList(stringArray));
            }
        }
        if (stringArray == null) {
            object3 = new LinkedHashMap();
            if (this.isSingleImage(map)) {
                object2 = (ILazyDataset)map.values().iterator().next();
                object = triggerObject != null && triggerObject.getIndex() > -1 ? "image" : "image" + triggerObject.getIndex();
                object2.setName((String)object);
                object3.put(object, object2);
            } else {
                object3.putAll(map);
            }
        } else {
            object3 = new LinkedHashMap();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = stringArray2[n2];
                object3.put(object2, map.get(object2));
                ++n2;
            }
        }
        object2 = this.getDataSetNameMap();
        object = new HashMap(object3.size());
        for (String string2 : object3.keySet()) {
            Object object4;
            ILazyDataset iLazyDataset = (ILazyDataset)object3.get(string2);
            if (iLazyDataset == null) continue;
            if (object2 != null && (object4 = (String)object2.get(string2)) != null && !"".equals(object4)) {
                string2 = object4;
            }
            object4 = this.getLoadedData(iLazyDataset);
            object4.setStringPolicy(1);
            object4.setName(string2);
            object.put(string2, object4);
        }
        return object;
    }

    private boolean isSingleImage(Map<String, ILazyDataset> map) {
        if (map.size() != 1) {
            return false;
        }
        ILazyDataset iLazyDataset = map.values().iterator().next();
        return iLazyDataset.getShape() != null && iLazyDataset.getShape().length == 2;
    }

    private AbstractDataset getLoadedData(ILazyDataset iLazyDataset) throws Exception {
        if (iLazyDataset instanceof H5LazyDataset) {
            return ((H5LazyDataset)iLazyDataset).getCompleteData(null);
        }
        return (AbstractDataset)iLazyDataset;
    }

    private Map<String, String> getDataSetNameMap() {
        String string = this.rename.getExpression();
        if (string == null) {
            return null;
        }
        Map map = MapUtils.getMap((String)string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map;
    }

    private String getMappedName(String string) {
        Map<String, String> map = this.getDataSetNameMap();
        if (map == null) {
            return string;
        }
        if (!map.containsKey(string)) {
            return string;
        }
        return map.get(string);
    }

    protected String getExtendedInfo() {
        return "A source which uses  the GDA 'LoaderFactory' to read a DataHandler which can be used to access data";
    }

    public String getSourcePath() {
        return this.getSourcePath(null);
    }

    private String getSourcePath(ManagedMessage managedMessage) {
        DataMessageComponent dataMessageComponent;
        String string = null;
        try {
            dataMessageComponent = managedMessage != null ? MessageUtils.coerceMessage((ManagedMessage)managedMessage) : null;
            string = ParameterUtils.getSubstituedValue((Parameter)this.path, (DataMessageComponent)dataMessageComponent);
        }
        catch (Exception exception) {
            logger.error("Cannot substitute parameter " + this.path, (Throwable)exception);
        }
        if (this.isPathRelative) {
            block6: {
                try {
                    dataMessageComponent = ResourcesPlugin.getWorkspace().getRoot().findMember(string, true);
                    if (dataMessageComponent != null) break block6;
                    return null;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
            string = dataMessageComponent.getLocation().toOSString();
        }
        this.getStandardMessageHeaders().put("__PSRL_SRC_INFO", string);
        return string;
    }

    private Object getResource() {
        if (this.isPathRelative) {
            String string = this.path.getExpression();
            try {
                string = ParameterUtils.substitute((String)string, (NamedObj)this);
            }
            catch (Exception exception) {
                logger.error("Cannot ret resource " + string, (Throwable)exception);
                return null;
            }
            return ResourcesPlugin.getWorkspace().getRoot().findMember(string, true);
        }
        return new File(this.getSourcePath(null));
    }

    private String getResourceTypeName() {
        File file = new File(this.getSourcePath(null));
        return file != null ? "'" + file.getName() + "'" : "";
    }

    public int getResourceCount() {
        return 1;
    }

    public ResourceObject getResource(int n) {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource(this.getResource());
            resourceObject.setResourceTypeName(this.getResourceTypeName());
            return resourceObject;
        }
        return null;
    }

    public void setMomlResource(IResource iResource) {
    }

    public List<IVariable> getOutputVariables() {
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        if (this.getSourcePath(null) == null) {
            String string = "Invalid Path '" + this.path.getExpression() + "'";
            arrayList.add((IVariable)new Variable("file_path", IVariable.VARIABLE_TYPE.PATH, (Object)string, String.class));
            arrayList.add((IVariable)new Variable("file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)string, String.class));
            arrayList.add((IVariable)new Variable("file_dir", IVariable.VARIABLE_TYPE.PATH, (Object)string, String.class));
            return arrayList;
        }
        arrayList.add((IVariable)new Variable("file_path", IVariable.VARIABLE_TYPE.PATH, (Object)this.getSourcePath(null), String.class));
        arrayList.add((IVariable)new Variable("file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)new File(this.getSourcePath(null)).getName(), String.class));
        arrayList.add((IVariable)new Variable("file_dir", IVariable.VARIABLE_TYPE.PATH, (Object)FileUtils.getDirectory((String)this.getSourcePath(null)), String.class));
        if (DATA_TYPES[0].equals(this.dataType.getExpression())) {
            this.getAllDatasetsInFile();
            String[] stringArray = this.names.getValue();
            if (stringArray == null || stringArray.length < 1) {
                stringArray = this.getAllDatasetsInFile();
            }
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    String string;
                    Map<String, String> map = this.getDataSetNameMap();
                    String string2 = string = map != null && map.containsKey(stringArray[n]) ? map.get(stringArray[n]) : stringArray[n];
                    if (this.cachedShapes != null) {
                        int[] nArray = this.cachedShapes.get(stringArray[n]);
                        IVariable.VARIABLE_TYPE vARIABLE_TYPE = nArray != null && nArray.length == 2 ? IVariable.VARIABLE_TYPE.IMAGE : IVariable.VARIABLE_TYPE.ARRAY;
                        AbstractDatasetProvider abstractDatasetProvider = new AbstractDatasetProvider(nArray);
                        arrayList.add((IVariable)new Variable(string, vARIABLE_TYPE, (Object)abstractDatasetProvider, AbstractDataset.class));
                    } else {
                        arrayList.add((IVariable)new Variable(string, IVariable.VARIABLE_TYPE.ARRAY, (Object)new AbstractDatasetProvider(), AbstractDataset.class));
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    protected boolean mustWaitForTrigger() {
        if (!this.isTriggerConnected()) {
            return false;
        }
        if (!this.triggeredOnce) {
            return true;
        }
        return this.fileQueue.isEmpty();
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggeredOnce = true;
        this.appendQueue(managedMessage);
    }
}

