/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.data;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import org.dawb.common.python.PythonUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.common.util.io.IFileUtils;
import org.dawb.gda.extensions.loaders.H5Utils;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.IHierarchicalDataFile;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.io.DatWriter;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.dawb.tango.extensions.editors.SharedMemoryUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JavaImageSaver;

public class DataExportTransformer
extends AbstractDataMessageTransformer
implements IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataExportTransformer.class);
    protected static final List<String> WRITING_CHOICES = new ArrayList<String>(3);
    protected static final List<String> FILE_TYPES;
    protected static final List<String> CALIBRATION_TYPES;
    private Parameter fileFormatParam = new StringParameter((NamedObj)this, "File Format"){
        private static final long serialVersionUID = 3209529425483671733L;

        public String[] getChoices() {
            return FILE_TYPES.toArray(new String[FILE_TYPES.size()]);
        }
    };
    private Parameter fileWriteParam;
    private Parameter calibParam;
    private Parameter datasetName;
    private ResourceParameter filePathParam;
    private String fileFormat;
    private String filePath;
    private String fileWriteType;
    private static final long serialVersionUID = -8257060666137254610L;
    private IHierarchicalDataFile cachedFile;
    private IFile fileWritingTo;

    static {
        WRITING_CHOICES.add("Append to file referenced by Output");
        WRITING_CHOICES.add("Replace file referenced by Output");
        WRITING_CHOICES.add("Create new file for each evaluation using ${file_name}");
        WRITING_CHOICES.add("Create new file using ${file_name} then use that for everything");
        WRITING_CHOICES.add("Create new file using ${file_name} overwrite it.");
        FILE_TYPES = new ArrayList<String>(3);
        FILE_TYPES.add("hdf5");
        FILE_TYPES.add("dat (ascii)");
        FILE_TYPES.add("dat (ascii) separate files");
        FILE_TYPES.add("jpg (8-bit)");
        FILE_TYPES.add("png (16-bit)");
        FILE_TYPES.add("tiff (16-bit)");
        FILE_TYPES.add("tiff (33-bit)");
        CALIBRATION_TYPES = new ArrayList<String>(3);
        CALIBRATION_TYPES.add("None");
        CALIBRATION_TYPES.add("Use user defined calibration for ascii files");
    }

    public DataExportTransformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter(this.fileFormatParam);
        this.fileFormatParam.setExpression(FILE_TYPES.get(0));
        this.fileWriteParam = new StringChoiceParameter((NamedObj)this, "Writing Type", WRITING_CHOICES, 4);
        this.registerConfigurableParameter(this.fileWriteParam);
        this.fileWriteParam.setExpression(WRITING_CHOICES.get(3));
        this.filePathParam = new ResourceParameter((NamedObj)this, "Output");
        this.filePathParam.setResourceType(2);
        this.filePathParam.setExpression("/${project_name}/output/");
        this.registerConfigurableParameter((Parameter)this.filePathParam);
        this.calibParam = new StringParameter((NamedObj)this, "Calibration"){
            private static final long serialVersionUID = 7033872585443953608L;

            public String[] getChoices() {
                return CALIBRATION_TYPES.toArray(new String[CALIBRATION_TYPES.size()]);
            }
        };
        this.registerConfigurableParameter(this.calibParam);
        this.calibParam.setExpression(CALIBRATION_TYPES.get(0));
        this.datasetName = new StringParameter((NamedObj)this, "Dataset Name");
        this.registerConfigurableParameter(this.datasetName);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileFormatParam) {
            this.fileFormat = this.fileFormatParam.getExpression();
        } else if (attribute == this.filePathParam) {
            this.filePath = this.filePathParam.getExpression();
        } else if (attribute == this.fileWriteParam) {
            this.fileWriteType = this.fileWriteParam.getExpression();
            if (WRITING_CHOICES.get(0).equals(this.fileWriteType) || WRITING_CHOICES.get(1).equals(this.fileWriteType)) {
                this.filePathParam.setResourceType(1);
            } else {
                this.filePathParam.setResourceType(2);
            }
        }
        super.attributeChanged(attribute);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        String string = null;
        try {
            Map map = MessageUtils.getScalar(list);
            String string2 = map != null ? (String)map.get("file_name") : null;
            IFile iFile = this.getOutputPath(string2);
            string = iFile.getLocation().toOSString();
            DataMessageComponent dataMessageComponent = new DataMessageComponent();
            dataMessageComponent.addScalar(MessageUtils.getScalar(list));
            dataMessageComponent.putScalar("file_path", string);
            dataMessageComponent.putScalar("file_dir", FileUtils.getDirectory((String)string));
            File file = new File(string);
            dataMessageComponent.putScalar("file_name", file.getName());
            dataMessageComponent.putScalar("file_basename", FileUtils.getFileNameNoExtension((File)file));
            if (FILE_TYPES.get(1).equals(this.fileFormat) || FILE_TYPES.get(2).equals(this.fileFormat)) {
                this.writeAscii(string, list, dataMessageComponent);
            } else if (FILE_TYPES.get(0).equals(this.fileFormat)) {
                this.writeH5(string, list, dataMessageComponent);
            } else {
                this.writeImage(string, list, dataMessageComponent);
            }
            AbstractPassModeTransformer.refreshResource((IResource)iFile);
            return dataMessageComponent;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot write to " + string, exception);
        }
    }

    private void writeAscii(String string, List<DataMessageComponent> list, DataMessageComponent dataMessageComponent) throws Exception {
        List list2 = MessageUtils.getDatasets(list);
        File file = new File(string);
        Map map = MessageUtils.getScalar(list);
        DatWriter datWriter = new DatWriter();
        datWriter.setMeta(map);
        datWriter.setFile(file);
        datWriter.setWriteIndex(false);
        boolean bl = FILE_TYPES.get(2).equals(this.fileFormat);
        if (CALIBRATION_TYPES.get(1).equals(this.calibParam.getExpression()) && !bl) {
            datWriter.addData(SharedMemoryUtils.getCalibrated((IDataset)((IDataset)list2.get(0)), (Map)map, (boolean)false));
        }
        int n = 1;
        for (IDataset iDataset : list2) {
            String string2 = String.valueOf(FileUtils.getLegalFileName((String)iDataset.getName())) + ".dat";
            if (bl) {
                File file2 = file.getParentFile();
                File file3 = new File(file2, string2);
                datWriter.setFile(file3);
                if (CALIBRATION_TYPES.get(1).equals(this.calibParam.getExpression())) {
                    datWriter.addData(SharedMemoryUtils.getCalibrated((IDataset)iDataset, (Map)map, (boolean)false));
                }
            }
            datWriter.addData(iDataset);
            if (bl) {
                datWriter.write();
                datWriter.clear();
                dataMessageComponent.putScalar("data_file_name" + n, string2);
            }
            ++n;
        }
        if (!bl) {
            dataMessageComponent.putScalar("data_file_name", file.getName());
            datWriter.write();
        }
    }

    private void writeImage(String string, List<DataMessageComponent> list, DataMessageComponent dataMessageComponent) throws Exception {
        boolean bl = false;
        List list2 = MessageUtils.getDatasets(list);
        int n = 1;
        for (IDataset iDataset : list2) {
            String string2;
            String string3;
            File file;
            if (iDataset.getShape().length != 2) continue;
            File file2 = new File(string).getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            dataMessageComponent.putScalar("dir_path", file2.getAbsolutePath());
            if (WRITING_CHOICES.get(1).equals(this.fileWriteParam.getExpression()) || WRITING_CHOICES.get(4).equals(this.fileWriteParam.getExpression())) {
                file = new File(string);
                string3 = file.getName();
                string2 = PythonUtils.getLegalVarName((String)string3.substring(0, string3.indexOf(48)), null);
            } else {
                string2 = PythonUtils.getLegalVarName((String)iDataset.getName(), null);
                file = new File(file2, string2);
            }
            string3 = file.getAbsolutePath();
            if (file.getName().indexOf(46) < 0) {
                string3 = String.valueOf(string3) + "." + this.getExtension();
            }
            JavaImageSaver javaImageSaver = new JavaImageSaver(string3, this.getExtension(), this.getBits(), true);
            DataHolder dataHolder = new DataHolder();
            dataHolder.addDataset(iDataset.getName(), (ILazyDataset)iDataset);
            javaImageSaver.saveFile(dataHolder);
            dataMessageComponent.addList("image" + n, (AbstractDataset)iDataset);
            ++n;
            bl = true;
        }
        if (!bl) {
            throw new Exception("No 2D data sets found! Cannot write " + this.fileFormat + " with this data!");
        }
    }

    private synchronized void writeH5(String string, List<DataMessageComponent> list, DataMessageComponent dataMessageComponent) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            boolean bl;
            Group group;
            String string22;
            Object object;
            if (this.isWritingSingleFile()) {
                if (this.cachedFile == null) {
                    if (WRITING_CHOICES.get(1).equals(this.fileWriteType) && ((File)(object = new File(string))).exists()) {
                        ((File)object).delete();
                    }
                    this.cachedFile = HierarchicalDataFactory.getWriter((String)string);
                }
                iHierarchicalDataFile = this.cachedFile;
            } else {
                iHierarchicalDataFile = HierarchicalDataFactory.getWriter((String)string);
            }
            object = MessageUtils.getScalar(list);
            List list2 = MessageUtils.getDatasets(list);
            Group group2 = iHierarchicalDataFile.group("entry");
            iHierarchicalDataFile.setNexusAttribute((HObject)group2, "NXentry");
            Group group3 = iHierarchicalDataFile.group("dictionary", group2);
            iHierarchicalDataFile.setNexusAttribute((HObject)group3, "NXdata");
            if (object != null) {
                for (String string22 : object.keySet()) {
                    group = iHierarchicalDataFile.createDataset(string22, (String)object.get(string22), group3);
                    iHierarchicalDataFile.setNexusAttribute((HObject)group, "SDS");
                }
            }
            boolean bl2 = bl = (string22 = this.getDatasetName(list)) == null || string22.endsWith("/");
            if (bl) {
                String string3;
                group = group2;
                if (string22 != null && string22.endsWith("/")) {
                    IDataset iDataset = string22.split("/");
                    if (((String[])iDataset).length > 0) {
                        int n = 0;
                        while (n < ((String[])iDataset).length) {
                            string3 = iDataset[n];
                            group = iHierarchicalDataFile.group(string3, group);
                            if (n < ((IDataset)iDataset).length - 1) {
                                iHierarchicalDataFile.setNexusAttribute((HObject)group, "NXentry");
                            }
                            ++n;
                        }
                    } else {
                        group = iHierarchicalDataFile.group("data", group2);
                    }
                } else {
                    group = iHierarchicalDataFile.group("data", group2);
                }
                iHierarchicalDataFile.setNexusAttribute((HObject)group, "NXdata");
                if (list2 != null) {
                    for (IDataset iDataset : list2) {
                        string3 = (AbstractDataset)iDataset;
                        Datatype datatype = H5Utils.getDatatype((AbstractDataset)string3);
                        long[] lArray = new long[string3.getShape().length];
                        int n = 0;
                        while (n < lArray.length) {
                            lArray[n] = string3.getShape()[n];
                            ++n;
                        }
                        Dataset dataset = iHierarchicalDataFile.createDataset(string3.getName(), datatype, lArray, (Object)string3.getBuffer(), group);
                        iHierarchicalDataFile.setNexusAttribute((HObject)dataset, "SDS");
                    }
                }
            } else {
                group = string22.split("/");
                Group group4 = group2;
                if (((String[])group).length > 2) {
                    int n = 0;
                    while (n < ((Group)group).length - 2) {
                        group4 = iHierarchicalDataFile.group((String)group[n], group4);
                        iHierarchicalDataFile.setNexusAttribute((HObject)group4, "NXentry");
                        ++n;
                    }
                    group4 = iHierarchicalDataFile.group((String)group[((Group)group).length - 2], group4);
                    iHierarchicalDataFile.setNexusAttribute((HObject)group4, "NXdata");
                } else if (((Group)group).length == 2) {
                    group4 = iHierarchicalDataFile.group((String)group[((Group)group).length - 2], group4);
                    iHierarchicalDataFile.setNexusAttribute((HObject)group4, "NXdata");
                }
                Group group5 = group[((Group)group).length - 1];
                if (list2 != null) {
                    for (IDataset iDataset : list2) {
                        AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                        Datatype datatype = H5Utils.getDatatype((AbstractDataset)abstractDataset);
                        long[] lArray = new long[abstractDataset.getShape().length];
                        int n = 0;
                        while (n < lArray.length) {
                            lArray[n] = abstractDataset.getShape()[n];
                            ++n;
                        }
                        Dataset dataset = iHierarchicalDataFile.appendDataset((String)group5, datatype, lArray, (Object)abstractDataset.getBuffer(), group4);
                        iHierarchicalDataFile.setNexusAttribute((HObject)dataset, "SDS");
                    }
                }
            }
        }
        finally {
            try {
                if (iHierarchicalDataFile != null && !this.isWritingSingleFile()) {
                    iHierarchicalDataFile.close();
                }
            }
            catch (Exception exception) {
                throw this.createDataMessageException("Cannot close " + string, exception);
            }
        }
    }

    private String getDatasetName(List<DataMessageComponent> list) throws Exception {
        return ParameterUtils.getSubstituedValue((Parameter)this.datasetName, list);
    }

    private boolean isWritingSingleFile() {
        this.fileWriteType = this.fileWriteParam.getExpression();
        return WRITING_CHOICES.get(0).equals(this.fileWriteType) || WRITING_CHOICES.get(1).equals(this.fileWriteType) || WRITING_CHOICES.get(3).equals(this.fileWriteType);
    }

    private String getOutputPath() throws Exception {
        List list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (iVariable == null || !iVariable.getVariableName().equals("file_name")) continue;
            return this.getOutputPath(iVariable.getExampleValue().toString()).getLocation().toOSString();
        }
        return this.getOutputPath("new_data_file.h5").getLocation().toOSString();
    }

    public void doPreInitialize() {
        this.fileWritingTo = null;
    }

    private IFile getOutputPath(String string) throws Exception {
        if (string == null) {
            string = "new_data_file.h5";
        }
        this.fileWriteType = this.fileWriteParam.getExpression();
        this.filePath = this.filePathParam.getExpression();
        this.filePath = ParameterUtils.substitute((String)this.filePath, (NamedObj)this);
        if (WRITING_CHOICES.get(0).equals(this.fileWriteType) || WRITING_CHOICES.get(1).equals(this.fileWriteType)) {
            IFile iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.filePath, true);
            if (iFile == null) {
                File file = new File(this.filePath);
                String string2 = file.getName();
                String string3 = file.getParent();
                IContainer iContainer = IFileUtils.getContainer((String)string3, (String)this.getProject().getName(), (String)"output");
                iFile = iContainer instanceof IProject ? ((IProject)iContainer).getFile(string2) : ((IFolder)iContainer).getFile(string2);
            }
            return iFile;
        }
        if (WRITING_CHOICES.get(2).equals(this.fileWriteType)) {
            if (string == null) {
                throw this.createDataMessageException("Inputs to '" + this.getName() + "' must contain scalar value 'file_name' to determine h5 output name.", null);
            }
            String string4 = string.substring(0, string.lastIndexOf("."));
            IContainer iContainer = IFileUtils.getContainer((String)this.filePath, (String)this.getProject().getName(), (String)"output");
            IFile iFile = IFileUtils.getUniqueIFile((IContainer)iContainer, (String)string4, (String)this.getExtension());
            return iFile;
        }
        if (WRITING_CHOICES.get(3).equals(this.fileWriteType) || WRITING_CHOICES.get(4).equals(this.fileWriteType)) {
            if (string == null) {
                throw this.createDataMessageException("Inputs to '" + this.getName() + "' must contain scalar value 'file_name' to determine h5 output name.", null);
            }
            if (this.fileWritingTo == null) {
                String string5 = string.indexOf(46) > -1 ? string.substring(0, string.lastIndexOf(".")) : string;
                IContainer iContainer = IFileUtils.getContainer((String)this.filePath, (String)this.getProject().getName(), (String)"output");
                this.fileWritingTo = IFileUtils.getUniqueIFile((IContainer)iContainer, (String)string5, (String)this.getExtension());
            }
            if (WRITING_CHOICES.get(4).equals(this.fileWriteType) && this.fileWritingTo.exists()) {
                this.fileWritingTo.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            return this.fileWritingTo;
        }
        return null;
    }

    private String getExtension() {
        this.fileFormat = this.fileFormatParam.getExpression();
        if (FILE_TYPES.get(0).equals(this.fileFormat)) {
            return "h5";
        }
        if (FILE_TYPES.get(1).equals(this.fileFormat)) {
            return "dat";
        }
        if (FILE_TYPES.get(2).equals(this.fileFormat)) {
            return "dat";
        }
        if (FILE_TYPES.get(3).equals(this.fileFormat)) {
            return "jpg";
        }
        if (FILE_TYPES.get(4).equals(this.fileFormat)) {
            return "png";
        }
        if (FILE_TYPES.get(5).equals(this.fileFormat)) {
            return "tiff";
        }
        if (FILE_TYPES.get(6).equals(this.fileFormat)) {
            return "tiff";
        }
        return "h5";
    }

    private int getBits() {
        if (FILE_TYPES.get(3).equals(this.fileFormat)) {
            return 8;
        }
        if (FILE_TYPES.get(4).equals(this.fileFormat)) {
            return 16;
        }
        if (FILE_TYPES.get(5).equals(this.fileFormat)) {
            return 16;
        }
        if (FILE_TYPES.get(6).equals(this.fileFormat)) {
            return 33;
        }
        return 16;
    }

    protected String getExtendedInfo() {
        return "Actor writes file to required format and then outputs file written path";
    }

    public List<IVariable> getOutputVariables() {
        List list = super.getOutputVariables();
        try {
            List list2 = this.getInputVariables();
            if (FILE_TYPES.get(1).equals(this.fileFormatParam.getExpression())) {
                int n = 1;
                if (list2 != null) {
                    for (IVariable iVariable : list2) {
                        if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.ARRAY) continue;
                        list.add(new Variable("data_file_name" + n, IVariable.VARIABLE_TYPE.SCALAR, (Object)(String.valueOf(iVariable.getVariableName()) + ".dat"), String.class));
                        ++n;
                    }
                }
            } else if (FILE_TYPES.get(2).equals(this.fileFormatParam.getExpression())) {
                list.add(new Variable("data_file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)"${file_name}.dat", String.class));
            } else if (!FILE_TYPES.get(0).equals(this.fileFormatParam.getExpression()) && list2 != null) {
                for (IVariable iVariable : list2) {
                    int n = 1;
                    if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.ARRAY) continue;
                    list.add(new Variable("image" + n, IVariable.VARIABLE_TYPE.ARRAY, (Object)iVariable.getVariableName(), String.class));
                    ++n;
                }
            }
            list.add(new Variable("file_path", IVariable.VARIABLE_TYPE.PATH, (Object)this.getOutputPath(), String.class));
            list.add(new Variable("file_name", IVariable.VARIABLE_TYPE.SCALAR, (Object)new File(this.getOutputPath()).getName(), String.class));
            list.add(new Variable("file_dir", IVariable.VARIABLE_TYPE.PATH, (Object)FileUtils.getDirectory((String)this.getOutputPath()), String.class));
            list.add(new Variable("file_basename", IVariable.VARIABLE_TYPE.PATH, (Object)FileUtils.getFileNameNoExtension((File)new File(this.getOutputPath())), String.class));
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot get output folder for " + this.getName(), (Throwable)exception);
            return list;
        }
    }

    protected String getOperationName() {
        return "export";
    }

    protected void doWrapUp() throws TerminationException {
        if (this.cachedFile != null) {
            try {
                this.cachedFile.close();
            }
            catch (Exception exception) {
                logger.error("Unable to close cached hdf5 file!", (Throwable)exception);
            }
            this.cachedFile = null;
        }
        super.doWrapUp();
    }
}

