/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class PassDelay
extends AbstractDataMessageTransformer
implements Actor {
    private Logger logger = LoggerFactory.getLogger(PassDelay.class);
    private final Parameter timeParameter = new Parameter((NamedObj)this, "time(s)", (Token)new IntToken(1));
    private static final long serialVersionUID = -6096875966009208199L;

    public PassDelay(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.timeParameter.setTypeEquals((Type)BaseType.DOUBLE);
        this.registerConfigurableParameter(this.timeParameter);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(0));
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        double d = 0.0;
        try {
            d = ((DoubleToken)this.timeParameter.getToken()).doubleValue();
            if (d > 0.0) {
                this.logger.debug("Delay action, sleeping for " + d + " seconds.");
                Thread.sleep(Math.round(d * 1000.0));
            }
        }
        catch (InterruptedException interruptedException) {
            d = 0.0;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot sleep for '" + this.timeParameter.getExpression() + "' in " + this.getName(), exception);
        }
        DataMessageComponent dataMessageComponent = MessageUtils.copy(list);
        dataMessageComponent.putScalar("sleep_time", "" + d);
        return dataMessageComponent;
    }

    protected String getOperationName() {
        return "Sleep";
    }

    protected String getExtendedInfo() {
        return "Sleeps for a time defined in seconds.";
    }

    public List<IVariable> getOutputVariables() {
        return this.getInputVariables();
    }
}

