/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors;

import com.isencia.passerelle.actor.ProcessingException;
import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class DataCounter
extends AbstractDataMessageTransformer {
    private static List<String> MODES = new ArrayList<String>(3);
    private double storedValue;
    private boolean readValue = false;
    private static final long serialVersionUID = 4663716377018297122L;
    private StringParameter nameParam = new StringParameter((NamedObj)this, "Name");

    static {
        MODES.addAll(EXPRESSION_MODE);
        MODES.add("Evaluate on every data input and store value locally.");
    }

    public DataCounter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.nameParam.setExpression("x");
        this.nameParam.setDisplayName("Scalar Name");
        this.registerConfigurableParameter((Parameter)this.nameParam);
        this.passModeParameter.setExpression((String)EXPRESSION_MODE.get(0));
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected List<String> getExpressionModes() {
        return MODES;
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        String string = this.nameParam.getExpression();
        try {
            DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
            double d = Double.parseDouble(dataMessageComponent.getScalar(string));
            this.readValue = true;
            if (MODES.get(2).equals(this.passModeParameter.getExpression()) && this.readValue) {
                d = this.storedValue;
            }
            this.storedValue = d += 1.0;
            dataMessageComponent.putScalar(string, String.valueOf(d));
            return dataMessageComponent;
        }
        catch (Throwable throwable) {
            throw this.createDataMessageException("Cannot increment '" + string + "'", throwable);
        }
    }

    protected boolean isFireInLoop() {
        return super.isFireInLoop() || MODES.get(2).equals(this.passMode);
    }

    protected String getOperationName() {
        return "Counter";
    }
}

