/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.thread.SchedulerTimerTask;

public final class Scheduler {
    public static final Timer CLOCK_DAEMON = new Timer("ActiveMQ Scheduler", true);
    private static final HashMap<Runnable, TimerTask> TIMER_TASKS = new HashMap();

    private Scheduler() {
    }

    public static synchronized void executePeriodically(Runnable task, long period) {
        SchedulerTimerTask timerTask = new SchedulerTimerTask(task);
        CLOCK_DAEMON.scheduleAtFixedRate((TimerTask)timerTask, period, period);
        TIMER_TASKS.put(task, timerTask);
    }

    public static synchronized void cancel(Runnable task) {
        TimerTask ticket = TIMER_TASKS.remove(task);
        if (ticket != null) {
            ticket.cancel();
            CLOCK_DAEMON.purge();
        }
    }

    public static void executeAfterDelay(Runnable task, long redeliveryDelay) {
        SchedulerTimerTask timerTask = new SchedulerTimerTask(task);
        CLOCK_DAEMON.schedule((TimerTask)timerTask, redeliveryDelay);
    }

    public static void shutdown() {
        CLOCK_DAEMON.cancel();
    }
}

