/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.dawb.common.util.eclipse.BundleUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.passerelle.common.project.PasserelleNature;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.edna.pydev.extensions.utils.PydevProjectUtils;

public class ModelUtils {
    public static IProject createWorkflowProject(String string, IWorkspaceRoot iWorkspaceRoot, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        if (iWorkspaceRoot.getProject(string).exists()) {
            return iWorkspaceRoot.getProject(string);
        }
        IProject iProject = ModelUtils.createPasserelleProject(string, iWorkspaceRoot, bl, iProgressMonitor);
        PydevProjectUtils.createSrcAndExample((IProject)iProject, null, (String)"helloworld", null, (IProgressMonitor)iProgressMonitor);
        if (bl) {
            IFile iFile;
            Object object;
            int n;
            IFolder iFolder = iProject.getFolder("src");
            File file = BundleUtils.getBundleLocation((String)"org.dawb.workbench.examples");
            File file2 = new File(file, "python");
            if (file2.exists()) {
                File[] fileArray = file2.listFiles();
                n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = fileArray[n2];
                    if (((File)object).exists() && ((File)object).canRead() && ((File)object).isFile()) {
                        iFile = iFolder.getFile(((File)object).getName());
                        iFile.create((InputStream)new FileInputStream((File)object), false, iProgressMonitor);
                    }
                    ++n2;
                }
            }
            if ((file2 = new File(file, "configuration")).exists()) {
                object = iProject.getFolder("configuration");
                if (!object.exists()) {
                    object.create(true, true, iProgressMonitor);
                }
                iFile = file2.listFiles();
                int n3 = ((File[])iFile).length;
                n = 0;
                while (n < n3) {
                    IFile iFile2 = iFile[n];
                    if (iFile2.exists() && iFile2.canRead() && iFile2.isFile()) {
                        IFile iFile3 = object.getFile(iFile2.getName());
                        iFile3.create((InputStream)new FileInputStream((File)iFile2), false, iProgressMonitor);
                    }
                    ++n;
                }
            }
            object = iProject.getFolder("data");
            object.create(true, true, iProgressMonitor);
            File file3 = new File(file, "data");
            if (file3.exists()) {
                FileUtils.recursiveCopy((File)file3, (File)new File(object.getLocation().toOSString()));
            }
        }
        iProject.refreshLocal(2, iProgressMonitor);
        return iProject;
    }

    public static IFile createFolderMonitorWorkflow(IContainer iContainer, String string, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        iFile.create(ModelUtils.openFolderMonitorStream(iFile, file), true, iProgressMonitor);
        return iFile;
    }

    private static InputStream openFolderMonitorStream(IFile iFile, File file) {
        String string = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\"\n    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\">\n<entity name=\"" + iFile.getName().substring(0, iFile.getName().indexOf(46)) + "\" class=\"ptolemy.actor.TypedCompositeActor\" source=\"" + iFile.getLocation().toOSString() + "\">\n" + "    <property name=\"_createdBy\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"7.0.1\">\n" + "    </property>\n" + "    <property name=\"_workbenchVersion\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"1.0.0.qualifier\">\n" + "    </property>\n" + "    <property name=\"Director\" class=\"com.isencia.passerelle.domain.cap.Director\">\n" + "       <property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{20, 20}\">\n" + "        </property>\n" + "    </property>\n" + "    <entity name=\"Folder Monitor\" class=\"org.dawb.passerelle.actors.data.FolderMonitorSource\">\n" + "        <property name=\"Receiver Q Capacity (-1)\" class=\"ptolemy.data.expr.Parameter\" value=\"-1\">\n" + "        </property>\n" + "        <property name=\"Receiver Q warning size (-1)\" class=\"ptolemy.data.expr.Parameter\" value=\"-1\">\n" + "        </property>\n" + "        <property name=\"_icon\" class=\"com.isencia.passerelle.actor.gui.EditorIcon\">\n" + "        </property>\n" + "        <property name=\"Folder\" class=\"com.isencia.passerelle.util.ptolemy.ResourceParameter\" value=\"" + file.getAbsolutePath() + "\">\n" + "        </property>\n" + "        <property name=\"Checking Frequency\" class=\"ptolemy.data.expr.Parameter\" value=\"100\">\n" + "        </property>\n" + "        <property name=\"Inactive After\" class=\"ptolemy.data.expr.Parameter\" value=\"-1\">\n" + "        </property>\n" + "        <property name=\"Relative Path\" class=\"ptolemy.data.expr.Parameter\" value=\"false\">\n" + "        </property>\n" + "        <property name=\"File Filter\" class=\"com.isencia.passerelle.util.ptolemy.RegularExpressionParameter\" value=\"\">\n" + "        </property>\n" + "        <property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{20.0, 179.0}\">\n" + "        </property>\n" + "        <port name=\"requestFinish\" class=\"com.isencia.passerelle.core.ControlPort\">\n" + "            <property name=\"input\"/>\n" + "            <property name=\"multiport\"/>\n" + "            <property name=\"control\" class=\"ptolemy.kernel.util.StringAttribute\">\n" + "            </property>\n" + "        </port>\n" + "        <port name=\"error\" class=\"com.isencia.passerelle.core.ErrorPort\">\n" + "            <property name=\"output\"/>\n" + "            <property name=\"multiport\"/>\n" + "            <property name=\"error\" class=\"ptolemy.kernel.util.StringAttribute\">\n" + "            </property>\n" + "        </port>\n" + "        <port name=\"hasFired\" class=\"com.isencia.passerelle.core.ControlPort\">\n" + "            <property name=\"output\"/>\n" + "            <property name=\"multiport\"/>\n" + "            <property name=\"control\" class=\"ptolemy.kernel.util.StringAttribute\">\n" + "            </property>\n" + "        </port>\n" + "        <port name=\"hasFinished\" class=\"com.isencia.passerelle.core.ControlPort\">\n" + "            <property name=\"output\"/>\n" + "            <property name=\"multiport\"/>\n" + "            <property name=\"control\" class=\"ptolemy.kernel.util.StringAttribute\">\n" + "            </property>\n" + "        </port>\n" + "        <port name=\"output\" class=\"com.isencia.passerelle.core.Port\">\n" + "            <property name=\"output\"/>\n" + "            <property name=\"multiport\"/>\n" + "        </port>\n" + "        <port name=\"trigger\" class=\"com.isencia.passerelle.core.Port\">\n" + "            <property name=\"input\"/>\n" + "            <property name=\"multiport\"/>\n" + "        </port>\n" + "    </entity>\n" + "</entity>";
        return new ByteArrayInputStream(string.getBytes());
    }

    public static void createEmptyWorkflow(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        iFile.create(ModelUtils.openContentStream(), true, iProgressMonitor);
    }

    private static InputStream openContentStream() {
        String string = "<?xml version=\"1.0\" standalone=\"no\"?> \r\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\"> \r\n<entity name=\"newModel\" class=\"ptolemy.actor.TypedCompositeActor\"> \r\n   <property name=\"_createdBy\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"7.0.1\" /> \r\n   <property name=\"_workbenchVersion\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"" + System.getProperty("dawb.workbench.version") + "\" /> \r\n" + "   <property name=\"Director\" class=\"com.isencia.passerelle.domain.cap.Director\" > \r\n" + "      <property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{20, 20}\" /> \r\n" + "   </property> \r\n" + "</entity>";
        return new ByteArrayInputStream(string.getBytes());
    }

    public static IProject createPasserelleProject(String string, IWorkspaceRoot iWorkspaceRoot, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = iWorkspaceRoot.getProject(string);
        iProject.create(iProgressMonitor);
        iProject.open(iProgressMonitor);
        ModelUtils.createEmptyWorkflow((IContainer)iProject, "empty_workflow.moml", iProgressMonitor);
        if (bl) {
            File file;
            IFolder iFolder = iProject.getFolder("examples");
            iFolder.create(true, true, iProgressMonitor);
            File file2 = BundleUtils.getBundleLocation((String)"org.dawb.workbench.examples");
            File file3 = new File(file2, "workflows");
            if (file3.exists()) {
                File[] fileArray = file3.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    file = fileArray[n2];
                    if (file.exists() && file.canRead() && file.isFile()) {
                        IFile iFile = iFolder.getFile(file.getName());
                        iFile.create((InputStream)new FileInputStream(file), false, iProgressMonitor);
                    }
                    ++n2;
                }
            }
            if ((file = new File(file2, "workflows-edna")).exists()) {
                IFolder iFolder2 = iProject.getFolder("examples-edna");
                iFolder2.create(true, true, iProgressMonitor);
                if (file.exists()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File file4 = fileArray[n3];
                        if (file4.exists() && file4.canRead() && file4.isFile()) {
                            IFile iFile = iFolder2.getFile(file4.getName());
                            iFile.create((InputStream)new FileInputStream(file4), false, iProgressMonitor);
                        }
                        ++n3;
                    }
                }
            }
        }
        ModelUtils.addPasserelleNature(iProject, iProgressMonitor);
        return iProject;
    }

    private static void addPasserelleNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setNatureIds(new String[]{PasserelleNature.ID});
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }
}

