/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.startup;

import org.dawb.passerelle.common.utils.ModelUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsProjectCreator
implements IStartup {
    private static final Logger logger = LoggerFactory.getLogger(ModelsProjectCreator.class);

    public void earlyStartup() {
        if (System.getProperty("dawb.workbench.is") == null) {
            return;
        }
        ModelsProjectCreator.createWorkflowProject();
    }

    private static void createWorkflowProject() {
        Object object;
        boolean bl;
        final IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean bl2 = bl = iWorkspaceRoot.getProjects() != null && iWorkspaceRoot.getProjects().length > 1;
        if (bl) {
            return;
        }
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iProjectArray[n2];
            if (object.getName().equals("workflows")) {
                return;
            }
            ++n2;
        }
        object = new Job("Create Workflow Project"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    ModelUtils.createWorkflowProject("workflows", iWorkspaceRoot, true, iProgressMonitor);
                    IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                    iWorkspace.save(false, iProgressMonitor);
                }
                catch (Exception exception) {
                    logger.error("Cannot create data project!", (Throwable)exception);
                }
                return Status.OK_STATUS;
            }
        };
        object.setUser(false);
        object.setSystem(true);
        object.schedule();
    }
}

