/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.remote;

import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dawb.common.services.IHardwareService;
import org.dawb.common.services.IUserInputService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.plot.IPlottingSystemSelection;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.views.ImageMonitorView;
import org.dawb.passerelle.common.Activator;
import org.dawb.passerelle.common.utils.ModelListener;
import org.dawb.workbench.jmx.IRemoteWorkbench;
import org.dawb.workbench.jmx.RemoveWorkbenchPart;
import org.dawb.workbench.jmx.UserInputBean;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkbenchImpl
implements IRemoteWorkbench {
    private static final Logger logger = LoggerFactory.getLogger(RemoteWorkbenchImpl.class);

    public void executionStarted() {
        ModelListener.notifyExecutionStarted();
    }

    public void executionTerminated(int n) {
        ModelListener.notifyExecutionTerminated(n);
    }

    public boolean openFile(final String string) {
        final ArrayList arrayList = new ArrayList(1);
        logger.debug("openFile @ " + string);
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    File file;
                    String string4;
                    String string2;
                    String string3 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                    logger.debug("workspace path is " + string3);
                    IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string));
                    if (iResource == null) {
                        try {
                            string2 = string.substring(string3.length());
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            string2 = string;
                        }
                        iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string2));
                    }
                    if (iResource == null) {
                        iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(String.valueOf(string3) + string));
                    }
                    logger.debug("resource to open requested: " + iResource);
                    if (iResource != null && iResource instanceof IFile) {
                        logger.debug("opening IFile editor for " + string);
                        string4 = new FileEditorInput((IFile)iResource);
                        string2 = EclipseUtils.getPage().findEditor((IEditorInput)string4);
                        if (string2 == null) {
                            string2 = EclipseUtils.openEditor((IFile)((IFile)iResource));
                        }
                    } else {
                        string4 = string;
                        file = new File(string4);
                        if (!file.exists()) {
                            logger.debug(String.valueOf(string4) + " not found, trying " + string3 + string4);
                            if (new File(String.valueOf(string3) + string4).exists()) {
                                file = new File(String.valueOf(string3) + string4);
                                string4 = String.valueOf(string3) + string4;
                                logger.debug(String.valueOf(string4) + " found ");
                            }
                        }
                        logger.debug("opening external editor for " + string4);
                        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                        FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(iFileStore);
                        string2 = EclipseUtils.getPage().findEditor((IEditorInput)fileStoreEditorInput);
                        if (string2 == null) {
                            string2 = EclipseUtils.openExternalEditor((String)string4);
                        }
                    }
                    arrayList.add(string2);
                    if (string2 != null && string2 instanceof IPlottingSystemSelection) {
                        string4 = (IPlottingSystemSelection)string2;
                        file = new UIJob("Show data", (IPlottingSystemSelection)string4){
                            private final /* synthetic */ IPlottingSystemSelection val$prov;
                            {
                                this.val$prov = iPlottingSystemSelection;
                                super(string);
                            }

                            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                this.val$prov.setAll1DSelected(false);
                                return Status.OK_STATUS;
                            }
                        };
                        file.schedule(50L);
                    }
                }
                catch (PartInitException partInitException) {
                    logger.error("Cannot open file " + string, (Throwable)partInitException);
                }
            }
        });
        return !arrayList.isEmpty();
    }

    public boolean monitorDirectory(final String string, final boolean bl) {
        final ArrayList arrayList = new ArrayList(1);
        logger.debug("monitorDirectory called " + string);
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageMonitorView imageMonitorView = (ImageMonitorView)EclipseUtils.getActivePage().showView("org.dawb.workbench.views.imageMonitorView");
                    if (imageMonitorView != null) {
                        imageMonitorView.setDirectoryPath(string);
                        imageMonitorView.setMonitoring(bl);
                        arrayList.add(string);
                    }
                }
                catch (PartInitException partInitException) {
                    logger.error("Cannot monitor directory " + string, (Throwable)partInitException);
                }
            }
        });
        return !arrayList.isEmpty();
    }

    public boolean refresh(String string, String string2) {
        logger.debug("refresh project called " + string2);
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string2);
        if (iResource == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        }
        if (iResource != null) {
            block5: {
                try {
                    if (iResource.isAccessible()) break block5;
                    return false;
                }
                catch (CoreException coreException) {
                    logger.error("Cannot refresh project " + iResource, (Throwable)coreException);
                    return false;
                }
            }
            iResource.refreshLocal(2, null);
            return true;
        }
        return false;
    }

    public boolean showMessage(final String string, final String string2, final int n) {
        if (!PlatformUI.isWorkbenchRunning()) {
            if (n == 1) {
                logger.error(String.valueOf(string) + "> " + string2);
            }
            if (n == 4) {
                logger.warn(String.valueOf(string) + "> " + string2);
            }
            if (n == 2) {
                logger.info(String.valueOf(string) + "> " + string2);
            }
            return true;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)n, (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)string, (String)string2, (int)0);
            }
        });
        return true;
    }

    public void logStatus(final String string, final String string2, final Throwable throwable) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] iEditorReferenceArray;
                try {
                    if (EclipseUtils.getActivePage().findView("org.eclipse.pde.runtime.LogView") == null) {
                        EclipseUtils.getActivePage().showView("org.eclipse.pde.runtime.LogView");
                    }
                }
                catch (PartInitException partInitException) {}
                Activator.getDefault().getLog().log((IStatus)new Status(2, string, string2, throwable));
                IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
                IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart iEditorPart;
                    IEditorReference iEditorReference = iEditorReferenceArray2[n2];
                    if (iEditorReference.getId().equals("com.isencia.passerelle.workbench.model.editor.ui.editors.modelEditor") && (iEditorPart = iEditorReference.getEditor(false)) != null) {
                        ((PasserelleModelMultiPageEditor)iEditorPart).clearActorSelections();
                    }
                    ++n2;
                }
            }
        });
    }

    public Map<String, String> createUserInput(final UserInputBean userInputBean) throws Exception {
        if (!PlatformUI.isWorkbenchRunning()) {
            return userInputBean.getScalarValues();
        }
        if (userInputBean.isSilent()) {
            return userInputBean.getScalarValues();
        }
        final LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue(1);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IUserInputService iUserInputService = (IUserInputService)ServiceManager.getService(IUserInputService.class);
                    RemoveWorkbenchPart removeWorkbenchPart = iUserInputService.openUserInputPart(userInputBean.getPartName(), userInputBean.isDialog());
                    if (userInputBean.getPartName() != null) {
                        removeWorkbenchPart.setPartName(userInputBean.getPartName());
                    }
                    removeWorkbenchPart.setQueue((Queue)linkedBlockingQueue);
                    removeWorkbenchPart.setConfiguration(userInputBean.getConfigurationXML());
                    removeWorkbenchPart.setValues(userInputBean.getScalarValues());
                    if (removeWorkbenchPart instanceof Dialog) {
                        Dialog dialog = (Dialog)removeWorkbenchPart;
                        dialog.open();
                        if (dialog.getReturnCode() != 0) {
                            linkedBlockingQueue.add(Collections.EMPTY_MAP);
                        }
                    }
                    return;
                }
                catch (PartInitException partInitException) {
                }
                catch (Exception exception) {
                    logger.error("Cannot open editor ", (Throwable)exception);
                    linkedBlockingQueue.add(Collections.EMPTY_MAP);
                    return;
                }
                if (userInputBean.getScalarValues() != null) {
                    linkedBlockingQueue.add(userInputBean.getScalarValues());
                } else {
                    linkedBlockingQueue.add(Collections.EMPTY_MAP);
                }
            }
        });
        Map map = (Map)linkedBlockingQueue.take();
        return map;
    }

    public boolean setActorSelected(final String string, final String string2, final boolean bl, final int n) throws Exception {
        ScopedPreferenceStore scopedPreferenceStore;
        boolean bl2;
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        if (Platform.getBundle((String)"org.dawb.workbench.ui") != null && !(bl2 = (scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.workbench.ui")).getBoolean("org.dawb.actor.highlight.choice"))) {
            return false;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (string == null) {
                    logger.error("Cannot open editor because fullPath is null");
                    return;
                }
                try {
                    String string3 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                    String string22 = string;
                    if (string.startsWith(string3)) {
                        string22 = string.substring(string3.length());
                    }
                    IFile iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string22);
                    FileEditorInput fileEditorInput = new FileEditorInput(iFile);
                    IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
                    PasserelleModelMultiPageEditor passerelleModelMultiPageEditor = (PasserelleModelMultiPageEditor)iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
                    if (passerelleModelMultiPageEditor != null) {
                        passerelleModelMultiPageEditor.setActorSelected(string2, bl, n);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot open editor ", (Throwable)exception);
                }
            }
        });
        return true;
    }

    public Object getMockMotorValue(String string) {
        IHardwareService iHardwareService;
        try {
            iHardwareService = (IHardwareService)ServiceManager.getService(IHardwareService.class);
        }
        catch (Exception exception) {
            logger.error("Cannot get the hardware service!", (Throwable)exception);
            return null;
        }
        if (iHardwareService == null) {
            return null;
        }
        return iHardwareService.getMockValue(string);
    }

    public void setMockMotorValue(String string, Object object) {
        IHardwareService iHardwareService;
        try {
            iHardwareService = (IHardwareService)ServiceManager.getService(IHardwareService.class);
        }
        catch (Exception exception) {
            logger.error("Cannot get the hardware service!", (Throwable)exception);
            return;
        }
        if (iHardwareService == null) {
            return;
        }
        iHardwareService.setMockValue(string, object);
    }

    public void notifyMockCommand(String string, String string2, String string3) {
        IHardwareService iHardwareService;
        try {
            iHardwareService = (IHardwareService)ServiceManager.getService(IHardwareService.class);
        }
        catch (Exception exception) {
            logger.error("Cannot get the hardware service!", (Throwable)exception);
            return;
        }
        if (iHardwareService == null) {
            return;
        }
        iHardwareService.notifyMockCommand(string, string2, string3);
    }
}

