/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.project;

import java.lang.reflect.InvocationTargetException;
import org.dawb.passerelle.common.project.PasserelleNewProjectWizardPage;
import org.dawb.passerelle.common.utils.ModelUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PasserelleNewProjectWizard
extends Wizard
implements INewWizard {
    private PasserelleNewProjectWizardPage page;
    private ISelection selection;
    private IProject projectCreated;

    public PasserelleNewProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new PasserelleNewProjectWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String string = this.page.getProjectName();
        final boolean bl = this.page.isExamples();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        PasserelleNewProjectWizard.this.doFinish(string, bl, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Creating " + string, 2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot == null) {
            return;
        }
        try {
            this.projectCreated = ModelUtils.createWorkflowProject(string, iWorkspaceRoot, bl, iProgressMonitor);
        }
        catch (Exception exception) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        iProgressMonitor.done();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public IProject getProjectCreated() {
        return this.projectCreated;
    }
}

