/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.preferences;

import org.dawb.passerelle.common.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.gda.richbeans.components.scalebox.RangeBox;

public class DataAnalysisPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore preferencesStoreWB;
    private RangeBox workbenchPort;
    private String wbProp = "org.dawb.workbench.application.preferences.workbench.port";
    private String wfProp;

    public DataAnalysisPreferencePage() {
        this(null);
    }

    public DataAnalysisPreferencePage(String string) {
        this(string, null);
    }

    public DataAnalysisPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public void init(IWorkbench iWorkbench) {
        this.preferencesStoreWB = Activator.getDefault().getPreferenceStore();
    }

    protected Control createContents(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.workbenchPort = new RangeBox(composite2, 0);
        this.workbenchPort.setIntegerBox(true);
        this.workbenchPort.setLabel("Port for workbench service   ");
        this.workbenchPort.setToolTipText("The workbench service exposes the workbench as a local service for the workflow process to connect to. This allows the workflow to interact with the user interface.");
        this.workbenchPort.setIntegerValue(this.preferencesStoreWB.getInt(this.wbProp));
        this.workbenchPort.setMinimum(0.0);
        this.workbenchPort.setMaximum(65000.0);
        this.workbenchPort.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.workbenchPort.setButtonVisible(false);
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                composite.getShell().setSize(composite.getShell().getSize().x, composite.getShell().getSize().y + 1);
            }
        });
        return composite2;
    }

    public boolean performOk() {
        this.preferencesStoreWB.setValue(this.wbProp, this.workbenchPort.getIntegerValue());
        return super.performOk();
    }

    protected void performDefaults() {
        this.workbenchPort.setIntegerValue(this.preferencesStoreWB.getInt(this.wbProp));
        super.performDefaults();
    }
}

