/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.perspective;

import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.passerelle.common.Activator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowChecking
implements IStartup {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowChecking.class);

    public void earlyStartup() {
        this.createWorkflowsPerspectiveListener();
    }

    private void createWorkflowsPerspectiveListener() {
        final IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        if (iWorkbenchPage != null) {
            iWorkbenchPage.addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart iWorkbenchPart) {
                    this.checkWorkflowPerspective(iWorkbenchPart);
                }

                private void checkWorkflowPerspective(IWorkbenchPart iWorkbenchPart) {
                    String string;
                    if (iWorkbenchPart instanceof IPasserelleMultiPageEditor && !(string = iWorkbenchPage.getPerspective().getId()).equals("org.edna.workbench.application.perspective.WorkflowPerspective")) {
                        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
                        String string2 = iPreferenceStore.getString("org.dawb.passerelle.common.remember.workflowopening");
                        boolean bl = false;
                        if (string2.equals("prompt") && System.getProperty("org.dawb.test.session") == null) {
                            MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)iWorkbenchPage.getWorkbenchWindow().getShell(), (String)"Open Workflow Perspective", (String)"This kind of file is associated with the 'Workflow' Perspective.\n\nWould you like to switch to the workflow perspective now?", (String)"Remember my decision", (boolean)false, (IPreferenceStore)iPreferenceStore, (String)"org.dawb.passerelle.common.remember.workflowopening");
                            switch (messageDialogWithToggle.getReturnCode()) {
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    bl = false;
                                }
                            }
                        } else if (string2.equals("always")) {
                            bl = true;
                        }
                        if (bl) {
                            try {
                                PlatformUI.getWorkbench().showPerspective("org.edna.workbench.application.perspective.WorkflowPerspective", iWorkbenchPage.getWorkbenchWindow());
                            }
                            catch (Exception exception) {
                                logger.error(exception.getMessage(), (Throwable)exception);
                            }
                        }
                    }
                }

                public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
                }

                public void partClosed(IWorkbenchPart iWorkbenchPart) {
                }

                public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
                }

                public void partActivated(IWorkbenchPart iWorkbenchPart) {
                }
            });
        }
    }
}

