/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.parameter;

import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.Grep;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import org.eclipse.core.variables.VariablesPlugin;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.NamedObj;

public class ParameterUtils {
    public static final String VARIABLE_EXPRESSION = "\\$\\{([a-zA-Z0-9_ ]+)\\}";

    public static String getSubstituedValue(Parameter parameter) throws Exception {
        return ParameterUtils.getSubstituedValue(parameter, null);
    }

    public static String getSubstituedValue(Parameter parameter, DataMessageComponent dataMessageComponent) throws Exception {
        String string = parameter.getExpression();
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        List list = Grep.group((String)string, (String)VARIABLE_EXPRESSION, (int)1);
        Map<String, String> map = MessageUtils.getValues(dataMessageComponent, (Collection)list, parameter.getContainer());
        try {
            VariablesPlugin.getDefault().getStringVariableManager().validateStringVariables(string);
            string = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string, false);
        }
        catch (Throwable throwable) {}
        string = SubstituteUtils.substitute((String)string, map);
        return string;
    }

    public static String getSubstituedValue(Parameter parameter, List<DataMessageComponent> list) throws Exception {
        String string = parameter.getExpression();
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        List list2 = Grep.group((String)string, (String)VARIABLE_EXPRESSION, (int)1);
        Map<String, String> map = MessageUtils.getValues(list, (Collection)list2, parameter.getContainer());
        try {
            VariablesPlugin.getDefault().getStringVariableManager().validateStringVariables(string);
            string = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string, false);
        }
        catch (Throwable throwable) {}
        string = SubstituteUtils.substitute((String)string, map);
        return string;
    }

    public static String substitute(String string, NamedObj namedObj) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        if (namedObj != null) {
            if (ModelUtils.getProject((NamedObj)namedObj) != null) {
                hashMap.put("project_name", ModelUtils.getProject((NamedObj)namedObj).getName());
            }
            hashMap.put("actor_name", namedObj.getName());
        }
        MultiVariableExpander multiVariableExpander = new MultiVariableExpander();
        multiVariableExpander.addSource("$", hashMap);
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor((VariableExpander)multiVariableExpander);
        try {
            VariablesPlugin.getDefault().getStringVariableManager().validateStringVariables(string);
            string = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string, false);
        }
        catch (Throwable throwable) {}
        return variableSubstitutor.substitute(string);
    }
}

