/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.message;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dawb.common.util.xml.XMLUtils;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.Variable;

public class XPathVariable
extends Variable
implements IVariable {
    protected String xPath;
    protected String rename;
    private static final Pattern XPATH_PATTERN = Pattern.compile("\\@RENAME\\;\\'([a-zA-Z0-9_ ]+)\\'\\,(.+)");

    public XPathVariable(String string, String string2) {
        super(string, IVariable.VARIABLE_TYPE.XML, "<xpath>?defined by " + XPathVariable.getxPath(string2) + "</xpath>");
        this.xPath = XPathVariable.getxPath(string2);
        this.rename = XPathVariable.getRename(string2);
    }

    public String getSaveString() {
        if (this.rename == null || "".equals(this.rename)) {
            return this.getxPath();
        }
        return "@RENAME;'" + this.getRename() + "'," + this.getxPath();
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String string) {
        this.xPath = string;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.rename == null ? 0 : this.rename.hashCode());
        n = 31 * n + (this.xPath == null ? 0 : this.xPath.hashCode());
        return n;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.rename = string;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XPathVariable xPathVariable = (XPathVariable)object;
        if (this.rename == null ? xPathVariable.rename != null : !this.rename.equals(xPathVariable.rename)) {
            return false;
        }
        return !(this.xPath == null ? xPathVariable.xPath != null : !this.xPath.equals(xPathVariable.xPath));
    }

    private static String getxPath(String string) {
        Matcher matcher = XPATH_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }

    private static String getRename(String string) {
        Matcher matcher = XPATH_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Map<String, String> getXPaths(Map map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        for (Object k : map.keySet()) {
            hashMap.put((String)k, XPathVariable.getxPath((String)map.get(k)));
        }
        return hashMap;
    }

    public static Map<String, String> getRenames(Map map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        for (Object k : map.keySet()) {
            String string = XPathVariable.getRename((String)map.get(k));
            if (string == null || "".equals(string)) continue;
            hashMap.put((String)k, string);
        }
        return hashMap;
    }

    @Override
    public String getErrorMessage() {
        if (super.getErrorMessage() != null) {
            return super.getErrorMessage();
        }
        try {
            if (this.getxPath() != null && !"".equals(this.getxPath().trim())) {
                XMLUtils.isLegalXPath((String)this.getxPath());
            }
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            if (exception.getCause().getMessage() != null) {
                return exception.getCause().getMessage();
            }
            return "Problem parsing xpath '" + this.getxPath() + "'";
        }
        if (this.rename != null && !"".equals(this.rename.trim()) && !this.rename.matches("[a-zA-Z0-9_]+")) {
            return "The rename tag must be alphnumeric and not contain spaces.";
        }
        return null;
    }
}

