/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.message;

import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.util.ArrayUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.util.ExpressionUtils;
import org.dawb.passerelle.common.DatasetConstants;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;

public class MessageUtils {
    private static Logger logger = LoggerFactory.getLogger(MessageUtils.class);

    public static DataMessageComponent coerceMessage(ManagedMessage managedMessage) throws Exception {
        Object object;
        Object object2;
        if (managedMessage instanceof ErrorMessageContainer && (object2 = (object = (ErrorMessageContainer)managedMessage).getBodyContent()) instanceof DataMessageException) {
            return ((DataMessageException)((Object)object2)).getDataMessageComponent();
        }
        object = managedMessage.getBodyContent();
        if (object instanceof DataMessageComponent) {
            return (DataMessageComponent)object;
        }
        if (managedMessage.getBodyContent() instanceof String) {
            object2 = new DataMessageComponent();
            ((DataMessageComponent)object2).putScalar("message_text", (String)object);
            return object2;
        }
        object2 = MessageUtils.coerceData(managedMessage);
        IMetaData iMetaData = MessageUtils.coerceMeta(managedMessage);
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        dataMessageComponent.setList((Map<String, Serializable>)object2);
        dataMessageComponent.setMeta(iMetaData);
        return dataMessageComponent;
    }

    public static boolean isErrorMessage(ManagedMessage managedMessage) {
        return managedMessage instanceof ErrorMessageContainer;
    }

    public static boolean isErrorMessage(List<DataMessageComponent> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (DataMessageComponent dataMessageComponent : list) {
            if (!dataMessageComponent.isError()) continue;
            return true;
        }
        return false;
    }

    public static IMetaData coerceMeta(final ManagedMessage managedMessage) throws Exception {
        Object object = managedMessage.getBodyContent();
        if (object instanceof DataMessageComponent) {
            return ((DataMessageComponent)object).getMeta();
        }
        return new MetaDataAdapter(){

            public Collection<String> getDataNames() {
                try {
                    return managedMessage.getAllBodyHeaders();
                }
                catch (MessageException messageException) {
                    logger.error("Cannot get data names from ManagedMessage", (Throwable)messageException);
                    return null;
                }
            }

            public String getMetaValue(String string) {
                try {
                    return managedMessage.getBodyHeader(string)[0];
                }
                catch (MessageException messageException) {
                    logger.error("Cannot get data names from ManagedMessage", (Throwable)messageException);
                    return null;
                }
            }
        };
    }

    public static Map<String, Serializable> coerceData(ManagedMessage managedMessage) throws Exception {
        Object object = managedMessage.getBodyContent();
        if (object instanceof DataMessageComponent) {
            return ((DataMessageComponent)object).getList();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof IDataset) {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(1);
            IDataset iDataset = (IDataset)object;
            hashMap.put(iDataset.getName() != null ? iDataset.getName() : "sum", (Serializable)iDataset);
            return hashMap;
        }
        if (object.getClass().isArray()) {
            Object object2;
            Object object3;
            DoubleDataset doubleDataset;
            int[] nArray;
            String[] stringArray = managedMessage.getBodyHeader("shape");
            if (stringArray == null) {
                nArray = new int[]{1};
            } else {
                nArray = new int[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                    ++n;
                }
            }
            if (object instanceof double[]) {
                doubleDataset = new DoubleDataset((double[])object, nArray);
            } else if (object instanceof Double[]) {
                object3 = (Double[])object;
                object2 = new double[((Double[])object3).length];
                int n = 0;
                while (n < ((double[])object2).length) {
                    object2[n] = (Double)object3[n];
                    ++n;
                }
                doubleDataset = new DoubleDataset((double[])object2, nArray);
            } else if (object instanceof Number[]) {
                object3 = (Number[])object;
                object2 = new double[((Number[])object3).length];
                int n = 0;
                while (n < ((double[])object2).length) {
                    object2[n] = object3[n].doubleValue();
                    ++n;
                }
                doubleDataset = new DoubleDataset((double[])object2, nArray);
            } else {
                throw new Exception("Cannot process data of type " + object.getClass());
            }
            object3 = managedMessage.getBodyHeader("name")[0];
            if (object3 == null) {
                object3 = "data";
            }
            object2 = new HashMap(1);
            object2.put(object3, doubleDataset);
            return object2;
        }
        throw new Exception("Cannot process data of type " + object.getClass());
    }

    public static List<IDataset> getDatasets(List<DataMessageComponent> list) {
        ArrayList<IDataset> arrayList = null;
        for (DataMessageComponent dataMessageComponent : list) {
            List<IDataset> list2;
            if (dataMessageComponent == null || dataMessageComponent.getList() == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IDataset>(7);
            }
            if ((list2 = MessageUtils.getDatasets(dataMessageComponent)) == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static List<IDataset> getDatasets(DataMessageComponent dataMessageComponent) {
        ArrayList<IDataset> arrayList = null;
        if (dataMessageComponent == null || dataMessageComponent.getList() == null) {
            return null;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<IDataset>(7);
        }
        Collection<Serializable> collection = dataMessageComponent.getList().values();
        for (Serializable serializable : collection) {
            if (!(serializable instanceof IDataset)) continue;
            arrayList.add((IDataset)serializable);
        }
        return arrayList;
    }

    public static IMetaData getMeta(List<DataMessageComponent> list) {
        ArrayList<IMetaData> arrayList = null;
        for (DataMessageComponent dataMessageComponent : list) {
            if (dataMessageComponent == null || dataMessageComponent.getMeta() == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IMetaData>(3);
            }
            arrayList.add(dataMessageComponent.getMeta());
        }
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (IMetaData)arrayList.get(0);
        }
        return null;
    }

    public static Map<String, String> getScalar(List<DataMessageComponent> list) {
        HashMap<String, String> hashMap = null;
        for (DataMessageComponent dataMessageComponent : list) {
            Map<String, String> map;
            if (dataMessageComponent == null || dataMessageComponent.getScalar() == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>(7);
            }
            if ((map = dataMessageComponent.getScalar()) == null) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public static Map<String, Serializable> getList(List<DataMessageComponent> list) {
        HashMap<String, Serializable> hashMap = null;
        for (DataMessageComponent dataMessageComponent : list) {
            Map<String, Serializable> map;
            if (dataMessageComponent == null || dataMessageComponent.getList() == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Serializable>(7);
            }
            if ((map = dataMessageComponent.getList()) == null) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public static ManagedMessage getDataMessage(DataMessageComponent dataMessageComponent) throws Exception {
        if (dataMessageComponent == null) {
            return null;
        }
        ManagedMessage managedMessage = MessageFactory.getInstance().createMessage();
        managedMessage.setBodyContent((Object)dataMessageComponent, DatasetConstants.CONTENT_TYPE_DATA);
        return managedMessage;
    }

    public static String getNames(Collection<? extends Serializable> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return MessageUtils.getNames(collection.toArray(new IDataset[collection.size()]));
    }

    public static String getNames(IDataset ... iDatasetArray) {
        if (iDatasetArray == null || iDatasetArray.length < 1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < iDatasetArray.length) {
            IDataset iDataset = iDatasetArray[n];
            stringBuilder.append(iDataset.getName());
            if (n < iDatasetArray.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getValues(DataMessageComponent dataMessageComponent, NamedObj namedObj) throws Exception {
        return MessageUtils.getValues(dataMessageComponent, null, namedObj);
    }

    public static Map<String, String> getValues(DataMessageComponent dataMessageComponent, Collection collection, NamedObj namedObj) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>(7);
        if (collection == null) {
            Collection<String> collection2 = collection = dataMessageComponent != null ? dataMessageComponent.getScalar().keySet() : Collections.EMPTY_SET;
        }
        if (dataMessageComponent != null) {
            for (Object e : collection) {
                String string = e.toString();
                String string2 = dataMessageComponent.getScalar(string);
                if (string2 == null) {
                    Object object = dataMessageComponent.getList(string);
                    if (object != null && object.getClass().isArray()) {
                        string2 = ArrayUtil.toString((Object)object);
                    }
                    if (string2 == null && object != null) {
                        string2 = object.toString();
                    }
                }
                if (string2 == null) continue;
                hashMap.put(string, string2);
            }
        }
        if (namedObj != null) {
            if (ModelUtils.getProject((NamedObj)namedObj) != null) {
                hashMap.put("project_name", ModelUtils.getProject((NamedObj)namedObj).getName());
            }
            hashMap.put("actor_name", namedObj.getName());
        }
        return hashMap;
    }

    public static Map<String, String> getValues(List<DataMessageComponent> list, NamedObj namedObj) throws Exception {
        return MessageUtils.getValues(list, null, namedObj);
    }

    public static Map<String, String> getValues(List<DataMessageComponent> list, Collection collection, NamedObj namedObj) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>(list.size() * 7);
        for (DataMessageComponent dataMessageComponent : list) {
            Map<String, String> map = MessageUtils.getValues(dataMessageComponent, collection, null);
            for (String string : map.keySet()) {
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, map.get(string));
                    continue;
                }
                DataMessageComponent.VALUE_TYPE vALUE_TYPE = dataMessageComponent.getValueType(string);
                if (vALUE_TYPE == null || vALUE_TYPE == DataMessageComponent.VALUE_TYPE.OVERWRITE_STRING) {
                    hashMap.put(string, map.get(string));
                    continue;
                }
                if (vALUE_TYPE != DataMessageComponent.VALUE_TYPE.ADDITIVE_STRING) continue;
                hashMap.put(string, String.valueOf((String)hashMap.get(string)) + "\n" + map.get(string));
            }
        }
        if (namedObj != null) {
            if (ModelUtils.getProject((NamedObj)namedObj) != null) {
                hashMap.put("project_name", ModelUtils.getProject((NamedObj)namedObj).getName());
            }
            hashMap.put("actor_name", namedObj.getName());
        }
        return hashMap;
    }

    public static DataMessageComponent copy(List<DataMessageComponent> list) {
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        for (DataMessageComponent dataMessageComponent2 : list) {
            dataMessageComponent.add(dataMessageComponent2);
        }
        return dataMessageComponent;
    }

    public static boolean isScalarOnly(Collection<DataMessageComponent> collection) {
        for (DataMessageComponent dataMessageComponent : collection) {
            if (!dataMessageComponent.isScalarOnly()) continue;
            return true;
        }
        return false;
    }

    public static List<DataMessageComponent> mergeScalar(List<DataMessageComponent> list) {
        ArrayList<DataMessageComponent> arrayList = new ArrayList<DataMessageComponent>(3);
        ArrayList<DataMessageComponent> arrayList2 = new ArrayList<DataMessageComponent>(3);
        for (DataMessageComponent dataMessageComponent : list) {
            if (dataMessageComponent.isScalarOnly()) {
                arrayList2.add(dataMessageComponent);
                continue;
            }
            arrayList.add(dataMessageComponent);
        }
        if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
            DataMessageComponent dataMessageComponent;
            dataMessageComponent = (DataMessageComponent)arrayList.get(0);
            for (DataMessageComponent dataMessageComponent2 : arrayList2) {
                dataMessageComponent.addScalar(dataMessageComponent2.getScalar());
            }
            return arrayList;
        }
        return list;
    }

    public static DataMessageComponent mergeAll(Collection<DataMessageComponent> collection) {
        DataMessageComponent dataMessageComponent = new DataMessageComponent();
        for (DataMessageComponent dataMessageComponent2 : collection) {
            dataMessageComponent.add(dataMessageComponent2);
        }
        return dataMessageComponent;
    }

    public static boolean isDataMessage(ManagedMessage managedMessage) {
        block3: {
            try {
                String string = managedMessage.getBodyContentType();
                if (!DatasetConstants.CONTENT_TYPE_DATA.equals(string)) break block3;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return managedMessage.getBodyContent() instanceof DataMessageComponent;
    }

    public static boolean isExpressionTrue(String string, ManagedMessage managedMessage) throws Exception {
        DataMessageComponent dataMessageComponent = (DataMessageComponent)managedMessage.getBodyContent();
        return MessageUtils.isExpressionTrue(string, dataMessageComponent);
    }

    public static boolean isExpressionTrue(String string, DataMessageComponent dataMessageComponent) throws Exception {
        double d = MessageUtils.evaluateExpression(string, dataMessageComponent);
        boolean bl = d != 0.0 && !Double.isNaN(d) && !Double.isInfinite(d);
        return bl;
    }

    public static double evaluateExpression(String string, DataMessageComponent dataMessageComponent) throws Exception {
        return ExpressionUtils.evaluateExpression((String)string, dataMessageComponent.getScalar());
    }
}

