/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.message;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import java.util.Collection;
import javax.management.MBeanServerConnection;
import org.dawb.passerelle.common.Activator;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;

public class DataMessageException
extends ProcessingException {
    private static final long serialVersionUID = 7005072679084823511L;
    private DataMessageComponent dataMessageComponent;

    public DataMessageException(String string, Object object, Throwable throwable) {
        this(string, object, new DataMessageComponent(), throwable);
    }

    public DataMessageException(String string, Object object, Collection<DataMessageComponent> collection, Throwable throwable) {
        this(string, object, MessageUtils.mergeAll(collection), throwable);
    }

    public DataMessageException(String string, Object object, DataMessageComponent dataMessageComponent, Throwable throwable) {
        super(PasserelleException.Severity.NON_FATAL, string, object, throwable);
        this.dataMessageComponent = dataMessageComponent;
        this.dataMessageComponent.putScalar("message_text", string);
        this.dataMessageComponent.setError(true);
        if (throwable != null) {
            this.dataMessageComponent.putScalar("exception_text", throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName());
        }
        try {
            MBeanServerConnection mBeanServerConnection = RemoteWorkbenchAgent.getServerConnection((long)1000L);
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "logStatus", new Object[]{Activator.getDefault().getBundle().getSymbolicName(), string, throwable}, new String[]{String.class.getName(), String.class.getName(), Throwable.class.getName()});
        }
        catch (Throwable throwable2) {}
    }

    public DataMessageComponent getDataMessageComponent() {
        return this.dataMessageComponent;
    }

    public void setDataMessageComponent(DataMessageComponent dataMessageComponent) {
        this.dataMessageComponent = dataMessageComponent;
    }
}

