/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.gda.util.map.MapUtils;

public class DataMessageComponent {
    private Map<String, Serializable> list;
    private Map<String, String> scalar;
    private IMetaData meta;
    private Map<String, VALUE_TYPE> valueTypes;
    private boolean error = false;

    public Map<String, Serializable> getList() {
        return this.list;
    }

    public Object getList(String string) {
        if (this.list != null) {
            return this.list.get(string);
        }
        return null;
    }

    public void setList(Map<String, Serializable> map) {
        this.list = map;
    }

    public IMetaData getMeta() {
        return this.meta;
    }

    public void setMeta(IMetaData iMetaData) {
        this.meta = iMetaData;
    }

    public void setList(IDataset iDataset) {
        String string;
        if (this.list == null) {
            this.list = new LinkedHashMap<String, Serializable>(1);
        }
        if ((string = iDataset.getName()) == null || "".equals(string)) {
            string = "Unknown";
        }
        MapUtils.putUnique(this.list, (String)string, (Object)iDataset);
    }

    public void addScalar(Map<String, String> map) {
        this.addScalar(map, true);
    }

    public void addScalar(Map<String, String> map, boolean bl) {
        if (map == null) {
            return;
        }
        if (this.scalar == null) {
            this.scalar = new Hashtable<String, String>(map.size());
        }
        if (bl) {
            for (String string : map.keySet()) {
                if (map.get(string) == null) continue;
                this.scalar.remove(string);
                this.scalar.put(string, map.get(string));
            }
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            hashMap.keySet().removeAll(this.scalar.keySet());
            for (String string : hashMap.keySet()) {
                if (hashMap.get(string) == null) continue;
                this.scalar.put(string, (String)hashMap.get(string));
            }
        }
    }

    public void putScalar(String string, String string2) {
        if (string2 == null && this.scalar != null) {
            this.scalar.remove(string);
            return;
        }
        if (this.scalar == null) {
            this.scalar = new Hashtable<String, String>(1);
        }
        this.scalar.put(string, string2);
    }

    public Map<String, String> getScalar() {
        return this.scalar;
    }

    public String getScalar(String string) {
        if (this.scalar == null) {
            return null;
        }
        return this.scalar.get(string);
    }

    public String toString() {
        TreeSet<String> treeSet;
        String string = "";
        if (this.list != null && !this.list.isEmpty()) {
            treeSet = new TreeSet<String>(this.list.keySet());
            for (String string2 : treeSet) {
                string = String.valueOf(string) + this.formatString(string2, this.list.get(string2).toString()) + "\n";
            }
        }
        if (this.scalar != null && !this.scalar.isEmpty()) {
            treeSet = new TreeSet<String>(this.scalar.keySet());
            for (String string2 : treeSet) {
                string = String.valueOf(string) + this.formatString(string2, this.scalar.get(string2).toString()) + "\n";
            }
        }
        if (this.meta != null) {
            string = String.valueOf(string) + this.meta.toString();
        }
        if (string.equals("")) {
            string = super.toString();
        }
        return string;
    }

    private String formatString(String string, String string2) {
        int n = 60;
        int n2 = 20;
        String string3 = string;
        String string4 = string2.replaceAll("\n", "");
        if (string3.length() < n2) {
            string3 = String.format("%1$-" + n2 + "s", string3);
        }
        if (string4.length() > n) {
            string4 = String.valueOf(string4.substring(0, n)) + "...";
        }
        return String.valueOf(string3) + " : " + string4;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.list == null ? 0 : this.list.hashCode());
        n = 31 * n + (this.scalar == null ? 0 : this.scalar.hashCode());
        n = 31 * n + (this.meta == null ? 0 : this.meta.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataMessageComponent dataMessageComponent = (DataMessageComponent)object;
        if (this.list == null ? dataMessageComponent.list != null : !this.list.equals(dataMessageComponent.list)) {
            return false;
        }
        if (this.scalar == null ? dataMessageComponent.scalar != null : !this.scalar.equals(dataMessageComponent.scalar)) {
            return false;
        }
        return !(this.meta == null ? dataMessageComponent.meta != null : !this.meta.equals(dataMessageComponent.meta));
    }

    public VALUE_TYPE getValueType(String string) {
        if (this.valueTypes == null) {
            return VALUE_TYPE.OVERWRITE_STRING;
        }
        return this.valueTypes.get(string);
    }

    public void setValueType(String string, VALUE_TYPE vALUE_TYPE) {
        if (this.valueTypes == null) {
            this.valueTypes = new Hashtable<String, VALUE_TYPE>(7);
        }
        this.valueTypes.put(string, vALUE_TYPE);
    }

    public void add(DataMessageComponent dataMessageComponent) {
        if (dataMessageComponent.list != null) {
            if (this.list == null) {
                this.list = new LinkedHashMap<String, Serializable>(dataMessageComponent.list.size());
            }
            this.list.putAll(dataMessageComponent.list);
        }
        if (dataMessageComponent.scalar != null) {
            if (this.scalar == null) {
                this.scalar = new Hashtable<String, String>(dataMessageComponent.scalar.size());
            }
            this.scalar.putAll(dataMessageComponent.scalar);
        }
        if (dataMessageComponent.meta != null) {
            this.meta = dataMessageComponent.meta;
        }
        if (dataMessageComponent.valueTypes != null) {
            if (this.valueTypes == null) {
                this.valueTypes = new Hashtable<String, VALUE_TYPE>(dataMessageComponent.valueTypes.size());
            }
            this.valueTypes.putAll(dataMessageComponent.valueTypes);
        }
    }

    public boolean isScalarOnly() {
        return (this.list == null || this.list.isEmpty()) && this.scalar != null && this.scalar.size() > 0;
    }

    public void addList(String string, AbstractDataset abstractDataset) {
        if (this.list == null) {
            this.list = new LinkedHashMap<String, Serializable>(1);
        }
        this.list.put(string, (Serializable)abstractDataset);
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public static enum VALUE_TYPE {
        ADDITIVE_STRING,
        OVERWRITE_STRING;

    }
}

