/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.message;

import java.util.Arrays;

public class AbstractDatasetProvider {
    private final int[] shape;
    private final int dType;
    private String cachedValue;
    private static final String SEPARATOR = ",";
    private static final String SPACING = " ";
    private static final String ELLIPSES = "...";
    private static final String NEWLINE = "\n";
    private static final int MAX_SUBBLOCKS = 6;
    private static final int MAX_STRING_LENGTH = 120;

    public AbstractDatasetProvider() {
        this(null, 5);
    }

    public AbstractDatasetProvider(int[] nArray) {
        this(nArray, 5);
    }

    public AbstractDatasetProvider(int[] nArray, int n) {
        this.shape = nArray;
        this.dType = n;
    }

    public String toString() {
        if (this.shape == null) {
            return this.getString();
        }
        if (this.cachedValue == null) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            this.printBlocks(stringBuilder, stringBuilder2, 0, new int[this.getRank()]);
            this.cachedValue = stringBuilder.toString();
        }
        return this.cachedValue;
    }

    private String getString() {
        switch (this.dType) {
            case 2: {
                return "1, 2, 3...";
            }
            case 3: {
                return "1, 2, 3...";
            }
            case 4: {
                return "1, 2, 3...";
            }
            case 5: {
                return "1.0, 2.0, 3.0...";
            }
            case 6: {
                return "1.0, 2.0, 3.0...";
            }
        }
        return "1.0, 2.0, 3.0...";
    }

    private String getString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            switch (this.dType) {
                case 2: {
                    stringBuilder.append(String.valueOf(n2));
                    break;
                }
                case 3: {
                    stringBuilder.append(String.valueOf(n2));
                    break;
                }
                case 4: {
                    stringBuilder.append(String.valueOf(n2));
                    break;
                }
                case 5: {
                    stringBuilder.append(String.valueOf((float)n2));
                    break;
                }
                case 6: {
                    stringBuilder.append(String.valueOf((double)n2));
                    break;
                }
                default: {
                    stringBuilder.append(String.valueOf((double)n2));
                }
            }
            if (n < nArray.length - 1) {
                stringBuilder.append(" ,");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private int getRank() {
        return this.shape != null ? this.shape.length : 1;
    }

    private void printBlocks(StringBuilder stringBuilder, StringBuilder stringBuilder2, int n, int[] nArray) {
        int n2;
        String string;
        if (stringBuilder.length() > 0 && !(string = stringBuilder.substring(stringBuilder.length() - 1)).equals("[")) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if (n != (n2 = this.getRank() - 1)) {
            stringBuilder.append('[');
            int n3 = this.shape[n];
            nArray[n] = 0;
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
            stringBuilder3.append(SPACING);
            this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
            if (n3 < 2) {
                stringBuilder.append(']');
                return;
            }
            stringBuilder.append(",\n");
            int n4 = n + 1;
            while (n4 < n2) {
                stringBuilder.append(NEWLINE);
                ++n4;
            }
            if (n3 < 6) {
                n4 = 1;
                while (n4 < n3 - 1) {
                    nArray[n] = n4;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n4;
                }
            } else {
                n4 = n3 - 6;
                int n5 = (n3 - n4) / 2;
                int n6 = 1;
                while (n6 < n5) {
                    nArray[n] = n6;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n6;
                }
                stringBuilder.append((CharSequence)stringBuilder3);
                stringBuilder.append("...,\n");
                n6 = n5 = (n3 + n4) / 2;
                while (n6 < n3 - 1) {
                    nArray[n] = n6;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n6;
                }
            }
            nArray[n] = n3 - 1;
            this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
            stringBuilder.append(']');
        } else {
            stringBuilder.append((CharSequence)this.makeLine(n2, nArray));
        }
    }

    private StringBuilder makeLine(int n, int ... nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = n >= nArray.length ? Arrays.copyOf(nArray, n + 1) : nArray;
        nArray2[n] = 0;
        stringBuilder.append('[');
        stringBuilder.append(this.getString(nArray2));
        int n3 = this.shape[n];
        int n4 = n3 - 40;
        if (n4 > 0) {
            n2 = (n3 - n4) / 2;
            int n5 = 1;
            while (n5 < n2) {
                stringBuilder.append(", ");
                nArray2[n] = n5++;
                stringBuilder.append(this.getString(nArray2));
            }
            n5 = n2 = (n3 + n4) / 2;
            while (n5 < n3) {
                stringBuilder.append(", ");
                nArray2[n] = n5++;
                stringBuilder.append(this.getString(nArray2));
            }
        } else {
            n2 = 1;
            while (n2 < n3) {
                stringBuilder.append(", ");
                nArray2[n] = n2++;
                stringBuilder.append(this.getString(nArray2));
            }
        }
        stringBuilder.append(']');
        n4 = stringBuilder.length() - 120 - ELLIPSES.length() - 1;
        if (n4 > 0) {
            n2 = stringBuilder.substring(0, (stringBuilder.length() - n4) / 2).lastIndexOf(SEPARATOR) + 2;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.subSequence(0, n2));
            stringBuilder2.append("...,");
            n2 = stringBuilder.substring((stringBuilder.length() + n4) / 2).indexOf(SEPARATOR) + (stringBuilder.length() + n4) / 2 + 1;
            stringBuilder2.append(stringBuilder.subSequence(n2, stringBuilder.length()));
            return stringBuilder2;
        }
        return stringBuilder;
    }
}

