/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class DatWriter {
    private Map<String, String> meta;
    private File file;
    private List<IDataset> data;
    private String dataFormat = "#0.0000";
    private boolean isWriteIndex = true;

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> map) {
        this.meta = map;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<IDataset> getData() {
        return this.data;
    }

    public void addData(IDataset iDataset) {
        if (this.data == null) {
            this.data = new ArrayList<IDataset>(7);
        }
        this.data.add(iDataset);
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public void write() throws Exception {
        int n = this.data.get(0).getSize();
        for (IDataset object2 : this.data) {
            if (object2.getShape().length != 1) {
                throw new Exception("Currrently DatWriter only supports 1D datasets!");
            }
            if (object2.getSize() == n) continue;
            throw new Exception("All the data sets for writing should be size " + n);
        }
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file.getParentFile().mkdirs();
        this.file.createNewFile();
        DecimalFormat decimalFormat = new DecimalFormat(this.getDataFormat());
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
        try {
            if (this.meta != null) {
                for (String string : this.meta.keySet()) {
                    bufferedWriter.write("# ");
                    bufferedWriter.write(string);
                    bufferedWriter.write(" = ");
                    bufferedWriter.write(this.meta.get(string));
                    bufferedWriter.newLine();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("# ");
            if (this.isWriteIndex) {
                stringBuilder.append("Index");
                stringBuilder.append("   \t");
            }
            for (IDataset n2 : this.data) {
                stringBuilder.append(n2.getName());
                stringBuilder.append("   \t");
            }
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.newLine();
            int n2 = 0;
            while (n2 < n) {
                bufferedWriter.write(" ");
                if (this.isWriteIndex) {
                    bufferedWriter.write(String.valueOf(n2));
                    bufferedWriter.write("   \t");
                }
                for (IDataset iDataset : this.data) {
                    bufferedWriter.write(decimalFormat.format(iDataset.getDouble(new int[]{n2})));
                    bufferedWriter.write("   \t");
                }
                bufferedWriter.newLine();
                ++n2;
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    public boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    public void setWriteIndex(boolean bl) {
        this.isWriteIndex = bl;
    }
}

